/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.world.gen.structure;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.init.Blocks;

public class DecayRuleKeyRegistry {
    private static Map<String, Map<String, String>> registry = new HashMap<String, Map<String, String>>();
    private static DecayRuleKeyRegistry instance = new DecayRuleKeyRegistry();

    private DecayRuleKeyRegistry() {
    }

    public static DecayRuleKeyRegistry getInstance() {
        return instance;
    }

    void register(String name, Map<String, String> map) {
        if (!registry.containsKey(name)) {
            registry.put(name, map);
        }
    }

    private void unregister(String name) {
        if (registry.containsKey(name)) {
            registry.remove(name);
        }
    }

    public Map<String, String> get(Class<?> clazz) {
        if (registry.containsKey(clazz.getName())) {
            return registry.get(clazz.getName());
        }
        return null;
    }

    public String get(String name, String metaKey) {
        if (registry.containsKey(name)) {
            Map<String, String> mapping = registry.get(name);
            return mapping.get(metaKey);
        }
        return null;
    }

    public boolean has(String name) {
        return registry.containsKey(name);
    }

    static {
        HashMap<String, String> stoneMapping = new HashMap<String, String>();
        stoneMapping.put("0", "minecraft:stone");
        stoneMapping.put("1", "minecraft:granite");
        stoneMapping.put("2", "minecraft:smooth_granite");
        stoneMapping.put("3", "minecraft:diorite");
        stoneMapping.put("4", "minecraft:smooth_diorite");
        stoneMapping.put("5", "minecraft:andesite");
        stoneMapping.put("6", "minecraft:smooth_andesite");
        HashMap sandstoneMapping = new HashMap();
        registry.put(Blocks.field_150348_b.getRegistryName().toString(), stoneMapping);
        registry.put(Blocks.field_150322_A.getRegistryName().toString(), sandstoneMapping);
    }
}

