/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.version;

public class BuildVersion {
    public static BuildVersion EMPTY_VERSION = new BuildVersion(-1, -1, -1);
    private int major = -1;
    private int minor = -1;
    private int build = -1;

    public BuildVersion() {
    }

    public BuildVersion(int major, int minor, int build) {
        this.major = major;
        this.minor = minor;
        this.build = build;
    }

    public BuildVersion(String version) {
        if (version == null || version.equals("")) {
            return;
        }
        String[] parts = version.split("\\.");
        if (parts.length >= 1) {
            this.setMajor(Integer.valueOf(parts[0]));
        }
        if (parts.length >= 2) {
            this.setMinor(Integer.valueOf(parts[1]));
        }
        if (parts.length >= 3) {
            this.setBuild(Integer.valueOf(parts[2]));
        }
    }

    public boolean isEmpty() {
        return this.equals(EMPTY_VERSION);
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getBuild() {
        return this.build;
    }

    public void setBuild(int build) {
        this.build = build;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.build;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.build;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BuildVersion other = (BuildVersion)obj;
        if (this.build != other.build) {
            return false;
        }
        if (this.major != other.major) {
            return false;
        }
        return this.minor == other.minor;
    }
}

