/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.property;

import com.google.common.base.Predicate;
import com.someguyssoftware.gottschcore.property.FacingPropertyCopier;
import com.someguyssoftware.gottschcore.property.FenceGatePropertyCopier;
import com.someguyssoftware.gottschcore.property.IPropertyCopier;
import com.someguyssoftware.gottschcore.property.LogPropertyCopier;
import com.someguyssoftware.gottschcore.property.OldLogPropertyCopier;
import com.someguyssoftware.gottschcore.property.PlanksPropertyCopier;
import com.someguyssoftware.gottschcore.property.PropertyCopierRegistry;
import com.someguyssoftware.gottschcore.property.StairsPropertyCopier;
import com.someguyssoftware.gottschcore.property.VinePropertyCopier;
import com.someguyssoftware.gottschcore.property.WallPropertyCopier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockVine;
import net.minecraft.block.BlockWall;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;

public class PropertyHelper {
    private static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static IPropertyCopier stairsPropertyCopier = new StairsPropertyCopier();
    public static IPropertyCopier logPropertyCopier = new LogPropertyCopier();
    public static IPropertyCopier oldLogPropertyCopier = new OldLogPropertyCopier();
    public static IPropertyCopier vinePropertyCopier = new VinePropertyCopier();
    public static IPropertyCopier wallPropertyCopier = new WallPropertyCopier();
    public static IPropertyCopier fenceGatePropertyCopier = new FenceGatePropertyCopier();
    public static IPropertyCopier planksPropertyCopier = new PlanksPropertyCopier();
    public static IPropertyCopier facingPropertyCopier = new FacingPropertyCopier();

    private PropertyHelper() {
    }

    private static void registerBlocks() {
        PropertyCopierRegistry registry = PropertyCopierRegistry.getInstance();
        registry.register(BlockStairs.class, stairsPropertyCopier);
        registry.register(BlockLog.class, logPropertyCopier);
        registry.register(BlockOldLog.class, oldLogPropertyCopier);
        registry.register(BlockVine.class, vinePropertyCopier);
        registry.register(BlockFence.class, vinePropertyCopier);
        registry.register(BlockFenceGate.class, fenceGatePropertyCopier);
        registry.register(BlockWall.class, wallPropertyCopier);
        registry.register(BlockPlanks.class, planksPropertyCopier);
    }

    public static IBlockState copyProperties(IBlockState sourceState, IBlockState destState) {
        Block block = destState.func_177230_c();
        if (block == Blocks.field_150350_a || block instanceof BlockSlab) {
            return destState;
        }
        IPropertyCopier copier = null;
        if (PropertyCopierRegistry.getInstance().has(block.getClass())) {
            copier = PropertyCopierRegistry.getInstance().get(block.getClass());
        } else if (destState.func_177228_b().containsKey((Object)FACING)) {
            copier = facingPropertyCopier;
        }
        if (copier == null) {
            return destState;
        }
        return copier.copy(sourceState, destState);
    }

    static {
        PropertyHelper.registerBlocks();
    }
}

