/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.positional;

import com.someguyssoftware.gottschcore.enums.Direction;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class MutableCoords
extends Coords {
    private int x;
    private int y;
    private int z;

    public MutableCoords(int x, int y, int z) {
        super(0, 0, 0);
        this.x = y;
        this.y = y;
        this.z = z;
    }

    public MutableCoords(ICoords coords) {
        this(coords.getX(), coords.getY(), coords.getZ());
    }

    public MutableCoords(BlockPos pos) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public MutableCoords(Vec3d vec) {
        this(MathHelper.func_76128_c((double)vec.field_72450_a), MathHelper.func_76128_c((double)vec.field_72448_b), MathHelper.func_76128_c((double)vec.field_72449_c));
    }

    @Override
    public ICoords up(int n) {
        this.y += n;
        return this;
    }

    @Override
    public ICoords down(int n) {
        this.y -= n;
        return this;
    }

    @Override
    public ICoords north(int n) {
        this.z -= n;
        return this;
    }

    @Override
    public ICoords south(int n) {
        this.z += n;
        return this;
    }

    @Override
    public ICoords east(int n) {
        this.x += n;
        return this;
    }

    @Override
    public ICoords west(int n) {
        this.x -= n;
        return this;
    }

    @Override
    public ICoords offset(EnumFacing facing) {
        return this.offset(facing, 1);
    }

    @Override
    public ICoords offset(EnumFacing facing, int n) {
        if (n == 0) {
            return this;
        }
        this.x += facing.func_82601_c() * n;
        this.y += facing.func_96559_d() * n;
        this.z += facing.func_82599_e() * n;
        return this;
    }

    @Override
    public ICoords add(int x, int y, int z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    @Override
    public ICoords add(ICoords coords) {
        this.x += coords.getX();
        this.y += coords.getY();
        this.z += coords.getZ();
        return this;
    }

    @Override
    public ICoords add(Direction direction, int n) {
        switch (direction) {
            case NORTH: {
                return this.north(n);
            }
            case EAST: {
                return this.east(n);
            }
            case SOUTH: {
                return this.south(n);
            }
            case WEST: {
                return this.west(n);
            }
            case UP: {
                return this.up(n);
            }
            case DOWN: {
                return this.down(n);
            }
        }
        return this;
    }

    @Override
    public ICoords withX(ICoords coords) {
        this.setX(coords.getX());
        return this;
    }

    @Override
    public ICoords withX(int x) {
        this.setX(x);
        return this;
    }

    @Override
    public ICoords withY(ICoords coords) {
        this.setY(coords.getY());
        return this;
    }

    @Override
    public ICoords withY(int y) {
        this.setY(y);
        return this;
    }

    @Override
    public ICoords withZ(ICoords coords) {
        this.setZ(coords.getZ());
        return this;
    }

    @Override
    public ICoords withZ(int z) {
        this.setZ(z);
        return this;
    }

    @Override
    public ICoords delta(ICoords coords) {
        this.x -= coords.getX();
        this.y -= coords.getY();
        this.z -= coords.getZ();
        return this;
    }

    @Override
    public ICoords rotate(double xlen, double zlen, double degrees) {
        double s = Math.sin(Math.toRadians(degrees));
        double c = Math.cos(Math.toRadians(degrees));
        double xnew = xlen * c - zlen * s;
        double znew = xlen * s + zlen * c;
        return this.add((int)xnew, 0, (int)znew);
    }

    @Override
    public ICoords rotate90(int width) {
        this.x = width - this.getZ() - 1;
        return this;
    }

    @Override
    public ICoords rotate180(int depth, int width) {
        this.x = width - this.getX() - 1;
        this.z = depth - this.getZ() - 1;
        return this;
    }

    @Override
    public ICoords rotate270(int depth) {
        this.z = depth - this.getX() - 1;
        return this;
    }

    @Override
    @Deprecated
    public ICoords resetX(int x) {
        return this.withX(x);
    }

    @Override
    @Deprecated
    public ICoords resetY(int y) {
        return this.withY(y);
    }

    @Override
    @Deprecated
    public ICoords resetZ(int z) {
        return this.withZ(z);
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setZ(int z) {
        this.z = z;
    }

    @Override
    public String toString() {
        return "MutableCoords [x=" + this.x + ", y=" + this.y + ", z=" + this.z + "]";
    }
}

