/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.eventhandler;

import com.someguyssoftware.gottschcore.GottschCore;
import com.someguyssoftware.gottschcore.mod.IMod;
import com.someguyssoftware.gottschcore.version.BuildVersion;
import com.someguyssoftware.gottschcore.version.VersionChecker;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class LoginEventHandler {
    private IMod mod;

    public LoginEventHandler(IMod mod) {
        this.mod = mod;
    }

    public IMod getMod() {
        return this.mod;
    }

    public void setMod(IMod mod) {
        this.mod = mod;
    }

    @SubscribeEvent
    public void checkVersionOnLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (this.mod.getConfig() == null || !this.mod.getConfig().isEnableVersionChecker() || this.mod.getModLatestVersion().isEmpty()) {
            return;
        }
        BuildVersion configVersion = new BuildVersion(this.mod.getConfig().getLatestVersion());
        boolean isConfigCurrent = VersionChecker.checkVersion(this.mod.getModLatestVersion(), configVersion);
        boolean isReminderOn = this.mod.getConfig().isLatestVersionReminder();
        boolean isCurrent = false;
        if (!isConfigCurrent) {
            this.mod.getConfig().setProperty("03-mod", "latestVersion", this.mod.getModLatestVersion().toString());
            this.mod.getConfig().setProperty("03-mod", "latestVersionReminder", true);
        }
        if (this.mod.getUpdateURL() != null && !this.mod.getUpdateURL().equals("")) {
            try {
                isCurrent = VersionChecker.checkVersionUsingForge(this.mod.getModLatestVersion(), new BuildVersion(this.mod.getClass().getAnnotation(Mod.class).version()));
            }
            catch (Exception e) {
                GottschCore.logger.error("Unable to determine version using Forge:", (Throwable)e);
                isCurrent = VersionChecker.checkVersion(this.mod.getModLatestVersion(), new BuildVersion(this.mod.getClass().getAnnotation(Mod.class).version()));
            }
        } else {
            isCurrent = VersionChecker.checkVersion(this.mod.getModLatestVersion(), new BuildVersion(this.mod.getClass().getAnnotation(Mod.class).version()));
        }
        if (!isCurrent && isReminderOn) {
            StringBuilder builder = new StringBuilder();
            builder.append(TextFormatting.WHITE).append("A new ").append(TextFormatting.GOLD).append(this.mod.getName() + " ").append(TextFormatting.WHITE).append("version is available: ").append(TextFormatting.GOLD).append(this.mod.getModLatestVersion().toString());
            event.player.func_145747_a((ITextComponent)new TextComponentString(builder.toString()));
        }
    }
}

