/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.biome;

import com.someguyssoftware.gottschcore.biome.IBiomeDictionary;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class BiomeDictionaryManager {
    private static BiomeDictionaryManager instance;
    private static Map<String, IBiomeDictionary> map;

    private BiomeDictionaryManager() {
    }

    public static synchronized BiomeDictionaryManager getInstance() {
        if (instance == null) {
            try {
                instance = new BiomeDictionaryManager();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return instance;
    }

    public IBiomeDictionary getDictionary(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return null;
    }

    public void registerDictionary(String key, IBiomeDictionary dictionary) {
        map.put(key, dictionary);
    }

    public void unregisterDictionary(String key) {
        if (map.containsKey(key)) {
            map.remove(key);
        }
    }

    public Collection<IBiomeDictionary> getAll() {
        if (map != null) {
            return map.values();
        }
        return null;
    }

    static {
        BiomeDictionaryManager.getInstance();
        map = new HashMap<String, IBiomeDictionary>();
    }
}

