/*
 * Decompiled with CFR 0.152.
 */
package com.Fishmod.mod_LavaCow.entities;

import com.Fishmod.mod_LavaCow.client.Modconfig;
import com.Fishmod.mod_LavaCow.init.FishItems;
import com.Fishmod.mod_LavaCow.init.ModEnchantments;
import com.Fishmod.mod_LavaCow.init.Modblocks;
import com.Fishmod.mod_LavaCow.util.LootTableHandler;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIEatGrass;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityUndeadSwine
extends EntityMob {
    private int sheepTimer;
    private int attackTimer;
    private EntityAIEatGrass entityAIEatGrass;
    private AIChargeAttack entityAICharge;
    private final List<Block> DIGOUT_SHROOM = Lists.newArrayList((Object[])new Block[]{Modblocks.GLOWSHROOM, Modblocks.CORDY_SHROOM, Modblocks.VEIL_SHROOM, Blocks.field_150338_P, Blocks.field_150337_Q});

    public EntityUndeadSwine(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.6f, 1.8f);
        this.field_70728_aV = 20;
    }

    protected void func_184651_r() {
        this.entityAIEatGrass = new EntityAIEatGrass((EntityLiving)this);
        this.entityAICharge = new AIChargeAttack(this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.entityAICharge);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.entityAIEatGrass);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_70619_bc() {
        this.sheepTimer = this.entityAIEatGrass.func_151499_f();
        super.func_70619_bc();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Modconfig.UndeadSwine_Health);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(Modconfig.UndeadSwine_Attack);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
    }

    public boolean func_70601_bi() {
        if (this.field_71093_bK == DimensionType.OVERWORLD.func_186068_a()) {
            return super.func_70601_bi();
        }
        return false;
    }

    public void func_70108_f(Entity entityIn) {
        super.func_70108_f(entityIn);
        if (this.entityAICharge != null && this.entityAICharge.isCharging()) {
            this.func_70652_k(entityIn);
            entityIn.func_70024_g(this.func_70040_Z().field_72450_a, this.func_70040_Z().field_72448_b, this.func_70040_Z().field_72449_c);
        }
    }

    public void func_70636_d() {
        float f;
        if (this.field_70170_p.field_72995_K) {
            this.sheepTimer = Math.max(0, this.sheepTimer - 1);
        }
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && (f = this.func_70013_c()) > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v))) {
            this.func_70015_d(40);
        }
        super.func_70636_d();
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        if (flag) {
            float f = this.field_70170_p.func_175649_E(new BlockPos((Entity)this)).func_180168_b();
            if (this.func_184614_ca().func_190926_b() && this.func_70027_ad() && this.field_70146_Z.nextFloat() < f * 0.3f) {
                entityIn.func_70015_d(2 * (int)f);
            }
        }
        return flag;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isDigging() {
        return this.sheepTimer > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
        } else if (id == 10) {
            this.sheepTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        if (this.field_70170_p.field_73012_v.nextInt(100) == 0) {
            EntitySkeleton entityRider = new EntitySkeleton(this.field_70170_p);
            entityRider.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            entityRider.func_180482_a(difficulty, (IEntityLivingData)null);
            this.field_70170_p.func_72838_d((Entity)entityRider);
            entityRider.func_184220_m((Entity)this);
        } else if (this.field_70170_p.field_73012_v.nextInt(100) == 1) {
            EntityZombie entityRider = new EntityZombie(this.field_70170_p);
            entityRider.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            entityRider.func_180482_a(difficulty, (IEntityLivingData)null);
            this.field_70170_p.func_72838_d((Entity)entityRider);
            entityRider.func_184220_m((Entity)this);
        }
        return livingdata;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        int i = ForgeHooks.getLootingLevel((Entity)this, (Entity)cause.func_76346_g(), (DamageSource)cause);
        if (this.func_146066_aG()) {
            LootTableHandler.dropRareLoot((Entity)this, FishItems.UNDYINGHEART, Modconfig.UndeadSwine_DropHeart, ModEnchantments.LIFESTEAL, 3, i);
        }
    }

    public void func_70615_aA() {
        this.func_145779_a(new ItemStack(this.DIGOUT_SHROOM.get(this.field_70146_Z.nextInt(this.DIGOUT_SHROOM.size()))).func_77973_b(), 1);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.6f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187697_dL;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return FishItems.ENTITY_UNDEADSWINE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return FishItems.ENTITY_UNDEADSWINE_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableHandler.UNDEADSWINE;
    }

    protected boolean func_146066_aG() {
        return !this.func_70027_ad() || this.field_70718_bc != 0;
    }

    static class AIChargeAttack
    extends EntityAIBase {
        private final EntityUndeadSwine blaze;
        private int attackStep;
        private int attackTime;

        public AIChargeAttack(EntityUndeadSwine entitySalamander) {
            this.blaze = entitySalamander;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.blaze.func_70638_az();
            return entitylivingbase != null && entitylivingbase.func_70089_S() && entitylivingbase.field_70163_u <= this.blaze.field_70163_u;
        }

        public void func_75249_e() {
            this.attackStep = 0;
            this.blaze.func_184185_a(FishItems.ENTITY_UNDEADSWINE_CHARGE, 4.0f, 1.0f);
        }

        public void func_75251_c() {
        }

        public void func_75246_d() {
            --this.attackTime;
            EntityLivingBase entitylivingbase = this.blaze.func_70638_az();
            double d0 = this.blaze.func_70032_d((Entity)entitylivingbase);
            if (d0 < 2.2) {
                if (this.attackTime <= 0) {
                    this.attackTime = 30;
                    this.blaze.func_70652_k((Entity)entitylivingbase);
                }
            } else if (d0 < this.getFollowDistance() * this.getFollowDistance()) {
                double v = 4.0;
                double d1 = v * (entitylivingbase.field_70165_t - this.blaze.field_70165_t) / d0;
                double d2 = v * (entitylivingbase.field_70163_u - this.blaze.field_70163_u) / d0;
                double d3 = v * (entitylivingbase.field_70161_v - this.blaze.field_70161_v) / d0;
                if (this.attackTime <= 0) {
                    ++this.attackStep;
                    if (this.attackStep > 20) {
                        this.blaze.field_70765_h.func_75642_a(this.blaze.field_70165_t + d1, this.blaze.field_70163_u + d2, this.blaze.field_70161_v + d3, 2.0);
                    } else if (this.attackStep > 100) {
                        this.attackTime = 60;
                        this.attackStep = 0;
                    }
                }
                this.blaze.func_70671_ap().func_75651_a((Entity)entitylivingbase, 100.0f, 100.0f);
            } else {
                this.blaze.func_70661_as().func_75499_g();
                this.blaze.func_70605_aq().func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, 1.0);
            }
            super.func_75246_d();
        }

        private double getFollowDistance() {
            IAttributeInstance iattributeinstance = this.blaze.func_110148_a(SharedMonsterAttributes.field_111265_b);
            return iattributeinstance == null ? 16.0 : iattributeinstance.func_111125_b();
        }

        public boolean isCharging() {
            return this.attackStep > 20;
        }
    }
}

