/*
 * Decompiled with CFR 0.152.
 */
package com.Fishmod.mod_LavaCow.entities;

import com.Fishmod.mod_LavaCow.client.Modconfig;
import com.Fishmod.mod_LavaCow.entities.IAggressive;
import com.Fishmod.mod_LavaCow.init.FishItems;
import com.Fishmod.mod_LavaCow.init.ModMobEffects;
import com.Fishmod.mod_LavaCow.init.ModPotions;
import com.Fishmod.mod_LavaCow.util.LootTableHandler;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFoglet
extends EntityMob
implements IAggressive {
    private static final DataParameter<Integer> SKIN_TYPE = EntityDataManager.func_187226_a(EntityFoglet.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntityFoglet.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> HANGING = EntityDataManager.func_187226_a(EntityFoglet.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> CASTING = EntityDataManager.func_187226_a(EntityFoglet.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final IAttribute SPAWN_REINFORCEMENTS_CHANCE = new RangedAttribute((IAttribute)null, "zombie.spawnReinforcements", 0.0, 0.0, 1.0).func_111117_a("Spawn Reinforcements Chance");
    private boolean isAggressive = false;
    private int attackTimer = 0;
    protected int spellTicks;

    public EntityFoglet(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.5f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AICastingApell());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIUseSpell());
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
        this.func_110140_aT().func_111150_b(SPAWN_REINFORCEMENTS_CHANCE).func_111128_a(this.field_70146_Z.nextDouble() * ForgeModContainer.zombieSummonBaseChance);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
    }

    public boolean func_70601_bi() {
        if (this.field_71093_bK == DimensionType.OVERWORLD.func_186068_a()) {
            return super.func_70601_bi();
        }
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(SKIN_TYPE, (Object)0);
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
        this.field_70180_af.func_187214_a(HANGING, (Object)0);
        this.field_70180_af.func_187214_a(CASTING, (Object)0);
    }

    public boolean isSpellcasting() {
        return ((Byte)this.field_70180_af.func_187225_a(CASTING) & 1) != 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSpellcastingC() {
        return ((Byte)this.field_70180_af.func_187225_a(CASTING) & 1) != 0;
    }

    protected int getSpellTicks() {
        return this.spellTicks;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getIsHanging()) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            if (this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
                this.setIsHanging(false);
            }
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(2.0, 35.0, 2.0));
            for (Entity entity1 : list) {
                if (!(entity1.field_70163_u < this.field_70163_u) || (!(entity1 instanceof EntityPlayer) || ((EntityPlayer)entity1).func_184812_l_()) && !(entity1 instanceof EntityVillager)) continue;
                this.func_70604_c((EntityLivingBase)entity1);
                this.setIsHanging(false);
                break;
            }
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.func_70643_av() != null) {
            super.func_180430_e(distance, 0.0f);
        } else {
            super.func_180430_e(distance, damageMultiplier);
        }
    }

    public void func_70636_d() {
        float f;
        if (this.spellTicks > 0) {
            --this.spellTicks;
        }
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && (f = this.func_70013_c()) > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v))) {
            this.func_70015_d(8);
        }
        super.func_70636_d();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            EntityLivingBase entitylivingbase = this.func_70638_az();
            if (entitylivingbase == null && source.func_76346_g() instanceof EntityLivingBase) {
                entitylivingbase = (EntityLivingBase)source.func_76346_g();
            }
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70163_u);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            if (entitylivingbase != null && this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && (double)this.field_70146_Z.nextFloat() < this.func_110148_a(SPAWN_REINFORCEMENTS_CHANCE).func_111126_e() && this.field_70170_p.func_82736_K().func_82766_b("doMobSpawning") && Modconfig.pFoglet_SpawnAlly) {
                EntityFoglet entityzombie = new EntityFoglet(this.field_70170_p);
                for (int l = 0; l < 50; ++l) {
                    int k1;
                    int j1;
                    int i1 = i + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)7, (int)40) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                    if (!this.field_70170_p.func_180495_p(new BlockPos(i1, (j1 = j + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)7, (int)40) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1)) - 1, k1 = k + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)7, (int)40) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1))).isSideSolid((IBlockAccess)this.field_70170_p, new BlockPos(i1, j1 - 1, k1), EnumFacing.UP) || this.field_70170_p.func_175671_l(new BlockPos(i1, j1, k1)) >= 10) continue;
                    entityzombie.func_70107_b(i1, j1, k1);
                    if (this.field_70170_p.func_175636_b((double)i1, (double)j1, (double)k1, 7.0) || !this.field_70170_p.func_72917_a(entityzombie.func_174813_aQ(), (Entity)entityzombie) || !this.field_70170_p.func_184144_a((Entity)entityzombie, entityzombie.func_174813_aQ()).isEmpty() || this.field_70170_p.func_72953_d(entityzombie.func_174813_aQ())) continue;
                    this.field_70170_p.func_72838_d((Entity)entityzombie);
                    if (entitylivingbase != null) {
                        entityzombie.func_70624_b(entitylivingbase);
                    }
                    entityzombie.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entityzombie)), null);
                    this.func_110148_a(SPAWN_REINFORCEMENTS_CHANCE).func_111121_a(new AttributeModifier("Zombie reinforcement caller charge", (double)-0.05f, 0));
                    entityzombie.func_110148_a(SPAWN_REINFORCEMENTS_CHANCE).func_111121_a(new AttributeModifier("Zombie reinforcement callee charge", (double)-0.05f, 0));
                    break;
                }
            }
            if (this.getIsClimbing()) {
                this.setIsClimbing(false);
            }
            return true;
        }
        return false;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag) {
            float f = this.field_70170_p.func_175649_E(new BlockPos((Entity)this)).func_180168_b();
            if (this.func_184614_ca().func_190926_b() && this.func_70027_ad() && this.field_70146_Z.nextFloat() < f * 0.3f) {
                entityIn.func_70015_d(2 * (int)f);
            }
        }
        return flag;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData entityLivingData) {
        if (BiomeDictionary.hasType((Biome)this.func_130014_f_().func_180494_b(this.func_180425_c()), (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            this.setSkin(1);
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIClimbimgTree());
        }
        return super.func_180482_a(difficulty, entityLivingData);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        int looting = ForgeHooks.getLootingLevel((Entity)this, (Entity)cause.func_76346_g(), (DamageSource)cause);
        int chance = this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(1 + looting);
        if (!this.field_70170_p.field_72995_K && this.getSkin() == 1) {
            for (int amount = 0; amount < chance; ++amount) {
                this.func_70099_a(new ItemStack(FishItems.FOUL_BRISTLE), 0.0f);
            }
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.func_70638_az() != null) {
            this.isAggressive = true;
            this.field_70170_p.func_72960_a((Entity)this, (byte)11);
        } else {
            this.isAggressive = false;
            this.field_70170_p.func_72960_a((Entity)this, (byte)34);
        }
    }

    public int getSkin() {
        return (Integer)this.field_70180_af.func_187225_a(SKIN_TYPE);
    }

    public void setSkin(int skinType) {
        this.field_70180_af.func_187227_b(SKIN_TYPE, (Object)skinType);
    }

    @Override
    public boolean isAggressive() {
        return this.isAggressive;
    }

    @Override
    public int getAttackTimer() {
        return this.attackTimer;
    }

    @Override
    public void setAttackTimer(int i) {
        this.attackTimer = i;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.spellTicks = 100;
        } else {
            this.spellTicks = 0;
            if (id == 11) {
                this.isAggressive = true;
            } else if (id == 34) {
                this.isAggressive = false;
            } else {
                super.func_70103_a(id);
            }
        }
    }

    public float func_70047_e() {
        if (this.getIsHanging()) {
            return this.field_70131_O * 0.0f;
        }
        return this.field_70131_O * 0.8f;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.spellTicks = compound.func_74762_e("SpellTicks");
        this.setSkin(compound.func_74762_e("Variant"));
        this.field_70180_af.func_187227_b(HANGING, (Object)compound.func_74771_c("Hanging"));
        this.field_70180_af.func_187227_b(CLIMBING, (Object)compound.func_74771_c("Climbing"));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("SpellTicks", this.spellTicks);
        compound.func_74768_a("Variant", this.getSkin());
        compound.func_74774_a("Hanging", ((Byte)this.field_70180_af.func_187225_a(HANGING)).byteValue());
        compound.func_74774_a("Climbing", ((Byte)this.field_70180_af.func_187225_a(CLIMBING)).byteValue());
    }

    public boolean getIsHanging() {
        return ((Byte)this.field_70180_af.func_187225_a(HANGING) & 1) != 0;
    }

    public boolean getIsClimbing() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setIsClimbing(boolean isClimbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        if (isClimbing) {
            this.field_70180_af.func_187227_b(CLIMBING, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_187227_b(CLIMBING, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public void setIsHanging(boolean isHanging) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(HANGING);
        if (isHanging) {
            this.field_70180_af.func_187227_b(HANGING, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_187227_b(HANGING, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public void setIsCasting(boolean isHanging) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CASTING);
        if (isHanging) {
            this.field_70180_af.func_187227_b(CASTING, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_187227_b(CASTING, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    protected SoundEvent func_184639_G() {
        return FishItems.ENTITY_FOGLET_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return FishItems.ENTITY_FOGLET_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return FishItems.ENTITY_FOGLET_DEATH;
    }

    protected SoundEvent getSpellSound() {
        return SoundEvents.field_191244_bn;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.field_187939_hm;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(this.getStepSound(), 0.15f, 1.0f);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableHandler.FOGLET;
    }

    public class AIUseSpell
    extends EntityAIBase {
        protected int spellWarmup;
        protected int spellCooldown;

        public boolean func_75250_a() {
            if (EntityFoglet.this.func_70638_az() == null) {
                return false;
            }
            if (EntityFoglet.this.isSpellcasting()) {
                return false;
            }
            return EntityFoglet.this.field_70173_aa >= this.spellCooldown && EntityFoglet.this.func_70032_d((Entity)EntityFoglet.this.func_70638_az()) < 3.0f;
        }

        public boolean func_75253_b() {
            return EntityFoglet.this.func_70638_az() != null && this.spellWarmup > 0;
        }

        public void func_75249_e() {
            this.spellWarmup = this.getCastWarmupTime();
            EntityFoglet.this.spellTicks = this.getCastingTime();
            EntityFoglet.this.field_70170_p.func_72960_a((Entity)EntityFoglet.this, (byte)10);
            this.spellCooldown = EntityFoglet.this.field_70173_aa + this.getCastingInterval();
            SoundEvent soundevent = this.getSpellPrepareSound();
            if (soundevent != null) {
                EntityFoglet.this.func_184185_a(soundevent, 1.0f, 1.0f);
            }
        }

        public void func_75246_d() {
            --this.spellWarmup;
            if (this.spellWarmup == 0) {
                this.castSpell();
                EntityFoglet.this.func_184185_a(EntityFoglet.this.getSpellSound(), 1.0f, 1.0f);
                EntityFoglet.this.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 60));
                EntityFoglet.this.field_70170_p.func_72960_a((Entity)EntityFoglet.this, (byte)11);
            }
        }

        protected void castSpell() {
            EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(EntityFoglet.this.field_70170_p, EntityFoglet.this.field_70165_t, EntityFoglet.this.field_70163_u + 1.0, EntityFoglet.this.field_70161_v);
            entityareaeffectcloud.func_184481_a((EntityLivingBase)EntityFoglet.this);
            entityareaeffectcloud.func_184483_a(4.0f);
            entityareaeffectcloud.func_184495_b(-0.5f);
            entityareaeffectcloud.func_184486_b(120);
            entityareaeffectcloud.func_184485_d(10);
            entityareaeffectcloud.func_184487_c(-entityareaeffectcloud.func_184490_j() / (float)entityareaeffectcloud.func_184489_o());
            if (EntityFoglet.this.getSkin() == 0) {
                entityareaeffectcloud.func_184491_a(EnumParticleTypes.CLOUD);
            } else {
                entityareaeffectcloud.func_184484_a(ModPotions.FOULODOR);
            }
            entityareaeffectcloud.func_184496_a(new PotionEffect(EntityFoglet.this.getSkin() == 0 ? MobEffects.field_76440_q : ModMobEffects.SOILED, 80, 1));
            entityareaeffectcloud.func_184482_a(EntityFoglet.this.getSkin() == 0 ? 0xFFFFFF : 7297852);
            EntityFoglet.this.field_70170_p.func_72838_d((Entity)entityareaeffectcloud);
        }

        protected int getCastWarmupTime() {
            return 20;
        }

        protected int getCastingTime() {
            return 100;
        }

        protected int getCastingInterval() {
            return 200;
        }

        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.field_191247_bq;
        }
    }

    public class AICastingApell
    extends EntityAIBase {
        public AICastingApell() {
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            return EntityFoglet.this.getSpellTicks() > 0;
        }

        public void func_75249_e() {
            super.func_75249_e();
            EntityFoglet.this.setIsCasting(true);
            EntityFoglet.this.field_70699_by.func_75499_g();
        }

        public void func_75251_c() {
            super.func_75251_c();
            EntityFoglet.this.setIsCasting(false);
        }

        public void func_75246_d() {
            if (EntityFoglet.this.func_70638_az() != null) {
                EntityFoglet.this.func_70671_ap().func_75651_a((Entity)EntityFoglet.this.func_70638_az(), (float)EntityFoglet.this.func_184649_cE(), (float)EntityFoglet.this.func_70646_bf());
            }
        }
    }

    public class AIClimbimgTree
    extends EntityAIBase {
        private BlockPos TreePos;

        public AIClimbimgTree() {
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            int i = MathHelper.func_76128_c((double)EntityFoglet.this.field_70165_t);
            int j = MathHelper.func_76128_c((double)EntityFoglet.this.field_70163_u);
            int k = MathHelper.func_76128_c((double)EntityFoglet.this.field_70161_v);
            BlockPos blockpos = new BlockPos(i, j, k);
            this.TreePos = null;
            block0: for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (EntityFoglet.this.field_70170_p.func_180495_p(blockpos.func_177982_a(x, 0, z)).func_185904_a() != Material.field_151575_d) continue;
                    this.TreePos = new BlockPos(x, 0, z);
                    continue block0;
                }
            }
            return !EntityFoglet.this.func_70027_ad() && !EntityFoglet.this.isAggressive() && !EntityFoglet.this.field_70170_p.func_175678_i(blockpos) && this.TreePos != null && EntityFoglet.this.field_70170_p.func_180495_p(blockpos.func_177981_b(2)).func_185904_a() == Material.field_151579_a;
        }

        public void func_75249_e() {
            super.func_75249_e();
            EntityFoglet.this.setIsClimbing(true);
            EntityFoglet.this.field_70699_by.func_75499_g();
        }

        public void func_75251_c() {
            int i = MathHelper.func_76128_c((double)EntityFoglet.this.field_70165_t);
            int j = MathHelper.func_76128_c((double)EntityFoglet.this.field_70163_u);
            int k = MathHelper.func_76128_c((double)EntityFoglet.this.field_70161_v);
            BlockPos blockpos = new BlockPos(i, j, k);
            super.func_75251_c();
            EntityFoglet.this.setIsClimbing(false);
            EntityFoglet.this.field_70181_x += 1.0;
            if (EntityFoglet.this.field_70170_p.func_180495_p(blockpos.func_177981_b(2)).func_185904_a() != Material.field_151579_a) {
                EntityFoglet.this.setIsHanging(true);
            }
        }

        public void func_75246_d() {
            if (EntityFoglet.this.field_70181_x <= 0.0) {
                EntityFoglet.this.field_70181_x += 0.1;
            }
            if (this.TreePos != null) {
                EntityFoglet.this.field_70761_aq = ((float)this.TreePos.func_177958_n() * 270.0f + (float)Math.toDegrees(Math.atan((double)this.TreePos.func_177952_p() / ((double)this.TreePos.func_177958_n() + 1.0E-7)))) % 360.0f;
            }
        }
    }
}

