/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftblib.integration.FTBLibJEIIntegration;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigItemStack;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.EnumTristate;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.IconAnimation;
import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftblib.lib.io.Bits;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.StringJoiner;
import com.feed_the_beast.ftblib.lib.util.misc.NameMap;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.gui.tree.GuiValidItems;
import com.feed_the_beast.ftbquests.net.MessageClaimReward;
import com.feed_the_beast.ftbquests.net.MessageSubmitTask;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import com.latmod.mods.itemfilters.api.ItemFiltersAPI;
import com.latmod.mods.itemfilters.filters.NBTMatchingMode;
import com.latmod.mods.itemfilters.item.ItemFiltersItems;
import com.latmod.mods.itemfilters.item.ItemMissing;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemTask
extends Task
implements Predicate<ItemStack> {
    public final List<ItemStack> items = new ArrayList<ItemStack>();
    public long count = 1L;
    public EnumTristate consumeItems = EnumTristate.DEFAULT;
    public boolean ignoreDamage = false;
    public NBTMatchingMode nbtMode = NBTMatchingMode.MATCH;
    public EnumTristate onlyFromCrafting = EnumTristate.DEFAULT;

    public ItemTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return FTBQuestsTasks.ITEM;
    }

    @Override
    public long getMaxProgress() {
        return this.count;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        NBTTagList list = new NBTTagList();
        for (ItemStack stack : this.items) {
            if (stack.func_190926_b()) continue;
            list.func_74742_a(ItemMissing.write((ItemStack)stack, (boolean)true));
        }
        nbt.func_74782_a("items", (NBTBase)list);
        if (this.count > 1L) {
            nbt.func_74772_a("count", this.count);
        }
        this.consumeItems.write(nbt, "consume_items");
        if (this.ignoreDamage) {
            nbt.func_74757_a("ignore_damage", true);
        }
        if (this.nbtMode != NBTMatchingMode.MATCH) {
            nbt.func_74774_a("ignore_nbt", (byte)this.nbtMode.ordinal());
        }
        this.onlyFromCrafting.write(nbt, "only_from_crafting");
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.items.clear();
        NBTTagList list = nbt.func_150295_c("items", 10);
        if (list.func_82582_d()) {
            ItemStack stack = ItemMissing.read((NBTBase)nbt.func_74781_a("item"));
            if (!stack.func_190926_b()) {
                this.items.add(stack);
            } else {
                FTBQuests.LOGGER.warn("That's odd... Item is empty from tag " + nbt.func_74781_a("item") + " in " + this.quest.chapter + "/" + this.quest + "/" + this);
            }
        } else {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                ItemStack stack = ItemMissing.read((NBTBase)list.func_179238_g(i));
                if (!stack.func_190926_b()) {
                    this.items.add(stack);
                    continue;
                }
                FTBQuests.LOGGER.warn("That's odd... Item is empty from tag " + list.func_179238_g(i) + " in " + this.quest.chapter + "/" + this.quest + "/" + this);
            }
        }
        if (this.items.isEmpty()) {
            FTBQuests.LOGGER.warn("Item list is empty? That's not good... Task: " + this.quest.chapter + "/" + this.quest + "/" + this);
        }
        this.count = nbt.func_74763_f("count");
        if (this.count < 1L) {
            this.count = 1L;
        }
        this.consumeItems = EnumTristate.read((NBTTagCompound)nbt, (String)"consume_items");
        this.ignoreDamage = nbt.func_74767_n("ignore_damage");
        this.nbtMode = NBTMatchingMode.VALUES[nbt.func_74771_c("ignore_nbt")];
        this.onlyFromCrafting = EnumTristate.read((NBTTagCompound)nbt, (String)"only_from_crafting");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)1, (this.count > 1L ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)2, (boolean)this.ignoreDamage);
        flags = Bits.setFlag((int)flags, (int)4, (this.nbtMode != NBTMatchingMode.MATCH ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)8, (this.nbtMode == NBTMatchingMode.CONTAIN ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)16, (this.consumeItems != EnumTristate.DEFAULT ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)32, (this.consumeItems == EnumTristate.TRUE ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)64, (this.items.size() == 1 ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)128, (this.onlyFromCrafting != EnumTristate.DEFAULT ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)256, (this.onlyFromCrafting == EnumTristate.TRUE ? 1 : 0) != 0);
        data.writeVarInt(flags);
        if (this.items.size() == 1) {
            DataOut.ITEM_STACK.write(data, (Object)this.items.get(0));
        } else {
            data.writeCollection(this.items, DataOut.ITEM_STACK);
        }
        if (this.count > 1L) {
            data.writeVarLong(this.count);
        }
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        int flags = data.readVarInt();
        this.ignoreDamage = Bits.getFlag((int)flags, (int)2);
        NBTMatchingMode nBTMatchingMode = Bits.getFlag((int)flags, (int)4) ? (Bits.getFlag((int)flags, (int)8) ? NBTMatchingMode.CONTAIN : NBTMatchingMode.IGNORE) : (this.nbtMode = NBTMatchingMode.MATCH);
        EnumTristate enumTristate = Bits.getFlag((int)flags, (int)16) ? (Bits.getFlag((int)flags, (int)32) ? EnumTristate.TRUE : EnumTristate.FALSE) : (this.consumeItems = EnumTristate.DEFAULT);
        EnumTristate enumTristate2 = Bits.getFlag((int)flags, (int)128) ? (Bits.getFlag((int)flags, (int)256) ? EnumTristate.TRUE : EnumTristate.FALSE) : (this.onlyFromCrafting = EnumTristate.DEFAULT);
        if (Bits.getFlag((int)flags, (int)64)) {
            this.items.clear();
            this.items.add((ItemStack)DataIn.ITEM_STACK.read(data));
        } else {
            data.readCollection(this.items, DataIn.ITEM_STACK);
        }
        this.count = Bits.getFlag((int)flags, (int)1) ? data.readVarLong() : 1L;
    }

    public List<ItemStack> getValidItems() {
        if (this.items.size() == 1 && ItemFiltersAPI.isFilter((ItemStack)this.items.get(0))) {
            ArrayList<ItemStack> validItems = new ArrayList<ItemStack>();
            ItemFiltersAPI.getValidItems((ItemStack)this.items.get(0), validItems);
            return validItems;
        }
        return this.items;
    }

    @Override
    public Icon getAltIcon() {
        ArrayList<Icon> icons = new ArrayList<Icon>();
        for (ItemStack stack : this.getValidItems()) {
            Icon icon = ItemIcon.getItemIcon((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
            if (icon.isEmpty()) continue;
            icons.add(icon);
        }
        if (icons.isEmpty()) {
            return super.getAltIcon();
        }
        return IconAnimation.fromList(icons, (boolean)false);
    }

    @Override
    public String getAltTitle() {
        String name;
        if (this.items.size() == 1) {
            name = this.items.get(0).func_82833_r();
        } else {
            String[] s = new String[this.items.size()];
            for (int i = 0; i < s.length; ++i) {
                s[i] = this.items.get(i).func_82833_r();
            }
            name = "[" + StringJoiner.with((String)", ").joinStrings(s) + "]";
        }
        if (this.count > 1L) {
            name = this.count + "x " + name;
        }
        return name;
    }

    @Override
    public boolean test(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_77973_b() == ItemFiltersItems.MISSING) {
            return false;
        }
        if (this.items.size() == 1 && ItemFiltersAPI.isFilter((ItemStack)this.items.get(0))) {
            return ItemFiltersAPI.filter((ItemStack)this.items.get(0), (ItemStack)stack);
        }
        Item item = stack.func_77973_b();
        int meta = this.ignoreDamage ? 0 : stack.func_77960_j();
        NBTTagCompound nbt = this.nbtMode == NBTMatchingMode.CONTAIN ? stack.func_77978_p() : item.getNBTShareTag(stack);
        for (ItemStack stack1 : this.items) {
            if (item != stack1.func_77973_b() || !this.ignoreDamage && meta != stack1.func_77960_j()) continue;
            switch (this.nbtMode) {
                case MATCH: {
                    return Objects.equals(nbt, stack1.func_77973_b().getNBTShareTag(stack1));
                }
                case IGNORE: {
                    return true;
                }
                case CONTAIN: {
                    NBTTagCompound nbt1 = stack1.func_77978_p();
                    if (nbt1 == null || nbt1.func_82582_d()) {
                        return true;
                    }
                    if (nbt == null || nbt.func_82582_d()) {
                        return false;
                    }
                    for (String s : nbt1.func_150296_c()) {
                        if (Objects.equals(nbt.func_74781_a(s), nbt1.func_74781_a(s))) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addList("items", this.items, (ConfigValue)new ConfigItemStack(ItemStack.field_190927_a, true), v -> new ConfigItemStack(v, true), ConfigItemStack::getStack);
        config.addLong("count", () -> this.count, v -> {
            this.count = v;
        }, 1L, 1L, Long.MAX_VALUE);
        config.addEnum("consume_items", () -> this.consumeItems, v -> {
            this.consumeItems = v;
        }, EnumTristate.NAME_MAP).setCanEdit(!this.quest.canRepeat);
        config.addBool("ignore_damage", () -> this.ignoreDamage, v -> {
            this.ignoreDamage = v;
        }, false);
        config.addEnum("nbt_mode", () -> this.nbtMode, v -> {
            this.nbtMode = v;
        }, NameMap.create((Object)NBTMatchingMode.MATCH, (Object[])NBTMatchingMode.VALUES));
        config.addEnum("only_from_crafting", () -> this.onlyFromCrafting, v -> {
            this.onlyFromCrafting = v;
        }, EnumTristate.NAME_MAP).setCanEdit(!this.quest.canRepeat);
    }

    @Override
    public boolean canInsertItem() {
        return this.quest.canRepeat || this.consumeItems.get(this.quest.chapter.file.defaultTeamConsumeItems);
    }

    @Override
    public boolean submitItemsOnInventoryChange() {
        return !this.canInsertItem();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onButtonClicked(boolean canClick) {
        GuiHelper.playClickSound();
        List<ItemStack> validItems = this.getValidItems();
        if (!this.consumesResources() && validItems.size() == 1 && Loader.isModLoaded((String)"jei")) {
            this.showJEIRecipe(validItems.get(0));
        } else if (GuiScreen.func_146272_n()) {
            int r = GuiScreen.func_146271_m() ? 16 : 1;
            for (int i = 0; i < r; ++i) {
                new MessageSubmitTask(this.id).sendToServer();
                for (Reward reward : this.quest.rewards) {
                    new MessageClaimReward(reward.id, false).sendToServer();
                }
            }
        } else {
            new GuiValidItems(this, validItems, canClick).openGui();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void showJEIRecipe(ItemStack stack) {
        FTBLibJEIIntegration.showRecipe((Object)stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addMouseOverText(List<String> list, @Nullable TaskData data) {
        if (this.consumesResources()) {
            list.add("");
            list.add(TextFormatting.YELLOW.toString() + TextFormatting.UNDERLINE + I18n.func_135052_a((String)"ftbquests.task.click_to_submit", (Object[])new Object[0]));
        } else if (this.getValidItems().size() > 1) {
            list.add("");
            list.add(TextFormatting.YELLOW.toString() + TextFormatting.UNDERLINE + I18n.func_135052_a((String)"ftbquests.task.ftbquests.item.view_items", (Object[])new Object[0]));
        } else if (Loader.isModLoaded((String)"jei")) {
            list.add("");
            list.add(TextFormatting.YELLOW.toString() + TextFormatting.UNDERLINE + I18n.func_135052_a((String)"ftbquests.task.ftbquests.item.click_recipe", (Object[])new Object[0]));
        }
    }

    @Override
    public TaskData createData(QuestData data) {
        return new Data(this, data);
    }

    public static class Data
    extends TaskData<ItemTask> {
        private Data(ItemTask t, QuestData data) {
            super(t, data);
        }

        @Override
        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        }

        @Override
        @Nullable
        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this : null);
        }

        @Override
        public ItemStack insertItem(ItemStack stack, boolean singleItem, boolean simulate, @Nullable EntityPlayer player) {
            long add;
            if (!this.isComplete() && ((ItemTask)this.task).test(stack) && (add = Math.min((long)stack.func_190916_E(), ((ItemTask)this.task).count - this.progress)) > 0L) {
                if (singleItem) {
                    add = 1L;
                }
                if (!simulate && !this.data.getFile().isClient()) {
                    this.addProgress(add);
                }
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)((int)((long)stack.func_190916_E() - add)));
            }
            return stack;
        }

        @Override
        public int getSlotLimit(int slot) {
            return (int)Math.min(64L, ((ItemTask)this.task).count - this.progress);
        }

        @Override
        public void submitTask(EntityPlayerMP player, ItemStack item) {
            if (this.isComplete()) {
                return;
            }
            if (!((ItemTask)this.task).canInsertItem()) {
                long count;
                if (((ItemTask)this.task).onlyFromCrafting.get(false)) {
                    if (item.func_190926_b() || !((ItemTask)this.task).test(item)) {
                        return;
                    }
                    count = Math.min(((ItemTask)this.task).count, (long)item.func_190916_E());
                    if (count > this.progress) {
                        this.setProgress(count);
                        return;
                    }
                }
                count = 0L;
                for (ItemStack stack : player.field_71071_by.field_70462_a) {
                    if (stack.func_190926_b() || !((ItemTask)this.task).test(stack)) continue;
                    count += (long)stack.func_190916_E();
                }
                if ((count = Math.min(((ItemTask)this.task).count, count)) > this.progress) {
                    this.setProgress(count);
                    return;
                }
                return;
            }
            if (!item.func_190926_b()) {
                return;
            }
            boolean changed = false;
            for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                ItemStack stack1;
                ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                if (ItemStack.func_77989_b((ItemStack)stack, (ItemStack)(stack1 = this.insertItem(stack, false, false, (EntityPlayer)player)))) continue;
                changed = true;
                player.field_71071_by.field_70462_a.set(i, (Object)(stack1.func_190926_b() ? ItemStack.field_190927_a : stack1));
            }
            if (changed) {
                player.field_71071_by.func_70296_d();
                player.field_71070_bA.func_75142_b();
            }
        }
    }
}

