/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.tree;

import erebus.blocks.EnumWood;
import erebus.world.feature.tree.WorldGenTreeBase;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenBaobabTree
extends WorldGenTreeBase {
    public WorldGenBaobabTree() {
        super(EnumWood.BAOBAB);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int radius = rand.nextInt(2) + 3;
        int height = rand.nextInt(radius) + 12;
        int maxHeight = height + 2;
        int maxRadius = radius + 2;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int xx = x - maxRadius; xx <= x + maxRadius; ++xx) {
            for (int zz = z - maxRadius; zz <= z + maxRadius; ++zz) {
                for (int yy = y + 1; yy < y + maxHeight; ++yy) {
                    if (world.func_175623_d(new BlockPos(xx, yy, zz))) continue;
                    return false;
                }
            }
        }
        for (int yy = y; yy < y + height; ++yy) {
            if (yy % 5 == 0 && radius != 1) {
                --radius;
            }
            for (int i = radius * -1; i <= radius; ++i) {
                for (int j = radius * -1; j <= radius; ++j) {
                    double dSq = i * i + j * j;
                    if (Math.round(Math.sqrt(dSq)) > (long)radius || yy > y + height - 2) continue;
                    world.func_180501_a(new BlockPos(x + i, yy, z + j), this.log.func_176203_a(0), 2);
                }
            }
            if (yy != y + height - 2) continue;
            this.createBranch(world, rand, x + radius + 1, yy - rand.nextInt(3), z, 1);
            this.createBranch(world, rand, x - radius - 1, yy - rand.nextInt(3), z, 2);
            this.createBranch(world, rand, x, yy - rand.nextInt(3), z + radius + 1, 3);
            this.createBranch(world, rand, x, yy - rand.nextInt(3), z - radius - 1, 4);
        }
        return true;
    }

    private void createBranch(World world, Random rand, int x, int y, int z, int dir) {
        int branchLength = rand.nextInt(2) + 2;
        int meta = dir;
        for (int i = 0; i <= branchLength; ++i) {
            if (i >= 2) {
                ++y;
                meta = 0;
            }
            if (dir == 1) {
                world.func_180501_a(new BlockPos(x + i, y, z), this.log.func_176203_a(meta == 0 ? 0 : 4), 2);
                if (i == branchLength) {
                    this.createLeaves(world, rand, x + i, y + 1, z, branchLength);
                }
            }
            if (dir == 2) {
                world.func_180501_a(new BlockPos(x - i, y, z), this.log.func_176203_a(meta == 0 ? 0 : 4), 2);
                if (i == branchLength) {
                    this.createLeaves(world, rand, x - i, y + 1, z, branchLength);
                }
            }
            if (dir == 3) {
                world.func_180501_a(new BlockPos(x, y, z + i), this.log.func_176203_a(meta == 0 ? 0 : 8), 2);
                if (i == branchLength) {
                    this.createLeaves(world, rand, x, y + 1, z + i, branchLength);
                }
            }
            if (dir != 4) continue;
            world.func_180501_a(new BlockPos(x, y, z - i), this.log.func_176203_a(meta == 0 ? 0 : 8), 2);
            if (i != branchLength) continue;
            this.createLeaves(world, rand, x, y + 1, z - i, branchLength);
        }
    }

    public void createLeaves(World world, Random rand, int x, int y, int z, int radius) {
        int height = 2;
        for (int xx = x - radius; xx <= x + radius; ++xx) {
            for (int zz = z - radius; zz <= z + radius; ++zz) {
                for (int yy = y; yy < y + height; ++yy) {
                    double dSq = Math.pow(xx - x, 2.0) + Math.pow(zz - z, 2.0) + Math.pow(yy - y, 2.0);
                    if (Math.round(Math.sqrt(dSq)) > (long)radius) continue;
                    if (Math.round(Math.sqrt(dSq)) == 0L) {
                        world.func_180501_a(new BlockPos(xx, yy, zz), this.log.func_176203_a(0), 2);
                        continue;
                    }
                    world.func_180501_a(new BlockPos(xx, yy, zz), this.leaves, 2);
                }
            }
        }
    }
}

