/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.structure;

import erebus.ModBlocks;
import erebus.ModFluids;
import erebus.ModItems;
import erebus.blocks.BlockBones;
import erebus.blocks.BlockUmberstone;
import erebus.items.ItemErebusFood;
import erebus.items.ItemMaterials;
import erebus.tileentity.TileEntityBones;
import erebus.world.biomes.decorators.data.SurfaceType;
import erebus.world.loot.IPostProcess;
import erebus.world.loot.LootItemStack;
import erebus.world.loot.LootUtil;
import erebus.world.loot.WeightedLootList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class WorldGenLocustShrine
extends WorldGenerator {
    public int height = 7;
    public int radius = 4;
    public IBlockState COARSE_DIRT = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT);
    public IBlockState UMBERGRAVEL = ModBlocks.UMBERGRAVEL.func_176223_P();
    public IBlockState DEAD_BUSH = Blocks.field_150330_I.func_176223_P();
    public IBlockState MOSSY_UMBERCOBBLE = ModBlocks.UMBERSTONE.func_176223_P().func_177226_a(BlockUmberstone.TYPE, (Comparable)((Object)BlockUmberstone.EnumType.UMBERCOBBLE_MOSSY));
    public IBlockState MOSSY_UMBERCOBBLE_WALL = ModBlocks.WALL_UMBERCOBBLE_MOSSY.func_176223_P();
    public IBlockState SPAWNER = ModBlocks.LOCUST_SPAWNER.func_176223_P();
    public IBlockState BONES = ModBlocks.BLOCK_OF_BONES.func_176223_P();
    public static final WeightedLootList CHEST_LOOT = new WeightedLootList(new LootItemStack[]{new LootItemStack(ModItems.MATERIALS).setAmount(1, 3).setDamage(ItemMaterials.EnumErebusMaterialsType.JADE.ordinal()).setWeight(10), new LootItemStack(ModItems.MATERIALS).setAmount(4, 8).setDamage(ItemMaterials.EnumErebusMaterialsType.PLATE_EXO.ordinal()).setWeight(9), new LootItemStack(Items.field_151134_bR).setWeight(8), new LootItemStack(Items.field_151035_b).setWeight(2), new LootItemStack(ModItems.JADE_PICKAXE).setWeight(1), new LootItemStack(Items.field_151037_a).setWeight(2), new LootItemStack(ModItems.JADE_SHOVEL).setWeight(1), new LootItemStack(Items.field_151036_c).setWeight(2), new LootItemStack(ModItems.JADE_AXE).setWeight(1), new LootItemStack(ModItems.BAMBOO_CHESTPLATE).setWeight(2), new LootItemStack(ModItems.JADE_CHESTPLATE).setWeight(1), new LootItemStack(ModItems.BAMBOO_HELMET).setWeight(2), new LootItemStack(ModItems.JADE_HELMET).setWeight(1), new LootItemStack(ModItems.BAMBOO_LEGGINGS).setWeight(2), new LootItemStack(ModItems.JADE_LEGGINGS).setWeight(1), new LootItemStack(ModItems.BAMBOO_BOOTS).setWeight(2), new LootItemStack(ModItems.EXOSKELETON_BOOTS).setWeight(3), new LootItemStack((Item)ModItems.BAMBOO_SHIELD).setAmount(1).setWeight(3), new LootItemStack(ModItems.ANTI_VENOM_BOTTLE).setAmount(1, 3).setWeight(8), new LootItemStack(ModItems.SPRAY_CAN).setAmount(3, 6).setWeight(5), new LootItemStack(ModItems.MATERIALS).setAmount(1).setDamage(ItemMaterials.EnumErebusMaterialsType.FLY_WING.ordinal()).setWeight(1), new LootItemStack(ModItems.MATERIALS).setAmount(1, 3).setDamage(ItemMaterials.EnumErebusMaterialsType.REINFORCED_PLATE_EXO.ordinal()).setWeight(4), new LootItemStack(ModItems.MATERIALS).setAmount(1).setDamage(ItemMaterials.EnumErebusMaterialsType.BEETLE_TAMING_AMULET.ordinal()).setWeight(1), new LootItemStack(ModItems.EREBUS_FOOD).setAmount(1, 3).setDamage(ItemErebusFood.EnumFoodType.BAMBOO_SOUP.ordinal()).setWeight(4), new LootItemStack(ModItems.EREBUS_FOOD).setAmount(1, 2).setDamage(ItemErebusFood.EnumFoodType.LARVAE_ON_STICK.ordinal()).setWeight(6), new LootItemStack(ModItems.BAMBUCKET).setAmount(1).setWeight(3), new LootItemStack(ModItems.CABBAGE_SEEDS).setAmount(3).setWeight(5), new LootItemStack(ModItems.EREBUS_FOOD).setAmount(1, 3).setDamage(ItemErebusFood.EnumFoodType.CABBAGE.ordinal()).setWeight(10), new LootItemStack(ModItems.TURNIP).setAmount(1, 3).setWeight(10)}).setPostProcessor(new IPostProcess(){

        @Override
        public ItemStack postProcessItem(ItemStack is, Random rand) {
            if (is.func_77973_b() == Items.field_151134_bR || rand.nextBoolean() && (is.func_77973_b() instanceof ItemTool || is.func_77973_b() instanceof ItemArmor || is.func_77973_b() instanceof ItemSword)) {
                boolean enchBook;
                boolean bl = enchBook = is.func_77973_b() == Items.field_151134_bR;
                if (enchBook) {
                    is = new ItemStack(Items.field_151122_aG);
                }
                List enchList = EnchantmentHelper.func_77513_b((Random)rand, (ItemStack)is, (int)(7 + rand.nextInt(10)), (boolean)true);
                if (enchBook) {
                    is = new ItemStack(Items.field_151134_bR);
                }
                if (enchList != null && enchList.size() > 0) {
                    for (int a = 0; a < enchList.size(); ++a) {
                        EnchantmentData data = (EnchantmentData)enchList.get(a);
                        is.func_77966_a(data.field_76302_b, data.field_76303_c);
                    }
                }
            }
            if (is.func_77973_b() == ModItems.BAMBUCKET) {
                int randomBucket = rand.nextInt(2);
                switch (randomBucket) {
                    case 0: {
                        is = ModFluids.getFilledBambucket(new FluidStack(FluidRegistry.getFluid((String)"beetle_juice"), 1000));
                        break;
                    }
                    case 1: {
                        is = ModFluids.getFilledBambucket(new FluidStack(FluidRegistry.getFluid((String)"honey"), 1000));
                    }
                }
            }
            return is;
        }
    });

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if (!this.aircheck(world, rand, pos)) {
            return false;
        }
        for (int xx = -this.radius; xx <= this.radius; ++xx) {
            for (int zz = -this.radius; zz <= this.radius; ++zz) {
                double circle = Math.pow(xx, 2.0) + Math.pow(zz, 2.0);
                if (Math.round(Math.sqrt(circle)) < 5L) {
                    world.func_180501_a(pos.func_177982_a(xx, -1, zz), rand.nextInt(5) != 0 ? this.COARSE_DIRT : this.UMBERGRAVEL, 2);
                }
                if (!(world.func_180495_p(pos.func_177982_a(xx, -1, zz)).func_177230_c() instanceof BlockDirt) || rand.nextInt(3) != 0) continue;
                world.func_180501_a(pos.func_177982_a(xx, 0, zz), this.DEAD_BUSH, 2);
            }
        }
        this.placeSpawnerPillar(world, rand, pos);
        this.placePillar(world, rand, pos.func_177982_a(3, 0, 3), EnumFacing.EAST);
        this.placePillar(world, rand, pos.func_177982_a(3, 0, -3), EnumFacing.NORTH);
        this.placePillar(world, rand, pos.func_177982_a(-3, 0, 3), EnumFacing.SOUTH);
        this.placePillar(world, rand, pos.func_177982_a(-3, 0, -3), EnumFacing.WEST);
        return true;
    }

    private void placePillar(World world, Random rand, BlockPos pos, EnumFacing facing) {
        world.func_180501_a(pos, this.MOSSY_UMBERCOBBLE, 2);
        world.func_180501_a(pos.func_177981_b(1), this.MOSSY_UMBERCOBBLE_WALL, 2);
        world.func_180501_a(pos.func_177981_b(2), this.MOSSY_UMBERCOBBLE, 2);
        world.func_180501_a(pos.func_177981_b(3), this.MOSSY_UMBERCOBBLE, 2);
        world.func_180501_a(pos.func_177981_b(4), this.MOSSY_UMBERCOBBLE_WALL, 2);
        world.func_180501_a(pos.func_177981_b(5), this.MOSSY_UMBERCOBBLE, 2);
        world.func_180501_a(pos.func_177981_b(6), this.BONES.func_177226_a((IProperty)BlockBones.field_176387_N, (Comparable)facing), 2);
        TileEntityBones bones = (TileEntityBones)world.func_175625_s(pos.func_177981_b(6));
        if (bones != null) {
            LootUtil.generateLoot((IInventory)bones, rand, CHEST_LOOT, 2, 3);
        }
    }

    private void placeSpawnerPillar(World world, Random rand, BlockPos pos) {
        world.func_180501_a(pos, this.MOSSY_UMBERCOBBLE, 2);
        world.func_180501_a(pos.func_177981_b(1), this.MOSSY_UMBERCOBBLE, 2);
        world.func_180501_a(pos.func_177981_b(2), this.MOSSY_UMBERCOBBLE_WALL, 2);
        world.func_180501_a(pos.func_177981_b(3), this.MOSSY_UMBERCOBBLE, 2);
        world.func_180501_a(pos.func_177981_b(4), this.SPAWNER, 2);
    }

    private boolean aircheck(World world, Random rand, BlockPos pos) {
        for (int xx = -this.radius; xx <= this.radius; ++xx) {
            for (int zz = -this.radius; zz <= this.radius; ++zz) {
                if (!this.checkSurface(world, SurfaceType.GRASS, pos.func_177982_a(xx, -1, zz))) {
                    return false;
                }
                for (int yy = 0; yy < this.height; ++yy) {
                    if (world.func_175623_d(pos.func_177982_a(xx, yy, zz))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean checkSurface(World world, SurfaceType surfaceType, BlockPos pos) {
        return surfaceType.matchBlock(world.func_180495_p(pos));
    }
}

