/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import erebus.ModItems;
import erebus.ModSounds;
import erebus.core.handler.configs.ConfigHandler;
import erebus.entity.EntityBeetle;
import erebus.entity.EntityBeetleLarva;
import erebus.entity.EntityWorkerBee;
import erebus.entity.ai.EntityAIErebusAttackMelee;
import erebus.entity.ai.EntityAIFlyingWander;
import erebus.entity.ai.FlyingMoveHelper;
import erebus.entity.ai.PathNavigateFlying;
import erebus.items.ItemMaterials;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityWasp
extends EntityMob
implements IEntityAdditionalSpawnData {
    private boolean areAttributesSetup = false;
    public boolean waspFlying;
    private static final DataParameter<Byte> IS_BOSS = EntityDataManager.func_187226_a(EntityWasp.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntityWasp(World world) {
        super(world);
        this.field_70765_h = new FlyingMoveHelper((EntityCreature)this);
        this.func_184644_a(PathNodeType.WATER, -8.0f);
        this.func_184644_a(PathNodeType.BLOCKED, -8.0f);
        this.func_184644_a(PathNodeType.OPEN, 8.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_BOSS, (Object)new Byte((byte)this.field_70146_Z.nextInt(32)));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIErebusAttackMelee((EntityCreature)this, 0.5, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFlyingWander((EntityCreature)this, 0.75, 1));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityBeetle.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityBeetleLarva.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityWorkerBee.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.areAttributesSetup = true;
        this.updateBossAttributes();
    }

    protected void updateBossAttributes() {
        if (this.func_130014_f_() != null && !this.func_130014_f_().field_72995_K) {
            if (this.getIsBoss() == 1) {
                this.func_70105_a(1.5f, 1.0f);
                this.field_70728_aV = 25;
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.9);
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 60.0 : 60.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 8.0 : 8.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier);
                this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
            } else {
                this.func_70105_a(0.5f, 0.4f);
                this.field_70728_aV = 10;
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.75);
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 25.0 : 25.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 4.0 : 4.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier);
                this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
            }
        }
    }

    public boolean func_70601_bi() {
        float light = this.func_70013_c();
        if (light >= 0.0f) {
            return this.func_70058_J();
        }
        return super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 2;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public boolean func_145773_az() {
        return true;
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.WASP_SOUND;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.WASP_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.SQUISH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        int chance = this.field_70146_Z.nextInt(4) + this.field_70146_Z.nextInt(1 + looting);
        for (int amount = 0; amount < chance; ++amount) {
            this.func_70099_a(new ItemStack(ModItems.MATERIALS, 1, ItemMaterials.EnumErebusMaterialsType.WASP_STING.ordinal()), 0.0f);
        }
        if (this.getIsBoss() == 1) {
            this.func_70099_a(new ItemStack(ModItems.ANTI_VENOM_BOTTLE), 0.0f);
        }
    }

    public boolean isFlying() {
        return !this.field_70122_E;
    }

    public void setWaspFlying(boolean state) {
        this.waspFlying = state;
    }

    public void func_70071_h_() {
        if (this.func_130014_f_().field_72995_K) {
            byte i = this.getIsBoss();
            if (i == 1) {
                this.func_70105_a(1.5f, 1.0f);
                if (!this.func_145818_k_()) {
                    if (this.field_70146_Z.nextBoolean()) {
                        if (this.field_70146_Z.nextBoolean()) {
                            this.func_96094_a("Livid's Bane");
                        } else {
                            this.func_96094_a("Nano's Nemesis");
                        }
                    } else {
                        this.func_96094_a("Hornet of Despair");
                    }
                }
            } else {
                this.func_70105_a(0.5f, 0.4f);
            }
        }
        if (this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.4;
        }
        if (this.func_70090_H()) {
            this.func_70605_aq().func_75642_a(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 0.32);
        }
        super.func_70071_h_();
    }

    protected PathNavigate func_175447_b(World world) {
        return new PathNavigateFlying((EntityLiving)this, world);
    }

    public boolean func_70686_a(Class entity) {
        return EntityWasp.class != entity;
    }

    public boolean func_70652_k(Entity entity) {
        if (this.func_70685_l(entity)) {
            if (super.func_70652_k(entity) && entity instanceof EntityLivingBase) {
                int duration = 0;
                if (this.func_130014_f_().func_175659_aa().ordinal() > EnumDifficulty.EASY.ordinal()) {
                    if (this.func_130014_f_().func_175659_aa() == EnumDifficulty.NORMAL) {
                        duration = 3;
                    } else if (this.func_130014_f_().func_175659_aa() == EnumDifficulty.HARD) {
                        duration = 5;
                    }
                }
                if (duration > 0) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76436_u, duration * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public byte getIsBoss() {
        return (Byte)this.field_70180_af.func_187225_a(IS_BOSS);
    }

    public void setIsBoss(byte boss) {
        this.field_70180_af.func_187227_b(IS_BOSS, (Object)boss);
        this.func_130014_f_().func_72960_a((Entity)this, (byte)25);
        if (this.areAttributesSetup) {
            this.updateBossAttributes();
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a("mobType", this.getIsBoss());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setIsBoss(nbt.func_74771_c("mobType"));
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeByte((int)this.getIsBoss());
    }

    public void readSpawnData(ByteBuf data) {
        this.setIsBoss(data.readByte());
    }
}

