/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import erebus.ModItems;
import erebus.ModSounds;
import erebus.client.render.entity.AnimationMathHelper;
import erebus.core.handler.configs.ConfigHandler;
import erebus.entity.EntityBeetleLarva;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityMosquito
extends EntityMob {
    private static final DataParameter<Byte> BLOOD = EntityDataManager.func_187226_a(EntityMosquito.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final int maxBloodLevel = 5;
    private BlockPos currentFlightTarget;
    private float heightOffset = 1.5f;
    private int drainage = 0;
    private short consumptionTimer = 0;
    EntityLivingBase entityToAttack = null;
    AnimationMathHelper mathWings = new AnimationMathHelper();
    AnimationMathHelper mathSucking = new AnimationMathHelper();
    public float wingFloat;
    public float suckFloat;
    public boolean firstTickCheck;
    public int hitInterval = 30;
    Class<?>[] preys = new Class[]{EntityPig.class, EntityCow.class, EntityBeetleLarva.class};

    public EntityMosquito(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.8f);
        this.wingFloat = 0.0f;
        this.suckFloat = 1.0f;
        this.firstTickCheck = false;
        this.setBloodConsumed(0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BLOOD, (Object)0);
    }

    public boolean func_175446_cd() {
        return false;
    }

    public void func_70071_h_() {
        if (this.func_130014_f_().field_72995_K) {
            if (this.func_184187_bx() != null) {
                this.suckFloat = 1.0f + this.mathSucking.swing(1.0f, 0.15f);
                if (this.field_70146_Z.nextInt(10) == 0) {
                    for (int i = 0; i < 8; ++i) {
                        this.func_130014_f_().func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70163_u + (double)this.field_70146_Z.nextFloat() + 1.0, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                this.wingFloat = 0.0f;
            } else {
                this.suckFloat = 1.0f;
                this.wingFloat = this.mathWings.swing(4.0f, 0.1f);
            }
        }
        if (!this.func_130014_f_().field_72995_K) {
            if (this.field_70181_x < 0.0) {
                this.field_70181_x *= 0.8;
            }
            if (!this.firstTickCheck) {
                this.firstTickCheck = true;
            }
            if (this.consumptionTimer > 0 && (this.consumptionTimer = (short)(this.consumptionTimer - 1)) == 0) {
                this.setBloodConsumed(0);
            }
            this.entityToAttack = this.findPlayerToAttack() != null && this.getBloodConsumed() < 5 ? (EntityLivingBase)this.findPlayerToAttack() : (this.findEnemyToAttack() != null && this.getBloodConsumed() < 5 ? (EntityLivingBase)this.findEnemyToAttack() : null);
            if (this.entityToAttack != null && this.func_184187_bx() == null && (double)this.func_70032_d((Entity)this.entityToAttack) <= 1.2 && !this.func_130014_f_().field_72995_K && !this.entityToAttack.func_184207_aI() && this.getBloodConsumed() < 5) {
                this.func_184220_m((Entity)this.entityToAttack);
            }
            if (this.func_184187_bx() instanceof EntityLivingBase && this.getBloodConsumed() >= 5 && this.consumptionTimer > 0) {
                this.func_184210_p();
                this.entityToAttack = null;
            }
            if (this.func_70090_H()) {
                this.field_70181_x += 0.08;
            }
        }
        super.func_70071_h_();
    }

    public double func_70033_W() {
        if (this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityPlayer) {
            return -2.0;
        }
        if (this.func_184187_bx() != null) {
            return (double)this.func_184187_bx().field_70131_O * 0.75 - 1.0;
        }
        return 0.5;
    }

    protected void flyAbout() {
        if (!this.func_130014_f_().field_72995_K) {
            if (!(this.currentFlightTarget == null || this.func_130014_f_().func_175623_d(this.currentFlightTarget) && this.currentFlightTarget.func_177956_o() >= 1)) {
                this.currentFlightTarget = null;
            }
            if (this.currentFlightTarget == null || this.field_70146_Z.nextInt(30) == 0 || this.currentFlightTarget.func_185332_f((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) < 4.0) {
                this.currentFlightTarget = new BlockPos((int)this.field_70165_t + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7), (int)this.field_70163_u + this.field_70146_Z.nextInt(6) - 2, (int)this.field_70161_v + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7));
            }
            double var1 = (double)this.currentFlightTarget.func_177958_n() + 0.5 - this.field_70165_t;
            double var3 = (double)this.currentFlightTarget.func_177956_o() + 1.0 - this.field_70163_u;
            double var5 = (double)this.currentFlightTarget.func_177952_p() + 0.5 - this.field_70161_v;
            this.field_70159_w += (Math.signum(var1) * 0.5 - this.field_70159_w) * (double)0.1f;
            this.field_70181_x += (Math.signum(var3) * (double)0.7f - this.field_70181_x) * (double)0.1f;
            this.field_70179_y += (Math.signum(var5) * 0.5 - this.field_70179_y) * (double)0.1f;
            float var7 = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
            float var8 = MathHelper.func_76142_g((float)(var7 - this.field_70177_z));
            this.field_191988_bg = 0.5f;
            this.field_70177_z += var8;
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        int j = MathHelper.func_76128_c((double)this.field_70165_t);
        int k = MathHelper.func_76128_c((double)this.field_70163_u);
        int l = MathHelper.func_76128_c((double)this.field_70161_v);
        Block m = this.func_130014_f_().func_180495_p(new BlockPos(j, k - 1, l)).func_177230_c();
        if (this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityLivingBase && this.getBloodConsumed() < 5) {
            ++this.drainage;
            if (this.drainage >= this.hitInterval) {
                this.func_184187_bx().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.getDamage());
                this.drainage = 0;
                this.setBloodConsumed(this.getBloodConsumed() + 1);
            }
        }
        if (m == Blocks.field_150355_j) {
            this.field_70181_x = 0.25;
        }
    }

    public void func_70636_d() {
        if (!this.func_130014_f_().field_72995_K) {
            this.heightOffset = 1.0f + (float)this.field_70146_Z.nextGaussian() * 5.0f;
            if (this.entityToAttack != null && this.entityToAttack.field_70163_u + (double)this.entityToAttack.func_70047_e() > this.field_70163_u + (double)this.func_70047_e() + (double)this.heightOffset) {
                double var1 = this.entityToAttack.field_70165_t + 0.5 - this.field_70165_t;
                double var3 = this.entityToAttack.field_70163_u + 1.0 - this.field_70163_u;
                double var5 = this.entityToAttack.field_70161_v + 0.5 - this.field_70161_v;
                this.field_70181_x += (0.350000011920929 - this.field_70181_x) * 0.350000011920929;
                this.field_70159_w += (Math.signum(var1) * 0.5 - this.field_70159_w) * (double)0.1f;
                this.field_70181_x += (Math.signum(var3) * (double)0.7f - this.field_70181_x) * (double)0.1f;
                this.field_70179_y += (Math.signum(var5) * 0.5 - this.field_70179_y) * (double)0.1f;
                float var7 = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
                float var8 = MathHelper.func_76142_g((float)(var7 - this.field_70177_z));
                this.field_191988_bg = 0.5f;
                this.field_70177_z += var8;
            }
            if (this.entityToAttack == null) {
                this.flyAbout();
            }
        }
        super.func_70636_d();
    }

    public boolean func_70652_k(Entity entity) {
        if (this.func_70685_l(entity)) {
            if (this.func_190530_aW()) {
                return false;
            }
            if (super.func_70652_k(entity)) {
                Entity target = entity;
                if (this.func_184187_bx() != target && target != this && !this.func_130014_f_().field_72995_K && this.getBloodConsumed() < 5) {
                    this.func_184220_m(entity);
                    this.field_70181_x += 0.5;
                    return true;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_190530_aW()) {
            return false;
        }
        if (super.func_70097_a(source, amount)) {
            Entity attacker = source.func_76346_g();
            if (!this.func_130014_f_().field_72995_K && attacker instanceof EntityLivingBase && this.func_184187_bx() != attacker) {
                if (attacker != this) {
                    this.entityToAttack = (EntityLivingBase)attacker;
                }
                return true;
            }
            if (!this.func_130014_f_().field_72995_K && attacker instanceof EntityLivingBase && this.func_184187_bx() == attacker) {
                this.func_110145_l(this.func_184187_bx());
                this.field_70181_x += 0.5;
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean func_70692_ba() {
        return true;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    protected Entity findPlayerToAttack() {
        EntityPlayer player = this.func_130014_f_().func_72890_a((Entity)this, 10.0);
        return player != null && this.func_70685_l((Entity)player) && !player.func_184812_l_() ? player : null;
    }

    protected void func_70628_a(boolean recentlyHit, int amount) {
        if (recentlyHit) {
            int count = 1 + this.getBloodConsumed();
            this.func_145779_a(ModItems.LIFE_BLOOD, count);
        }
    }

    protected Entity findEnemyToAttack() {
        List list = this.func_130014_f_().func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(10.0, 10.0, 10.0));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity == null || !(entity instanceof EntityCreature)) continue;
            for (int j = 0; j < this.preys.length; ++j) {
                if (entity.getClass() != this.preys[j] || entity.func_184207_aI()) continue;
                return this.func_70685_l(entity) ? entity : null;
            }
        }
        return null;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 15.0 : (double)(15 * ConfigHandler.INSTANCE.mobHealthMultipier));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 2.0 : 2.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public int getDamage() {
        int var2 = 2;
        if (this.func_70644_a(MobEffects.field_76420_g)) {
            var2 += 3 << this.func_70660_b(MobEffects.field_76420_g).func_76458_c();
        }
        if (this.func_70644_a(MobEffects.field_76437_t)) {
            var2 -= 2 << this.func_70660_b(MobEffects.field_76437_t).func_76458_c();
        }
        return var2;
    }

    protected SoundEvent func_184639_G() {
        if (this.func_184187_bx() != null) {
            return ModSounds.MOSQUITO_SUCKING;
        }
        return ModSounds.MOSQUITO_FLYING;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.MOSQUITO_HIT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.MOSQUITO_DEATH;
    }

    protected float func_70599_aP() {
        return 0.1f;
    }

    protected float func_70647_i() {
        return 1.0f;
    }

    public int getBloodConsumed() {
        return ((Byte)this.field_70180_af.func_187225_a(BLOOD)).byteValue();
    }

    public void setBloodConsumed(int amount) {
        this.consumptionTimer = (short)1200;
        this.field_70180_af.func_187227_b(BLOOD, (Object)((byte)amount));
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74768_a("BloodLevel", this.getBloodConsumed());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setBloodConsumed(nbttagcompound.func_74762_e("BloodLevel"));
    }

    public boolean func_70601_bi() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_72314_b(5.0, 5.0, 5.0);
        int n = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int o = MathHelper.func_76128_c((double)axisalignedbb.field_72336_d);
        int p = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int q = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int n1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int o1 = MathHelper.func_76128_c((double)axisalignedbb.field_72334_f);
        for (int p1 = n; p1 < o; ++p1) {
            for (int q1 = p; q1 < q; ++q1) {
                for (int n2 = n1; n2 < o1; ++n2) {
                    IBlockState o2 = this.func_130014_f_().func_180495_p(new BlockPos(p1, q1, n2));
                    if (o2.func_185904_a() != Material.field_151579_a || this.func_130014_f_().func_180495_p(new BlockPos(p1, q1, n2).func_177977_b()).func_185904_a() != Material.field_151586_h) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public int func_70641_bl() {
        return 2;
    }
}

