/*
 * Decompiled with CFR 0.152.
 */
package erebus.blocks;

import erebus.ModTabs;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockWall;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWoodFenceGate
extends BlockHorizontal {
    public static final PropertyBool OPEN = PropertyBool.func_177716_a((String)"open");
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final PropertyBool IN_WALL = PropertyBool.func_177716_a((String)"in_wall");
    protected static final AxisAlignedBB AABB_HITBOX_ZAXIS = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    protected static final AxisAlignedBB AABB_HITBOX_XAXIS = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_HITBOX_ZAXIS_INWALL = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 0.8125, 0.625);
    protected static final AxisAlignedBB AABB_HITBOX_XAXIS_INWALL = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 0.8125, 1.0);
    protected static final AxisAlignedBB AABB_COLLISION_BOX_ZAXIS = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.5, 0.625);
    protected static final AxisAlignedBB AABB_COLLISION_BOX_XAXIS = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.5, 1.0);

    public BlockWoodFenceGate(IBlockState state) {
        super(state.func_185904_a(), state.func_185904_a().func_151565_r());
        this.func_149672_a(state.func_177230_c().func_185467_w());
        this.func_149711_c(2.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)IN_WALL, (Comparable)Boolean.valueOf(false)));
        this.func_149647_a(ModTabs.BLOCKS);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (((Boolean)(state = this.func_176221_a(state, source, pos)).func_177229_b((IProperty)IN_WALL)).booleanValue()) {
            return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176740_k() == EnumFacing.Axis.X ? AABB_HITBOX_XAXIS_INWALL : AABB_HITBOX_ZAXIS_INWALL;
        }
        return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176740_k() == EnumFacing.Axis.X ? AABB_HITBOX_XAXIS : AABB_HITBOX_ZAXIS;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing.Axis enumfacing$axis = ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176740_k();
        if (enumfacing$axis == EnumFacing.Axis.Z && (this.canFenceGateConnectTo(world, pos, EnumFacing.WEST) || this.canFenceGateConnectTo(world, pos, EnumFacing.EAST)) || enumfacing$axis == EnumFacing.Axis.X && (this.canFenceGateConnectTo(world, pos, EnumFacing.NORTH) || this.canFenceGateConnectTo(world, pos, EnumFacing.SOUTH))) {
            state = state.func_177226_a((IProperty)IN_WALL, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a() ? super.func_176196_c(world, pos) : false;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        if (((Boolean)blockState.func_177229_b((IProperty)OPEN)).booleanValue()) {
            return field_185506_k;
        }
        return ((EnumFacing)blockState.func_177229_b((IProperty)field_185512_D)).func_176740_k() == EnumFacing.Axis.Z ? AABB_COLLISION_BOX_ZAXIS : AABB_COLLISION_BOX_XAXIS;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)OPEN);
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        boolean flag = world.func_175640_z(pos);
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(flag)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(flag)).func_177226_a((IProperty)IN_WALL, (Comparable)Boolean.valueOf(false));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
            state = state.func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false));
            world.func_180501_a(pos, state, 10);
        } else {
            EnumFacing enumfacing = EnumFacing.func_176733_a((double)player.field_70177_z);
            if (state.func_177229_b((IProperty)field_185512_D) == enumfacing.func_176734_d()) {
                state = state.func_177226_a((IProperty)field_185512_D, (Comparable)enumfacing);
            }
            state = state.func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(true));
            world.func_180501_a(pos, state, 10);
        }
        world.func_180498_a(player, (Boolean)state.func_177229_b((IProperty)OPEN) != false ? 1008 : 1014, pos, 0);
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!world.field_72995_K) {
            boolean flag = world.func_175640_z(pos);
            if ((Boolean)state.func_177229_b((IProperty)POWERED) != flag) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(flag)).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(flag)), 2);
                if ((Boolean)state.func_177229_b((IProperty)OPEN) != flag) {
                    world.func_180498_a((EntityPlayer)null, flag ? 1008 : 1014, pos, 0);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf((meta & 4) != 0)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            i |= 8;
        }
        if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
            i |= 4;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D, OPEN, POWERED, IN_WALL});
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        Block connector = world.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
        return connector instanceof BlockFence || connector instanceof BlockWall;
    }

    private boolean canFenceGateConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        Block block = world.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
        return block.canBeConnectedTo(world, pos.func_177972_a(facing), facing.func_176734_d());
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        if (facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
            return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176740_k() == facing.func_176746_e().func_176740_k() ? BlockFaceShape.MIDDLE_POLE : BlockFaceShape.UNDEFINED;
        }
        return BlockFaceShape.UNDEFINED;
    }
}

