/*
 * Decompiled with CFR 0.152.
 */
package erebus.blocks;

import erebus.ModBlocks;
import erebus.ModItems;
import erebus.ModTabs;
import erebus.api.IErebusEnum;
import erebus.items.ItemDungeonIdols;
import erebus.items.block.ItemBlockEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCapstone
extends Block
implements ModBlocks.IHasCustomItem,
ModBlocks.ISubBlocksBlock {
    public static final PropertyEnum<EnumCapstoneType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumCapstoneType.class);

    public BlockCapstone() {
        super(Material.field_151576_e);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149722_s();
        this.func_149752_b(6000000.0f);
        this.func_149647_a(ModTabs.BLOCKS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumCapstoneType.CAPSTONE)));
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == ModTabs.BLOCKS) {
            for (EnumCapstoneType type : EnumCapstoneType.values()) {
                list.add((Object)new ItemStack((Block)this, 1, type.ordinal()));
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumCapstoneType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        EnumCapstoneType type = (EnumCapstoneType)((Object)state.func_177229_b(TYPE));
        return type.ordinal();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (player.func_70093_af()) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand);
        EnumCapstoneType type = (EnumCapstoneType)((Object)state.func_177229_b(TYPE));
        if (!stack.func_190926_b()) {
            switch (type) {
                case CAPSTONE: 
                case CAPSTONE_MUD_ACTIVE: 
                case CAPSTONE_IRON_ACTIVE: 
                case CAPSTONE_GOLD_ACTIVE: 
                case CAPSTONE_JADE_ACTIVE: {
                    return true;
                }
                case CAPSTONE_MUD: {
                    if (stack.func_77973_b() == ModItems.IDOLS && stack.func_77952_i() == ItemDungeonIdols.EnumIdolType.IDOL_MUD.ordinal()) {
                        world.func_180501_a(pos, this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumCapstoneType.CAPSTONE_MUD_ACTIVE)), 3);
                        if (!player.field_71075_bZ.field_75098_d) {
                            stack.func_190918_g(1);
                        }
                    }
                    return true;
                }
                case CAPSTONE_IRON: {
                    if (stack.func_77973_b() == ModItems.IDOLS && stack.func_77952_i() == ItemDungeonIdols.EnumIdolType.IDOL_IRON.ordinal()) {
                        world.func_180501_a(pos, this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumCapstoneType.CAPSTONE_IRON_ACTIVE)), 3);
                        if (!player.field_71075_bZ.field_75098_d) {
                            stack.func_190918_g(1);
                        }
                    }
                    return true;
                }
                case CAPSTONE_GOLD: {
                    if (stack.func_77973_b() == ModItems.IDOLS && stack.func_77952_i() == ItemDungeonIdols.EnumIdolType.IDOL_GOLD.ordinal()) {
                        world.func_180501_a(pos, this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumCapstoneType.CAPSTONE_GOLD_ACTIVE)), 3);
                        if (!player.field_71075_bZ.field_75098_d) {
                            stack.func_190918_g(1);
                        }
                    }
                    return true;
                }
                case CAPSTONE_JADE: {
                    if (stack.func_77973_b() == ModItems.IDOLS && stack.func_77952_i() == ItemDungeonIdols.EnumIdolType.IDOL_JADE.ordinal()) {
                        world.func_180501_a(pos, this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumCapstoneType.CAPSTONE_JADE_ACTIVE)), 3);
                        if (!player.field_71075_bZ.field_75098_d) {
                            stack.func_190918_g(1);
                        }
                    }
                    return true;
                }
            }
        }
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        EnumCapstoneType type = (EnumCapstoneType)((Object)state.func_177229_b(TYPE));
        switch (type) {
            case CAPSTONE: 
            case CAPSTONE_MUD: 
            case CAPSTONE_IRON: 
            case CAPSTONE_GOLD: 
            case CAPSTONE_JADE: {
                break;
            }
            case CAPSTONE_MUD_ACTIVE: {
                if (world.func_180495_p(pos.func_177982_a(1, 0, 0)) != this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumCapstoneType.CAPSTONE_IRON_ACTIVE)) || world.func_180495_p(pos.func_177982_a(0, 0, 1)) != this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumCapstoneType.CAPSTONE_GOLD_ACTIVE)) || world.func_180495_p(pos.func_177982_a(1, 0, 1)) != this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumCapstoneType.CAPSTONE_JADE_ACTIVE))) break;
                this.openPyramid(world, pos, 1, 1);
                break;
            }
            case CAPSTONE_IRON_ACTIVE: {
                if (world.func_180495_p(pos.func_177982_a(-1, 0, 0)) != this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumCapstoneType.CAPSTONE_MUD_ACTIVE)) || world.func_180495_p(pos.func_177982_a(0, 0, 1)) != this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumCapstoneType.CAPSTONE_JADE_ACTIVE)) || world.func_180495_p(pos.func_177982_a(-1, 0, 1)) != this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumCapstoneType.CAPSTONE_GOLD_ACTIVE))) break;
                this.openPyramid(world, pos, -1, 1);
                break;
            }
            case CAPSTONE_GOLD_ACTIVE: {
                if (world.func_180495_p(pos.func_177982_a(1, 0, 0)) != this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumCapstoneType.CAPSTONE_JADE_ACTIVE)) || world.func_180495_p(pos.func_177982_a(0, 0, -1)) != this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumCapstoneType.CAPSTONE_MUD_ACTIVE)) || world.func_180495_p(pos.func_177982_a(1, 0, -1)) != this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumCapstoneType.CAPSTONE_IRON_ACTIVE))) break;
                this.openPyramid(world, pos, 1, -1);
                break;
            }
            case CAPSTONE_JADE_ACTIVE: {
                if (world.func_180495_p(pos.func_177982_a(-1, 0, 0)) != this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumCapstoneType.CAPSTONE_GOLD_ACTIVE)) || world.func_180495_p(pos.func_177982_a(0, 0, -1)) != this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumCapstoneType.CAPSTONE_IRON_ACTIVE)) || world.func_180495_p(pos.func_177982_a(-1, 0, -1)) != this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumCapstoneType.CAPSTONE_MUD_ACTIVE))) break;
                this.openPyramid(world, pos, -1, -1);
            }
        }
    }

    private void openPyramid(World world, BlockPos pos, int offsetX, int offsetZ) {
        EntityLightningBolt entitybolt = new EntityLightningBolt(world, 0.0, 0.0, 0.0, false);
        entitybolt.func_70012_b((double)(pos.func_177958_n() + offsetX), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + offsetZ), 0.0f, 0.0f);
        world.func_72942_c((Entity)entitybolt);
        world.func_180498_a(null, 2001, pos, Block.func_149682_b((Block)world.func_180495_p(pos).func_177230_c()));
        world.func_175698_g(pos);
        world.func_180498_a(null, 2001, pos.func_177982_a(offsetX, 0, 0), Block.func_149682_b((Block)world.func_180495_p(pos.func_177982_a(offsetX, 0, 0)).func_177230_c()));
        world.func_175698_g(pos.func_177982_a(offsetX, 0, 0));
        world.func_180498_a(null, 2001, pos.func_177982_a(0, 0, offsetZ), Block.func_149682_b((Block)world.func_180495_p(pos.func_177982_a(0, 0, offsetZ)).func_177230_c()));
        world.func_175698_g(pos.func_177982_a(0, 0, offsetZ));
        world.func_180498_a(null, 2001, pos.func_177982_a(offsetX, 0, offsetZ), Block.func_149682_b((Block)world.func_180495_p(pos.func_177982_a(offsetX, 0, offsetZ)).func_177230_c()));
        world.func_175698_g(pos.func_177982_a(offsetX, 0, offsetZ));
    }

    @Override
    public ItemBlock getItemBlock() {
        return ItemBlockEnum.create(this, EnumCapstoneType.class);
    }

    @Override
    public List<String> getModels() {
        ArrayList<String> models = new ArrayList<String>();
        for (EnumCapstoneType type : EnumCapstoneType.values()) {
            models.add(type.func_176610_l());
        }
        return models;
    }

    public static enum EnumCapstoneType implements IErebusEnum
    {
        CAPSTONE,
        CAPSTONE_MUD,
        CAPSTONE_IRON,
        CAPSTONE_GOLD,
        CAPSTONE_JADE,
        CAPSTONE_MUD_ACTIVE,
        CAPSTONE_IRON_ACTIVE,
        CAPSTONE_GOLD_ACTIVE,
        CAPSTONE_JADE_ACTIVE;


        @Override
        public ItemStack createStack(int size) {
            return new ItemStack(ModBlocks.CAPSTONE, size, this.ordinal());
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

