/*
 * Decompiled with CFR 0.152.
 */
package erebus.block.bamboo;

import erebus.ModTabs;
import erebus.blocks.EnumWood;
import erebus.core.helper.Utils;
import erebus.tileentity.TileEntityBambooBridge;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBambooBridge
extends Block
implements ITileEntityProvider {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static double PIXEL = 0.0625;
    public static final AxisAlignedBB RIGHT_AABB = new AxisAlignedBB(1.0 - PIXEL * 2.0, 0.0, 0.0, 1.0, 0.875, 1.0);
    public static final AxisAlignedBB LEFT_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0 + PIXEL * 2.0, 0.875, 1.0);
    public static final AxisAlignedBB BACK_AABB = new AxisAlignedBB(0.0, 0.0, 1.0 - PIXEL * 2.0, 1.0, 0.875, 1.0);
    public static final AxisAlignedBB FRONT_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 0.0 + PIXEL * 2.0);
    public static final AxisAlignedBB BASE = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, PIXEL * 2.0, 1.0);

    public BlockBambooBridge() {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149647_a(ModTabs.BLOCKS);
        this.func_149711_c(0.4f);
        this.func_149672_a(SoundType.field_185857_j);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityBambooBridge();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        return meta |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()), 3);
        this.func_176213_c(world, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)EnumWood.BAMBOO.getLog().func_176223_P()));
        super.func_180663_b(world, pos, state);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        TileEntityBambooBridge te = Utils.getTileEntity((IBlockAccess)world, pos, TileEntityBambooBridge.class);
        boolean front = this.canConnectBridgeTo((IBlockAccess)world, pos.func_177982_a(0, 0, -1));
        boolean back = this.canConnectBridgeTo((IBlockAccess)world, pos.func_177982_a(0, 0, 1));
        boolean left = this.canConnectBridgeTo((IBlockAccess)world, pos.func_177982_a(-1, 0, 0));
        boolean right = this.canConnectBridgeTo((IBlockAccess)world, pos.func_177982_a(1, 0, 0));
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                if (!right) {
                    te.setRenderSide1(true);
                }
                if (!left) {
                    te.setRenderSide2(true);
                }
                if (right) {
                    te.setRenderSide1(false);
                }
                if (!left) break;
                te.setRenderSide2(false);
                break;
            }
            case SOUTH: {
                if (!right) {
                    te.setRenderSide2(true);
                }
                if (!left) {
                    te.setRenderSide1(true);
                }
                if (right) {
                    te.setRenderSide2(false);
                }
                if (!left) break;
                te.setRenderSide1(false);
                break;
            }
            case EAST: {
                if (!back) {
                    te.setRenderSide1(true);
                }
                if (!front) {
                    te.setRenderSide2(true);
                }
                if (back) {
                    te.setRenderSide1(false);
                }
                if (!front) break;
                te.setRenderSide2(false);
                break;
            }
            case WEST: {
                if (!back) {
                    te.setRenderSide2(true);
                }
                if (!front) {
                    te.setRenderSide1(true);
                }
                if (back) {
                    te.setRenderSide2(false);
                }
                if (!front) break;
                te.setRenderSide1(false);
            }
        }
        world.func_184138_a(pos, state, state, 2);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        this.func_176213_c(world, pos, state);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (!isActualState) {
            state = state.func_185899_b((IBlockAccess)world, pos);
        }
        boolean front = this.canConnectBridgeTo((IBlockAccess)world, pos.func_177982_a(0, 0, -1));
        boolean back = this.canConnectBridgeTo((IBlockAccess)world, pos.func_177982_a(0, 0, 1));
        boolean left = this.canConnectBridgeTo((IBlockAccess)world, pos.func_177982_a(-1, 0, 0));
        boolean right = this.canConnectBridgeTo((IBlockAccess)world, pos.func_177982_a(1, 0, 0));
        BlockBambooBridge.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BASE);
        if (((EnumFacing)state.func_177229_b((IProperty)FACING)).equals((Object)EnumFacing.NORTH) || ((EnumFacing)state.func_177229_b((IProperty)FACING)).equals((Object)EnumFacing.SOUTH)) {
            if (!right) {
                BlockBambooBridge.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)RIGHT_AABB);
            }
            if (!left) {
                BlockBambooBridge.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)LEFT_AABB);
            }
        }
        if (((EnumFacing)state.func_177229_b((IProperty)FACING)).equals((Object)EnumFacing.EAST) || ((EnumFacing)state.func_177229_b((IProperty)FACING)).equals((Object)EnumFacing.WEST)) {
            if (!back) {
                BlockBambooBridge.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BACK_AABB);
            }
            if (!front) {
                BlockBambooBridge.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)FRONT_AABB);
            }
        }
    }

    public boolean canConnectBridgeTo(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block != this) {
            return !world.func_175623_d(pos) && state.func_185915_l() ? state.func_185904_a() != Material.field_151572_C : false;
        }
        return true;
    }
}

