/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.worldgen;

import com.google.common.collect.ImmutableMap;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.living.EntityEvilWizard;
import electroblob.wizardry.entity.living.EntityWizard;
import electroblob.wizardry.entity.living.ISpellCaster;
import electroblob.wizardry.integration.antiqueatlas.WizardryAntiqueAtlasIntegration;
import electroblob.wizardry.util.WizardryUtilities;
import electroblob.wizardry.worldgen.MossifierTemplateProcessor;
import electroblob.wizardry.worldgen.MultiTemplateProcessor;
import electroblob.wizardry.worldgen.WoodTypeTemplateProcessor;
import electroblob.wizardry.worldgen.WorldGenSurfaceStructure;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockStainedHardenedClay;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class WorldGenWizardTower
extends WorldGenSurfaceStructure {
    private static final String WIZARD_DATA_BLOCK_TAG = "wizard";
    private static final String EVIL_WIZARD_DATA_BLOCK_TAG = "evil_wizard";
    private final Map<BiomeDictionary.Type, IBlockState> SPECIAL_WALL_BLOCKS = ImmutableMap.of((Object)BiomeDictionary.Type.MESA, (Object)Blocks.field_180395_cM.func_176223_P(), (Object)BiomeDictionary.Type.MOUNTAIN, (Object)Blocks.field_150417_aV.func_176223_P(), (Object)BiomeDictionary.Type.NETHER, (Object)Blocks.field_150385_bj.func_176223_P(), (Object)BiomeDictionary.Type.SANDY, (Object)Blocks.field_150322_A.func_176223_P());

    @Override
    public String getStructureName() {
        return "wizard_tower";
    }

    @Override
    public long getRandomSeedModifier() {
        return 10473957L;
    }

    @Override
    public boolean canGenerate(Random random, World world, int chunkX, int chunkZ) {
        return ArrayUtils.contains((int[])Wizardry.settings.towerDimensions, (int)world.field_73011_w.getDimension()) && Wizardry.settings.towerRarity > 0 && random.nextInt(Wizardry.settings.towerRarity) == 0;
    }

    @Override
    public ResourceLocation getStructureFile(Random random) {
        return random.nextDouble() < Wizardry.settings.evilWizardChance ? Wizardry.settings.towerWithChestFiles[random.nextInt(Wizardry.settings.towerWithChestFiles.length)] : Wizardry.settings.towerFiles[random.nextInt(Wizardry.settings.towerFiles.length)];
    }

    @Override
    public void spawnStructure(Random random, World world, BlockPos origin, Template template, PlacementSettings settings, ResourceLocation structureFile) {
        EnumDyeColor colour = EnumDyeColor.values()[random.nextInt(EnumDyeColor.values().length)];
        Biome biome = world.func_180494_b(origin);
        IBlockState wallMaterial = this.SPECIAL_WALL_BLOCKS.keySet().stream().filter(t -> BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)t)).findFirst().map(this.SPECIAL_WALL_BLOCKS::get).orElse(Blocks.field_150347_e.func_176223_P());
        float mossiness = WorldGenWizardTower.getBiomeMossiness(biome);
        BlockPlanks.EnumType woodType = WorldGenWizardTower.getBiomeWoodVariant(biome);
        HashSet<BlockPos> blocksPlaced = new HashSet<BlockPos>();
        MultiTemplateProcessor processor = new MultiTemplateProcessor(true, (w, p, i) -> i.field_186243_b.func_177230_c() instanceof BlockStainedHardenedClay ? new Template.BlockInfo(i.field_186242_a, i.field_186243_b.func_177226_a((IProperty)BlockStainedHardenedClay.field_176581_a, (Comparable)colour), i.field_186244_c) : i, (w, p, i) -> i.field_186243_b.func_177230_c() == Blocks.field_150347_e ? new Template.BlockInfo(i.field_186242_a, wallMaterial, i.field_186244_c) : i, new WoodTypeTemplateProcessor(woodType), new MossifierTemplateProcessor(mossiness, 0.04f, origin.func_177956_o() + 1), (w, p, i) -> {
            if (i.field_186243_b.func_177230_c() != Blocks.field_150350_a) {
                blocksPlaced.add(p);
            }
            return i;
        });
        template.func_189960_a(world, origin, (ITemplateProcessor)processor, settings, 2);
        WizardryAntiqueAtlasIntegration.markTower(world, origin.func_177958_n(), origin.func_177952_p());
        Map dataBlocks = template.func_186258_a(origin, settings);
        for (Map.Entry entry : dataBlocks.entrySet()) {
            ISpellCaster wizard;
            Vec3d vec = WizardryUtilities.getCentre((BlockPos)entry.getKey());
            if (((String)entry.getValue()).equals(WIZARD_DATA_BLOCK_TAG)) {
                wizard = new EntityWizard(world);
                wizard.func_70012_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0.0f, 0.0f);
                ((EntityWizard)wizard).func_180482_a(world.func_175649_E(origin), null);
                ((EntityWizard)wizard).setTowerBlocks(blocksPlaced);
                world.func_72838_d((Entity)wizard);
                continue;
            }
            if (((String)entry.getValue()).equals(EVIL_WIZARD_DATA_BLOCK_TAG)) {
                wizard = new EntityEvilWizard(world);
                wizard.func_70012_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0.0f, 0.0f);
                ((EntityEvilWizard)wizard).hasStructure = true;
                ((EntityEvilWizard)wizard).func_180482_a(world.func_175649_E(origin), null);
                world.func_72838_d((Entity)wizard);
                continue;
            }
            Wizardry.logger.info("Unrecognised data block value {} in structure {}", entry.getValue(), (Object)structureFile);
        }
    }

    private static float getBiomeMossiness(Biome biome) {
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DENSE)) {
            return 0.7f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            return 0.7f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WET)) {
            return 0.5f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            return 0.5f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            return 0.3f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.LUSH)) {
            return 0.3f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY)) {
            return 0.0f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) {
            return 0.0f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
            return 0.0f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND)) {
            return 0.0f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            return 0.0f;
        }
        return 0.1f;
    }

    private static BlockPlanks.EnumType getBiomeWoodVariant(Biome biome) {
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS)) {
            return BlockPlanks.EnumType.SPRUCE;
        }
        if (biome == Biomes.field_150583_P || biome == Biomes.field_150582_Q) {
            return BlockPlanks.EnumType.BIRCH;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            return BlockPlanks.EnumType.JUNGLE;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA)) {
            return BlockPlanks.EnumType.ACACIA;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY)) {
            return BlockPlanks.EnumType.DARK_OAK;
        }
        return BlockPlanks.EnumType.OAK;
    }
}

