/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.tileentity;

import electroblob.wizardry.event.SpellBindEvent;
import electroblob.wizardry.item.IWorkbenchItem;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.registry.WizardryAdvancementTriggers;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.tileentity.SlotItemClassList;
import electroblob.wizardry.tileentity.SlotItemList;
import electroblob.wizardry.tileentity.SlotWorkbenchItem;
import electroblob.wizardry.tileentity.TileEntityArcaneWorkbench;
import electroblob.wizardry.util.WandHelper;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ContainerArcaneWorkbench
extends Container {
    public TileEntityArcaneWorkbench tileentity;
    public static final ResourceLocation EMPTY_SLOT_CRYSTAL = new ResourceLocation("ebwizardry", "gui/empty_slot_crystal");
    public static final ResourceLocation EMPTY_SLOT_UPGRADE = new ResourceLocation("ebwizardry", "gui/empty_slot_upgrade");
    public static final int CRYSTAL_SLOT = 8;
    public static final int CENTRE_SLOT = 9;
    public static final int UPGRADE_SLOT = 10;
    public static final int SLOT_RADIUS = 42;

    public ContainerArcaneWorkbench(IInventory inventory, TileEntityArcaneWorkbench tileentity) {
        this.tileentity = tileentity;
        ItemStack wand = tileentity.func_70301_a(9);
        for (int i = 0; i < 8; ++i) {
            SlotItemClassList slot = new SlotItemClassList(tileentity, i, -999, -999, 1, ItemSpellBook.class);
            this.func_75146_a(slot);
        }
        this.func_75146_a(new SlotItemList(tileentity, 8, 13, 101, 64, WizardryItems.magic_crystal, WizardryItems.crystal_shard, WizardryItems.grand_crystal)).setBackgroundName(EMPTY_SLOT_CRYSTAL.toString());
        this.func_75146_a(new SlotWorkbenchItem(tileentity, 9, 80, 64, this));
        HashSet<Item> upgrades = new HashSet<Item>(WandHelper.getSpecialUpgrades());
        upgrades.add(WizardryItems.arcane_tome);
        upgrades.add(WizardryItems.armour_upgrade);
        this.func_75146_a(new SlotItemList(tileentity, 10, 147, 17, 1, upgrades.toArray(new Item[0]))).setBackgroundName(EMPTY_SLOT_UPGRADE.toString());
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot(inventory, x, 8 + x * 18, 196));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot(inventory, 9 + x + y * 9, 8 + x * 18, 138 + y * 18));
            }
        }
        this.onSlotChanged(9, wand, null);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.tileentity.func_70300_a(player);
    }

    private void showSlot(int index, int x, int y) {
        Slot slot = this.func_75139_a(index);
        slot.field_75223_e = x;
        slot.field_75221_f = y;
    }

    private void hideSlot(int index, EntityPlayer player) {
        Slot slot = this.func_75139_a(index);
        slot.field_75223_e = -999;
        slot.field_75221_f = -999;
        ItemStack stack = slot.func_75211_c();
        ItemStack remainder = this.func_82846_b(player, index);
        if (remainder == ItemStack.field_190927_a && stack != ItemStack.field_190927_a) {
            slot.func_75215_d(ItemStack.field_190927_a);
            if (player != null) {
                player.func_71019_a(stack, false);
            }
        }
    }

    public void onSlotChanged(int slotNumber, ItemStack stack, EntityPlayer player) {
        if (slotNumber == 9) {
            if (stack.func_190926_b()) {
                for (int i = 0; i < 8; ++i) {
                    this.hideSlot(i, player);
                }
            } else if (stack.func_77973_b() instanceof IWorkbenchItem) {
                int i;
                int spellSlots = ((IWorkbenchItem)stack.func_77973_b()).getSpellSlotCount(stack);
                int centreX = this.func_75139_a((int)9).field_75223_e;
                int centreY = this.func_75139_a((int)9).field_75221_f;
                for (i = 0; i < spellSlots; ++i) {
                    float angle = (float)i * ((float)Math.PI * 2) / (float)spellSlots;
                    int x = centreX + Math.round(42.0f * MathHelper.func_76126_a((float)angle));
                    int y = centreY + Math.round(42.0f * -MathHelper.func_76134_b((float)angle));
                    this.showSlot(i, x, y);
                }
                for (i = spellSlots; i < 8; ++i) {
                    this.hideSlot(i, player);
                }
            }
        }
        this.tileentity.sync();
    }

    public ItemStack func_82846_b(EntityPlayer player, int clickedSlotId) {
        ItemStack remainder = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(clickedSlotId);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            remainder = stack.func_77946_l();
            if (clickedSlotId <= 10) {
                if (!this.func_75135_a(stack, 11, this.field_75151_b.size(), true)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                int minSlotId = 0;
                int maxSlotId = 10;
                if (stack.func_77973_b() instanceof ItemSpellBook) {
                    minSlotId = 0;
                    maxSlotId = 7;
                } else if (this.func_75139_a(8).func_75214_a(stack)) {
                    minSlotId = 8;
                    maxSlotId = 8;
                } else if (this.func_75139_a(9).func_75214_a(stack)) {
                    minSlotId = 9;
                    maxSlotId = 9;
                } else if (this.func_75139_a(10).func_75214_a(stack)) {
                    minSlotId = 10;
                    maxSlotId = 10;
                } else {
                    return ItemStack.field_190927_a;
                }
                if (!this.func_75135_a(stack, minSlotId, maxSlotId + 1, false)) {
                    return ItemStack.field_190927_a;
                }
            }
            if (stack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack.func_190916_E() == remainder.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, stack);
        }
        return remainder;
    }

    protected boolean func_75135_a(ItemStack stack, int minSlotID, int maxSlotID, boolean p_75135_4_) {
        for (int i = minSlotID; i < maxSlotID; ++i) {
            if (this.func_75139_a((int)i).field_75223_e < 0 || this.func_75139_a((int)i).field_75221_f < 0 || this.func_75139_a(i).func_75216_d()) continue;
            return super.func_75135_a(stack, minSlotID, maxSlotID, p_75135_4_);
        }
        return false;
    }

    public void onApplyButtonPressed(EntityPlayer player) {
        if (MinecraftForge.EVENT_BUS.post((Event)new SpellBindEvent(player, this))) {
            return;
        }
        Slot centre = this.func_75139_a(9);
        if (centre.func_75211_c().func_77973_b() instanceof IWorkbenchItem) {
            Slot[] spellBooks = this.field_75151_b.subList(0, 8).toArray(new Slot[8]);
            if (((IWorkbenchItem)centre.func_75211_c().func_77973_b()).onApplyButtonPressed(player, centre, this.func_75139_a(8), this.func_75139_a(10), spellBooks) && player instanceof EntityPlayerMP) {
                WizardryAdvancementTriggers.arcane_workbench.trigger((EntityPlayerMP)player, centre.func_75211_c());
            }
        }
    }
}

