/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.entity.living.ISpellCaster;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.function.BiFunction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class SpellThrowable<T extends EntityThrowable>
extends Spell {
    private static final float LAUNCH_Y_OFFSET = 0.1f;
    protected final BiFunction<World, EntityLivingBase, T> projectileFactory;

    public SpellThrowable(String name, BiFunction<World, EntityLivingBase, T> projectileFactory) {
        this("ebwizardry", name, projectileFactory);
    }

    public SpellThrowable(String modID, String name, BiFunction<World, EntityLivingBase, T> projectileFactory) {
        super(modID, name, EnumAction.NONE, false);
        this.projectileFactory = projectileFactory;
        this.addProperties("range");
        this.npcSelector((e, o) -> true);
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    protected float calculateVelocity(SpellModifiers modifiers, float launchHeight) {
        float g = 0.03f;
        float range = this.getProperty("range").floatValue() * modifiers.get(WizardryItems.range_upgrade);
        return range / MathHelper.func_76129_c((float)(2.0f * launchHeight / g));
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            float velocity = this.calculateVelocity(modifiers, caster.func_70047_e() - 0.1f);
            EntityThrowable projectile = (EntityThrowable)this.projectileFactory.apply(world, (EntityLivingBase)caster);
            projectile.func_184538_a((Entity)caster, caster.field_70125_A, caster.field_70177_z, 0.0f, velocity, 1.0f);
            this.addProjectileExtras(projectile, (EntityLivingBase)caster, modifiers);
            world.func_72838_d((Entity)projectile);
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        caster.func_184609_a(hand);
        return true;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (target != null) {
            if (!world.field_72995_K) {
                float velocity = this.calculateVelocity(modifiers, caster.func_70047_e() - 0.1f);
                EntityThrowable projectile = (EntityThrowable)this.projectileFactory.apply(world, (EntityLivingBase)caster);
                int aimingError = caster instanceof ISpellCaster ? ((ISpellCaster)caster).getAimingError(world.func_175659_aa()) : WizardryUtilities.getDefaultAimingError(world.func_175659_aa());
                this.aim(projectile, (EntityLivingBase)caster, (Entity)target, velocity, aimingError);
                this.addProjectileExtras(projectile, (EntityLivingBase)caster, modifiers);
                world.func_72838_d((Entity)projectile);
            }
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            caster.func_184609_a(hand);
            return true;
        }
        return false;
    }

    private void aim(T throwable, EntityLivingBase caster, Entity target, float speed, float aimingError) {
        ((EntityThrowable)throwable).field_184539_c = caster;
        ((EntityThrowable)throwable).field_70163_u = caster.func_174813_aQ().field_72338_b + (double)caster.func_70047_e() - (double)0.1f;
        double dx = target.field_70165_t - caster.field_70165_t;
        double dy = !throwable.func_189652_ae() ? target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - ((EntityThrowable)throwable).field_70163_u : target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) - ((EntityThrowable)throwable).field_70163_u;
        double dz = target.field_70161_v - caster.field_70161_v;
        double horizontalDistance = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        if (horizontalDistance >= 1.0E-7) {
            double dxNormalised = dx / horizontalDistance;
            double dzNormalised = dz / horizontalDistance;
            throwable.func_70107_b(caster.field_70165_t + dxNormalised, ((EntityThrowable)throwable).field_70163_u, caster.field_70161_v + dzNormalised);
            float bulletDropCompensation = !throwable.func_189652_ae() ? (float)horizontalDistance * 0.2f : 0.0f;
            throwable.func_70186_c(dx, dy + (double)bulletDropCompensation, dz, speed, aimingError);
        }
    }

    protected void addProjectileExtras(T projectile, EntityLivingBase caster, SpellModifiers modifiers) {
    }
}

