/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.tileentity.TileEntityPlayerSave;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Snare
extends SpellRay {
    public Snare() {
        super("snare", false, EnumAction.NONE);
        this.soundValues(1.0f, 1.4f, 0.4f);
        this.ignoreLivingEntities(true);
        this.addProperties("damage", "effect_duration", "effect_strength");
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (side == EnumFacing.UP && world.isSideSolid(pos, EnumFacing.UP) && WizardryUtilities.canBlockBeReplaced(world, pos.func_177984_a())) {
            if (!world.field_72995_K) {
                world.func_175656_a(pos.func_177984_a(), WizardryBlocks.snare.func_176223_P());
                ((TileEntityPlayerSave)world.func_175625_s(pos.func_177984_a())).setCaster(caster);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        float brightness = world.field_73012_v.nextFloat() * 0.25f;
        ParticleBuilder.create(ParticleBuilder.Type.SPARKLE).pos(x, y, z).time(20 + world.field_73012_v.nextInt(8)).clr(brightness, brightness + 0.1f, 0.0f).spawn(world);
        ParticleBuilder.create(ParticleBuilder.Type.LEAF).pos(x, y, z).vel(0.0, -0.01, 0.0).time(40 + world.field_73012_v.nextInt(10)).spawn(world);
    }
}

