/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Settings;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;

public class PocketFurnace
extends Spell {
    public static final String ITEMS_SMELTED = "items_smelted";

    public PocketFurnace() {
        super("pocket_furnace", EnumAction.BOW, false);
        this.addProperties(ITEMS_SMELTED);
        this.soundValues(1.0f, 0.75f, 0.0f);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        int i;
        int usesLeft = (int)(this.getProperty(ITEMS_SMELTED).floatValue() * modifiers.get("potency"));
        for (i = 0; i < caster.field_71071_by.func_70302_i_() && usesLeft > 0; ++i) {
            ItemStack result;
            ItemStack stack = caster.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || world.field_72995_K || (result = FurnaceRecipes.func_77602_a().func_151395_a(stack)).func_190926_b() || stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemArmor || Settings.containsMetaItem(Wizardry.settings.pocketFurnaceItemBlacklist, stack)) continue;
            if (stack.func_190916_E() <= usesLeft) {
                ItemStack stack2 = new ItemStack(result.func_77973_b(), stack.func_190916_E(), result.func_77952_i());
                if (WizardryUtilities.doesPlayerHaveItem(caster, result.func_77973_b())) {
                    caster.field_71071_by.func_70441_a(stack2);
                    caster.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                } else {
                    caster.field_71071_by.func_70299_a(i, stack2);
                }
                usesLeft -= stack.func_190916_E();
                continue;
            }
            caster.field_71071_by.func_70298_a(i, usesLeft);
            caster.field_71071_by.func_70441_a(new ItemStack(result.func_77973_b(), usesLeft, result.func_77952_i()));
            usesLeft = 0;
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        if (world.field_72995_K) {
            for (i = 0; i < 10; ++i) {
                double x1 = (float)caster.field_70165_t + world.field_73012_v.nextFloat() * 2.0f - 1.0f;
                double y1 = (float)caster.func_174813_aQ().field_72338_b + caster.func_70047_e() - 0.5f + world.field_73012_v.nextFloat();
                double z1 = (float)caster.field_70161_v + world.field_73012_v.nextFloat() * 2.0f - 1.0f;
                world.func_175688_a(EnumParticleTypes.FLAME, x1, y1, z1, 0.0, (double)0.01f, 0.0, new int[0]);
            }
        }
        return usesLeft < 5;
    }
}

