/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.RayTracer;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class PhaseStep
extends Spell {
    public static final String WALL_THICKNESS = "wall_thickness";

    public PhaseStep() {
        super("phase_step", EnumAction.NONE, false);
        this.addProperties("range", WALL_THICKNESS);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        double range = this.getProperty("range").floatValue() * modifiers.get(WizardryItems.range_upgrade);
        RayTraceResult rayTrace = RayTracer.standardBlockRayTrace(world, (EntityLivingBase)caster, range, false);
        if (world.field_72995_K) {
            for (int i = 0; i < 10; ++i) {
                double dx1 = caster.field_70165_t;
                double dy1 = caster.func_174813_aQ().field_72338_b + (double)(2.0f * world.field_73012_v.nextFloat());
                double dz1 = caster.field_70161_v;
                world.func_175688_a(EnumParticleTypes.PORTAL, dx1, dy1, dz1, world.field_73012_v.nextDouble() - 0.5, world.field_73012_v.nextDouble() - 0.5, world.field_73012_v.nextDouble() - 0.5, new int[0]);
            }
            Wizardry.proxy.playBlinkEffect(caster);
        }
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos1;
            BlockPos pos = rayTrace.func_178782_a();
            int maxThickness = this.getProperty(WALL_THICKNESS).intValue() + (int)((modifiers.get(WizardryItems.range_upgrade) - 1.0f) / 0.25f + 0.5f);
            if (rayTrace.field_178784_b == EnumFacing.UP) {
                ++maxThickness;
            }
            for (int i = 0; i <= maxThickness && (!WizardryUtilities.isBlockUnbreakable(world, pos1 = pos.func_177967_a(rayTrace.field_178784_b.func_176734_d(), i)) && !WizardryUtilities.isBlockUnbreakable(world, pos1.func_177984_a()) || Wizardry.settings.teleportThroughUnbreakableBlocks); ++i) {
                if (world.func_180495_p(pos1).func_185904_a().func_76230_c() || world.func_180495_p(pos1.func_177984_a()).func_185904_a().func_76230_c()) continue;
                this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
                if (!world.field_72995_K) {
                    caster.func_70634_a((double)pos1.func_177958_n() + 0.5, (double)pos1.func_177956_o() + 0.5, (double)pos1.func_177952_p() + 0.5);
                }
                caster.func_184609_a(hand);
                this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
                return true;
            }
            if (rayTrace.field_178784_b == EnumFacing.DOWN) {
                pos = pos.func_177977_b();
            }
            if (rayTrace.field_178784_b == EnumFacing.UP && !world.func_180495_p(pos).func_185904_a().func_76230_c()) {
                pos = pos.func_177977_b();
            }
            if (world.func_180495_p(pos = pos.func_177972_a(rayTrace.field_178784_b)).func_185904_a().func_76230_c() || world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76230_c()) {
                return false;
            }
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            if (!world.field_72995_K) {
                caster.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            }
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            caster.func_184609_a(hand);
            return true;
        }
        Vec3d destination = caster.func_174791_d().func_178787_e(caster.func_70040_Z().func_186678_a(range));
        BlockPos pos = new BlockPos(destination);
        if (world.func_180495_p(pos).func_185904_a().func_76230_c() || world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76230_c()) {
            return false;
        }
        if (!world.field_72995_K) {
            caster.func_70634_a(destination.field_72450_a, destination.field_72448_b, destination.field_72449_c);
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        caster.func_184609_a(hand);
        return true;
    }
}

