/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.living.EntityEvilWizard;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class MindControl
extends SpellRay {
    public static final String NBT_KEY = "controllingEntity";

    public MindControl() {
        super("mind_control", false, EnumAction.NONE);
        this.addProperties("effect_duration");
    }

    @Override
    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    @Override
    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (WizardryUtilities.isLiving(target)) {
            if (!MindControl.canControl(target)) {
                if (!world.field_72995_K && caster instanceof EntityPlayer) {
                    ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}), true);
                }
            } else if (target instanceof EntityLiving) {
                if (!world.field_72995_K && !MindControl.findMindControlTarget((EntityLiving)target, caster, world)) {
                    ((EntityLiving)target).func_70624_b(null);
                }
                if (target instanceof EntitySheep && ((EntitySheep)target).func_175509_cj() == EnumDyeColor.BLUE && WizardryUtilities.canDamageBlocks(caster, world)) {
                    if (!world.field_72995_K) {
                        ((EntitySheep)target).func_175512_b(EnumDyeColor.RED);
                    }
                    world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, SoundEvents.field_191249_bs, WizardrySounds.SPELLS, 1.0f, 1.0f, false);
                }
                if (!world.field_72995_K) {
                    MindControl.startControlling((EntityLiving)target, caster, (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade)));
                }
            }
            if (world.field_72995_K) {
                for (int i = 0; i < 10; ++i) {
                    ParticleBuilder.create(ParticleBuilder.Type.DARK_MAGIC, world.field_73012_v, target.field_70165_t, target.func_174813_aQ().field_72338_b + (double)target.func_70047_e(), target.field_70161_v, 0.25, false).clr(0.8f, 0.2f, 1.0f).spawn(world);
                    ParticleBuilder.create(ParticleBuilder.Type.DARK_MAGIC, world.field_73012_v, target.field_70165_t, target.func_174813_aQ().field_72338_b + (double)target.func_70047_e(), target.field_70161_v, 0.25, false).clr(0.2f, 0.04f, 0.25f).spawn(world);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    public static boolean canControl(Entity target) {
        return target instanceof EntityLiving && target.func_184222_aU() && !(target instanceof INpc) && !(target instanceof EntityEvilWizard) && !Arrays.asList(Wizardry.settings.mindControlTargetsBlacklist).contains(EntityList.func_191306_a(target.getClass()));
    }

    public static void startControlling(EntityLiving target, EntityLivingBase controller, int duration) {
        target.getEntityData().func_186854_a(NBT_KEY, controller.func_110124_au());
        target.func_70690_d(new PotionEffect(WizardryPotions.mind_control, duration, 0));
    }

    public static boolean findMindControlTarget(EntityLiving target, EntityLivingBase caster, World world) {
        List<EntityLivingBase> possibleTargets = WizardryUtilities.getEntitiesWithinRadius(target.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e(), target.field_70165_t, target.field_70163_u, target.field_70161_v, world);
        possibleTargets.remove(target);
        possibleTargets.removeIf(e -> e instanceof EntityArmorStand);
        EntityLivingBase newAITarget = null;
        for (EntityLivingBase possibleTarget : possibleTargets) {
            if (!AllyDesignationSystem.isValidTarget((Entity)caster, (Entity)possibleTarget) || newAITarget != null && !(target.func_70032_d((Entity)possibleTarget) < target.func_70032_d((Entity)newAITarget))) continue;
            newAITarget = possibleTarget;
        }
        if (newAITarget != null) {
            target.func_70624_b(newAITarget);
            return true;
        }
        return false;
    }

    private static void processTargeting(World world, EntityLiving entity, EntityLivingBase currentTarget) {
        if (entity.func_70644_a(WizardryPotions.mind_control) && MindControl.canControl((Entity)entity)) {
            Entity caster;
            NBTTagCompound entityNBT = entity.getEntityData();
            if (entityNBT != null && entityNBT.func_186855_b(NBT_KEY) && (caster = WizardryUtilities.getEntityByUUID(world, entityNBT.func_186857_a(NBT_KEY))) instanceof EntityLivingBase) {
                if (AllyDesignationSystem.isValidTarget(caster, (Entity)currentTarget)) {
                    return;
                }
                if (MindControl.findMindControlTarget(entity, (EntityLivingBase)caster, world)) {
                    return;
                }
            }
            entity.func_70624_b(null);
        }
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving().func_70644_a(WizardryPotions.mind_control) && event.getEntityLiving() instanceof EntityLiving) {
            EntityLiving entity = (EntityLiving)event.getEntityLiving();
            if (((EntityLiving)event.getEntityLiving()).func_70638_az() == null || !((EntityLiving)event.getEntityLiving()).func_70638_az().func_70089_S()) {
                MindControl.processTargeting(entity.field_70170_p, entity, entity.func_70638_az());
            }
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTargetEvent(LivingSetAttackTargetEvent event) {
        if (event.getTarget() != null && event.getEntityLiving() instanceof EntityLiving) {
            MindControl.processTargeting(event.getEntity().field_70170_p, (EntityLiving)event.getEntityLiving(), event.getTarget());
        }
    }
}

