/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class LightningWeb
extends SpellRay {
    public static final String PRIMARY_DAMAGE = "primary_damage";
    public static final String SECONDARY_DAMAGE = "secondary_damage";
    public static final String TERTIARY_DAMAGE = "tertiary_damage";
    public static final String SECONDARY_RANGE = "secondary_range";
    public static final String TERTIARY_RANGE = "tertiary_range";
    public static final String SECONDARY_MAX_TARGETS = "secondary_max_targets";
    public static final String TERTIARY_MAX_TARGETS = "tertiary_max_targets";

    public LightningWeb() {
        super("lightning_web", true, EnumAction.NONE);
        this.aimAssist(0.6f);
        this.addProperties(PRIMARY_DAMAGE, SECONDARY_DAMAGE, TERTIARY_DAMAGE, SECONDARY_RANGE, TERTIARY_RANGE, SECONDARY_MAX_TARGETS, TERTIARY_MAX_TARGETS);
    }

    @Override
    protected SoundEvent[] createSounds() {
        return this.createContinuousSpellSounds();
    }

    @Override
    protected void playSound(World world, EntityLivingBase entity, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, entity, ticksInUse);
    }

    @Override
    protected void playSound(World world, double x, double y, double z, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (WizardryUtilities.isLiving(target)) {
            this.electrocute(world, (Entity)caster, origin, target, this.getProperty(PRIMARY_DAMAGE).floatValue() * modifiers.get("potency"), ticksInUse);
            List<EntityLivingBase> secondaryTargets = WizardryUtilities.getEntitiesWithinRadius(this.getProperty(SECONDARY_RANGE).floatValue(), target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v, world);
            secondaryTargets.remove(target);
            secondaryTargets.removeIf(e -> !WizardryUtilities.isLiving((Entity)e));
            secondaryTargets.removeIf(e -> !AllyDesignationSystem.isValidTarget((Entity)caster, (Entity)e));
            if (secondaryTargets.size() > this.getProperty(SECONDARY_MAX_TARGETS).intValue()) {
                secondaryTargets = secondaryTargets.subList(0, this.getProperty(SECONDARY_MAX_TARGETS).intValue());
            }
            for (EntityLivingBase secondaryTarget : secondaryTargets) {
                this.electrocute(world, (Entity)caster, target.func_174791_d().func_72441_c(0.0, (double)(target.field_70131_O / 2.0f), 0.0), (Entity)secondaryTarget, this.getProperty(SECONDARY_DAMAGE).floatValue() * modifiers.get("potency"), ticksInUse);
                List<EntityLivingBase> tertiaryTargets = WizardryUtilities.getEntitiesWithinRadius(this.getProperty(TERTIARY_RANGE).floatValue(), secondaryTarget.field_70165_t, secondaryTarget.field_70163_u + (double)(secondaryTarget.field_70131_O / 2.0f), secondaryTarget.field_70161_v, world);
                tertiaryTargets.remove(target);
                tertiaryTargets.removeAll(secondaryTargets);
                tertiaryTargets.removeIf(e -> !WizardryUtilities.isLiving((Entity)e));
                tertiaryTargets.removeIf(e -> !AllyDesignationSystem.isValidTarget((Entity)caster, (Entity)e));
                if (tertiaryTargets.size() > this.getProperty(TERTIARY_MAX_TARGETS).intValue()) {
                    tertiaryTargets = tertiaryTargets.subList(0, this.getProperty(TERTIARY_MAX_TARGETS).intValue());
                }
                for (EntityLivingBase tertiaryTarget : tertiaryTargets) {
                    this.electrocute(world, (Entity)caster, secondaryTarget.func_174791_d().func_72441_c(0.0, (double)(secondaryTarget.field_70131_O / 2.0f), 0.0), (Entity)tertiaryTarget, this.getProperty(TERTIARY_DAMAGE).floatValue() * modifiers.get("potency"), ticksInUse);
                }
            }
        }
        return true;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        if (world.field_72995_K) {
            double freeRange = 0.8 * this.getRange(world, origin, direction, caster, ticksInUse, modifiers);
            if (caster != null) {
                ParticleBuilder.create(ParticleBuilder.Type.BEAM).entity((Entity)caster).pos(origin.func_178788_d(caster.func_174791_d())).length(freeRange).clr(0.2f, 0.6f, 1.0f).spawn(world);
            } else {
                ParticleBuilder.create(ParticleBuilder.Type.BEAM).pos(origin).target(origin.func_178787_e(direction.func_186678_a(freeRange))).clr(0.2f, 0.6f, 1.0f).spawn(world);
            }
            if (ticksInUse % 4 == 0) {
                if (caster != null) {
                    ParticleBuilder.create(ParticleBuilder.Type.LIGHTNING).entity((Entity)caster).pos(origin.func_178788_d(caster.func_174791_d())).length(freeRange).spawn(world);
                } else {
                    ParticleBuilder.create(ParticleBuilder.Type.LIGHTNING).pos(origin).target(origin.func_178787_e(direction.func_186678_a(freeRange))).spawn(world);
                }
            }
        }
        return true;
    }

    private void electrocute(World world, Entity caster, Vec3d origin, Entity target, float damage, int ticksInUse) {
        if (MagicDamage.isEntityImmune(MagicDamage.DamageType.SHOCK, target)) {
            if (!world.field_72995_K && ticksInUse == 1 && caster instanceof EntityPlayer) {
                ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}), true);
            }
        } else {
            WizardryUtilities.attackEntityWithoutKnockback(target, MagicDamage.causeDirectMagicDamage(caster, MagicDamage.DamageType.SHOCK), damage);
        }
        if (world.field_72995_K) {
            ParticleBuilder.create(ParticleBuilder.Type.BEAM).entity(caster).clr(0.2f, 0.6f, 1.0f).pos(caster != null ? origin.func_178788_d(caster.func_174791_d()) : origin).target(target).spawn(world);
            if (ticksInUse % 3 == 0) {
                ParticleBuilder.create(ParticleBuilder.Type.LIGHTNING).entity(caster).pos(caster != null ? origin.func_178788_d(caster.func_174791_d()) : origin).target(target).spawn(world);
            }
            for (int i = 0; i < 5; ++i) {
                ParticleBuilder.create(ParticleBuilder.Type.SPARK, target).spawn(world);
            }
        }
    }
}

