/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.tileentity.TileEntityTimer;
import electroblob.wizardry.util.RayTracer;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class Light
extends Spell {
    public Light() {
        super("light", EnumAction.NONE, false);
        this.addProperties("range", "duration");
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        double range = this.getProperty("range").floatValue() * modifiers.get(WizardryItems.range_upgrade);
        RayTraceResult rayTrace = RayTracer.standardBlockRayTrace(world, (EntityLivingBase)caster, range, false);
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = rayTrace.func_178782_a().func_177972_a(rayTrace.field_178784_b);
            if (world.func_175623_d(pos)) {
                if (!world.field_72995_K) {
                    world.func_175656_a(pos, WizardryBlocks.magic_light.func_176223_P());
                    if (world.func_175625_s(pos) instanceof TileEntityTimer) {
                        int lifetime = ItemArtefact.isArtefactActive(caster, WizardryItems.charm_light) ? -1 : (int)(this.getProperty("duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade));
                        ((TileEntityTimer)world.func_175625_s(pos)).setLifetime(lifetime);
                    }
                }
                caster.func_184609_a(hand);
                this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
                return true;
            }
        } else {
            int z;
            int y;
            int x = (int)(Math.floor(caster.field_70165_t) + caster.func_70040_Z().field_72450_a * range);
            BlockPos pos = new BlockPos(x, y = (int)(Math.floor(caster.field_70163_u) + (double)caster.eyeHeight + caster.func_70040_Z().field_72448_b * range), z = (int)(Math.floor(caster.field_70161_v) + caster.func_70040_Z().field_72449_c * range));
            if (world.func_175623_d(pos)) {
                if (!world.field_72995_K) {
                    world.func_175656_a(pos, WizardryBlocks.magic_light.func_176223_P());
                    if (world.func_175625_s(pos) instanceof TileEntityTimer) {
                        int lifetime = ItemArtefact.isArtefactActive(caster, WizardryItems.charm_light) ? -1 : (int)(this.getProperty("duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade));
                        ((TileEntityTimer)world.func_175625_s(pos)).setLifetime(lifetime);
                    }
                }
                caster.func_184609_a(hand);
                this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
                return true;
            }
        }
        return false;
    }
}

