/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellAreaEffect;
import electroblob.wizardry.spell.SpellBuff;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class ForestsCurse
extends SpellAreaEffect {
    public ForestsCurse() {
        super("forests_curse", EnumAction.BOW);
        this.soundValues(1.0f, 1.1f, 0.2f);
        this.addProperties("damage", "effect_duration", "effect_strength");
    }

    @Override
    protected void affectEntity(World world, EntityLivingBase caster, EntityLivingBase target, SpellModifiers modifiers) {
        if (!MagicDamage.isEntityImmune(MagicDamage.DamageType.POISON, (Entity)target) && WizardryUtilities.isLiving((Entity)target)) {
            target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.POISON), this.getProperty("damage").floatValue() * modifiers.get("potency"));
            int bonusAmplifier = SpellBuff.getStandardBonusAmplifier(modifiers.get("potency"));
            int duration = (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade));
            int amplifier = (int)(this.getProperty("effect_strength").floatValue() + (float)bonusAmplifier);
            target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, duration, amplifier));
            target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, duration, amplifier));
            target.func_70690_d(new PotionEffect(MobEffects.field_76437_t, duration, amplifier));
        }
    }

    @Override
    protected void spawnParticle(World world, double x, double y, double z) {
        float brightness = world.field_73012_v.nextFloat() / 4.0f;
        ParticleBuilder.create(ParticleBuilder.Type.DARK_MAGIC).pos(x, y += 2.0, z).vel(0.0, -0.2, 0.0).clr(0.05f + brightness, 0.2f + brightness, 0.0f).spawn(world);
        brightness = world.field_73012_v.nextFloat() / 4.0f;
        ParticleBuilder.create(ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, -0.05, 0.0).time(50).clr(0.1f + brightness, 0.2f + brightness, 0.0f).spawn(world);
        ParticleBuilder.create(ParticleBuilder.Type.LEAF).pos(x, y, z).vel(0.0, -0.01, 0.0).time(40 + world.field_73012_v.nextInt(12)).spawn(world);
    }
}

