/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.entity.construct.EntityBubble;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Entrapment
extends SpellRay {
    public static final String DAMAGE_INTERVAL = "damage_interval";

    public Entrapment() {
        super("entrapment", false, EnumAction.NONE);
        this.soundValues(1.0f, 0.85f, 0.3f);
        this.addProperties("effect_duration", DAMAGE_INTERVAL);
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (WizardryUtilities.isLiving(target) && !world.field_72995_K) {
            target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.MAGIC), 1.0f);
            EntityBubble bubble = new EntityBubble(world);
            bubble.func_70107_b(target.field_70165_t, target.field_70163_u, target.field_70161_v);
            bubble.setCaster(caster);
            bubble.lifetime = (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade));
            bubble.isDarkOrb = true;
            bubble.damageMultiplier = modifiers.get("potency");
            world.func_72838_d((Entity)bubble);
            target.func_184220_m((Entity)bubble);
        }
        return true;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    @Override
    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        world.func_175688_a(EnumParticleTypes.PORTAL, x, y - 0.5, z, 0.0, 0.0, 0.0, new int[0]);
        ParticleBuilder.create(ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(0.1f, 0.0f, 0.0f).spawn(world);
    }
}

