/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemScroll;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class RandomSpell
extends LootFunction {
    private final List<Spell> spells;
    private final boolean ignoreWeighting;
    private final float undiscoveredBias;
    private final List<Tier> tiers;
    private final List<Element> elements;

    protected RandomSpell(LootCondition[] conditions, List<Spell> spells, boolean ignoreWeighting, float undiscoveredBias, List<Tier> tiers, List<Element> elements) {
        super(conditions);
        this.spells = spells;
        this.ignoreWeighting = ignoreWeighting;
        this.undiscoveredBias = undiscoveredBias;
        this.tiers = tiers;
        this.elements = elements;
    }

    public ItemStack func_186553_a(ItemStack stack, Random random, LootContext context) {
        EntityPlayer player;
        SpellProperties.Context spellContext;
        Spell spell;
        if (!(stack.func_77973_b() instanceof ItemSpellBook) && !(stack.func_77973_b() instanceof ItemScroll)) {
            Wizardry.logger.warn("Applying the random_spell loot function to an item that isn't a spell book or scroll.");
        }
        if ((spell = this.pickRandomSpell(stack, random, spellContext = context.func_186493_a() == null ? SpellProperties.Context.TREASURE : SpellProperties.Context.LOOTING, player = (EntityPlayer)context.func_186495_b())) == Spells.none) {
            Wizardry.logger.warn("Tried to apply the random_spell loot function to an item, but no enabled spells matched the criteria specified. Substituting placeholder (metadata 0) item.");
        }
        stack.func_77964_b(spell.metadata());
        return stack;
    }

    private Spell pickRandomSpell(ItemStack stack, Random random, SpellProperties.Context spellContext, EntityPlayer player) {
        List<Spell> possibleSpells = Spell.getSpells(s -> !(!s.isEnabled(spellContext) || !s.applicableForItem(stack.func_77973_b()) || this.tiers != null && !this.tiers.contains((Object)s.getTier()) || this.elements != null && !this.elements.contains((Object)s.getElement())));
        if (this.spells != null && !this.spells.isEmpty()) {
            possibleSpells.retainAll(this.spells);
        }
        if (stack.func_77973_b() instanceof ItemScroll) {
            possibleSpells.removeIf(s -> !s.isEnabled(SpellProperties.Context.SCROLL));
        }
        if (stack.func_77973_b() instanceof ItemSpellBook) {
            possibleSpells.removeIf(s -> !s.isEnabled(SpellProperties.Context.BOOK));
        }
        ArrayList<Tier> possibleTiers = new ArrayList<Tier>();
        if (this.tiers == null || this.tiers.isEmpty()) {
            possibleTiers.addAll(Arrays.asList(Tier.values()));
        } else {
            possibleTiers.addAll(this.tiers);
        }
        possibleTiers.removeIf(t -> possibleSpells.stream().noneMatch(s -> s.getTier() == t));
        if (possibleTiers.isEmpty()) {
            return Spells.none;
        }
        Tier tier = this.ignoreWeighting ? (Tier)((Object)possibleTiers.get(random.nextInt(possibleTiers.size()))) : Tier.getWeightedRandomTier(random, possibleTiers.toArray(new Tier[0]));
        possibleSpells.removeIf(s -> s.getTier() != tier);
        if (possibleSpells.isEmpty()) {
            return Spells.none;
        }
        ArrayList<Element> possibleElements = new ArrayList<Element>();
        if (this.elements == null || this.elements.isEmpty()) {
            possibleElements.addAll(Arrays.asList(Element.values()));
        } else {
            possibleElements.addAll(this.elements);
        }
        possibleElements.removeIf(e -> possibleSpells.stream().noneMatch(s -> s.getElement() == e));
        if (possibleElements.isEmpty()) {
            return Spells.none;
        }
        Element element = (Element)((Object)possibleElements.get(random.nextInt(possibleElements.size())));
        possibleSpells.removeIf(s -> s.getElement() != element);
        if (possibleSpells.isEmpty()) {
            return Spells.none;
        }
        if (this.undiscoveredBias > 0.0f && player != null) {
            WizardData data = WizardData.get(player);
            int discoveredCount = (int)possibleSpells.stream().filter(data::hasSpellBeenDiscovered).count();
            if (discoveredCount > 0 && discoveredCount < possibleSpells.size()) {
                boolean keepDiscovered = random.nextFloat() < 0.5f + 0.5f * this.undiscoveredBias;
                possibleSpells.removeIf(s -> keepDiscovered != data.hasSpellBeenDiscovered((Spell)s));
            }
        }
        return possibleSpells.get(random.nextInt(possibleSpells.size()));
    }

    public static class Serializer
    extends LootFunction.Serializer<RandomSpell> {
        public Serializer() {
            super(new ResourceLocation("ebwizardry", "random_spell"), RandomSpell.class);
        }

        public void serialize(JsonObject object, RandomSpell function, JsonSerializationContext serializationContext) {
            JsonArray jsonarray;
            if (function.spells != null && !function.spells.isEmpty()) {
                jsonarray = new JsonArray();
                for (Spell spell : function.spells) {
                    jsonarray.add((JsonElement)new JsonPrimitive(spell.getRegistryName().toString()));
                }
                object.add("spells", (JsonElement)jsonarray);
            }
            object.addProperty("ignore_weighting", Boolean.valueOf(function.ignoreWeighting));
            object.addProperty("undiscovered_bias", (Number)Float.valueOf(function.undiscoveredBias));
            if (function.tiers != null && !function.tiers.isEmpty()) {
                jsonarray = new JsonArray();
                for (Tier tier : function.tiers) {
                    jsonarray.add((JsonElement)new JsonPrimitive(tier.getUnlocalisedName()));
                }
                object.add("tiers", (JsonElement)jsonarray);
            }
            if (function.elements != null && !function.elements.isEmpty()) {
                jsonarray = new JsonArray();
                for (Element element : function.elements) {
                    jsonarray.add((JsonElement)new JsonPrimitive(element.func_176610_l()));
                }
                object.add("elements", (JsonElement)jsonarray);
            }
        }

        public RandomSpell deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditions) {
            String string;
            ArrayList<Spell> spells = null;
            ArrayList<Tier> tiers = null;
            ArrayList<Element> elements = null;
            if (object.has("spells")) {
                spells = new ArrayList<Spell>();
                for (JsonElement element : JsonUtils.func_151213_a((JsonObject)object, (String)"spells", (JsonArray)new JsonArray())) {
                    String string2 = JsonUtils.func_151206_a((JsonElement)element, (String)"spell");
                    Spell spell = Spell.get(string2);
                    if (spell == null) {
                        throw new JsonSyntaxException("Unknown spell '" + string2 + "'");
                    }
                    spells.add(spell);
                }
            }
            boolean ignoreWeighting = JsonUtils.func_151209_a((JsonObject)object, (String)"ignore_weighting", (boolean)false);
            float undiscoveredBias = JsonUtils.func_151221_a((JsonObject)object, (String)"undiscovered_bias", (float)0.0f);
            if (object.has("tiers")) {
                tiers = new ArrayList<Tier>();
                for (JsonElement element : JsonUtils.func_151213_a((JsonObject)object, (String)"tiers", (JsonArray)new JsonArray())) {
                    string = JsonUtils.func_151206_a((JsonElement)element, (String)"tier");
                    try {
                        tiers.add(Tier.fromName(string));
                    }
                    catch (IllegalArgumentException e) {
                        throw new JsonSyntaxException("Unknown tier '" + string + "'");
                    }
                }
            }
            if (object.has("elements")) {
                elements = new ArrayList<Element>();
                for (JsonElement jelement : JsonUtils.func_151213_a((JsonObject)object, (String)"elements", (JsonArray)new JsonArray())) {
                    string = JsonUtils.func_151206_a((JsonElement)jelement, (String)"element");
                    try {
                        elements.add(Element.fromName(string));
                    }
                    catch (IllegalArgumentException e) {
                        throw new JsonSyntaxException("Unknown element '" + string + "'");
                    }
                }
            }
            return new RandomSpell(conditions, spells, ignoreWeighting, undiscoveredBias, tiers, elements);
        }
    }
}

