/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.projectile;

import electroblob.wizardry.entity.projectile.EntityBomb;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityFirebomb
extends EntityBomb {
    public EntityFirebomb(World world) {
        super(world);
    }

    @Override
    public int getLifetime() {
        return -1;
    }

    protected void func_70184_a(RayTraceResult rayTrace) {
        Entity entityHit = rayTrace.field_72308_g;
        if (entityHit != null) {
            float damage = Spells.firebomb.getProperty("direct_damage").floatValue() * this.damageMultiplier;
            entityHit.func_70097_a(MagicDamage.causeIndirectMagicDamage((Entity)this, (Entity)this.func_85052_h(), MagicDamage.DamageType.FIRE).func_76349_b(), damage);
            if (!MagicDamage.isEntityImmune(MagicDamage.DamageType.FIRE, entityHit)) {
                entityHit.func_70015_d(Spells.firebomb.getProperty("burn_duration").intValue());
            }
        }
        if (this.field_70170_p.field_72995_K) {
            ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(this.func_174791_d()).scale(5.0f * this.blastMultiplier).clr(1.0f, 0.6f, 0.0f).spawn(this.field_70170_p);
            int i = 0;
            while ((float)i < 60.0f * this.blastMultiplier) {
                ParticleBuilder.create(ParticleBuilder.Type.MAGIC_FIRE, this.field_70146_Z, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f * this.blastMultiplier, false).time(10 + this.field_70146_Z.nextInt(4)).scale(2.0f + this.field_70146_Z.nextFloat()).spawn(this.field_70170_p);
                ParticleBuilder.create(ParticleBuilder.Type.DARK_MAGIC, this.field_70146_Z, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f * this.blastMultiplier, false).clr(1.0f, 0.2f + this.field_70146_Z.nextFloat() * 0.4f, 0.0f).spawn(this.field_70170_p);
                ++i;
            }
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_184185_a(WizardrySounds.ENTITY_FIREBOMB_SMASH, 1.5f, this.field_70146_Z.nextFloat() * 0.4f + 0.6f);
            this.func_184185_a(WizardrySounds.ENTITY_FIREBOMB_FIRE, 1.0f, 1.0f);
            double range = Spells.firebomb.getProperty("blast_radius").floatValue() * this.blastMultiplier;
            List<EntityLivingBase> targets = WizardryUtilities.getEntitiesWithinRadius(range, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p);
            for (EntityLivingBase target : targets) {
                if (target == entityHit || target == this.func_85052_h() || MagicDamage.isEntityImmune(MagicDamage.DamageType.FIRE, (Entity)target)) continue;
                target.func_70097_a(MagicDamage.causeIndirectMagicDamage((Entity)this, (Entity)this.func_85052_h(), MagicDamage.DamageType.FIRE), Spells.firebomb.getProperty("splash_damage").floatValue() * this.damageMultiplier);
                target.func_70015_d(Spells.firebomb.getProperty("burn_duration").intValue());
            }
            this.func_70106_y();
        }
    }
}

