/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.living;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.living.EntityBlazeMinion;
import electroblob.wizardry.entity.living.EntityLightningWraith;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.ArrayUtils;

@Mod.EventBusSubscriber
public class EntityIceWraith
extends EntityBlazeMinion {
    private int jumpTicks;

    public EntityIceWraith(World world) {
        super(world);
        this.field_70178_ae = false;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.field_75782_a.clear();
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIIceShardAttack(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    @Override
    protected void spawnParticleEffect() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 15; ++i) {
                float brightness = 0.5f + this.field_70146_Z.nextFloat() / 2.0f;
                ParticleBuilder.create(ParticleBuilder.Type.SPARKLE).pos(this.field_70165_t - 0.5 + this.field_70146_Z.nextDouble(), this.field_70163_u + (double)(this.field_70131_O / 2.0f) - 0.5 + this.field_70146_Z.nextDouble(), this.field_70161_v - 0.5 + this.field_70146_Z.nextDouble()).vel(0.0, 0.05f, 0.0).time(20 + this.field_70146_Z.nextInt(10)).clr(brightness, brightness + 0.1f, 1.0f).spawn(this.field_70170_p);
            }
        }
    }

    public void func_70636_d() {
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        if (this.field_70146_Z.nextInt(24) == 0) {
            this.func_184185_a(WizardrySounds.ENTITY_ICE_WRAITH_AMBIENT, 0.3f + this.field_70146_Z.nextFloat() / 4.0f, this.field_70146_Z.nextFloat() * 0.7f + 1.4f);
        }
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        this.livingBaseUpdate();
    }

    private void livingBaseUpdate() {
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        }
        if (this.field_70716_bi > 0 && !this.func_184186_bw()) {
            double d0 = this.field_70165_t + (this.field_184623_bh - this.field_70165_t) / (double)this.field_70716_bi;
            double d1 = this.field_70163_u + (this.field_184624_bi - this.field_70163_u) / (double)this.field_70716_bi;
            double d2 = this.field_70161_v + (this.field_184625_bj - this.field_70161_v) / (double)this.field_70716_bi;
            double d3 = MathHelper.func_76138_g((double)(this.field_184626_bk - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.field_70716_bi);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70709_bj - (double)this.field_70125_A) / (double)this.field_70716_bi);
            --this.field_70716_bi;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        } else if (!this.func_70613_aW()) {
            this.field_70159_w *= 0.98;
            this.field_70181_x *= 0.98;
            this.field_70179_y *= 0.98;
        }
        if (Math.abs(this.field_70159_w) < 0.003) {
            this.field_70159_w = 0.0;
        }
        if (Math.abs(this.field_70181_x) < 0.003) {
            this.field_70181_x = 0.0;
        }
        if (Math.abs(this.field_70179_y) < 0.003) {
            this.field_70179_y = 0.0;
        }
        this.field_70170_p.field_72984_F.func_76320_a("ai");
        if (this.func_70610_aX()) {
            this.field_70703_bu = false;
            this.field_70702_br = 0.0f;
            this.field_191988_bg = 0.0f;
            this.field_70704_bt = 0.0f;
        } else if (this.func_70613_aW()) {
            this.field_70170_p.field_72984_F.func_76320_a("newAi");
            this.func_70626_be();
            this.field_70170_p.field_72984_F.func_76319_b();
        }
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76320_a("jump");
        if (this.field_70703_bu) {
            if (this.func_70090_H()) {
                this.func_70629_bd();
            } else if (this.func_180799_ab()) {
                this.func_180466_bG();
            } else if (this.field_70122_E && this.jumpTicks == 0) {
                this.func_70664_aZ();
                this.jumpTicks = 10;
            }
        } else {
            this.jumpTicks = 0;
        }
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76320_a("travel");
        this.field_70702_br *= 0.98f;
        this.field_191988_bg *= 0.98f;
        this.field_70704_bt *= 0.9f;
        this.func_191986_a(this.field_70702_br, this.field_70701_bs, this.field_191988_bg);
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76320_a("push");
        this.func_85033_bc();
        this.field_70170_p.field_72984_F.func_76319_b();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76369_e && (this.func_70086_ai() > 0 || this.func_70644_a(MobEffects.field_76427_o))) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70027_ad() {
        return this.func_70083_f(0);
    }

    @Override
    public boolean func_70601_bi() {
        return super.func_70601_bi() && this.func_70814_o();
    }

    @SubscribeEvent
    public static void onCheckSpawnEvent(LivingSpawnEvent.CheckSpawn event) {
        if (event.getEntityLiving() instanceof EntityLightningWraith && !event.isSpawner() && !ArrayUtils.contains((int[])Wizardry.settings.mobSpawnDimensions, (int)event.getWorld().field_73011_w.getDimension())) {
            event.setResult(Event.Result.DENY);
        }
    }

    static class AIIceShardAttack
    extends EntityAIBase {
        private final EntityBlaze blaze;
        private int attackStep;
        private int attackTime;

        public AIIceShardAttack(EntityBlaze blazeIn) {
            this.blaze = blazeIn;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.blaze.func_70638_az();
            return entitylivingbase != null && entitylivingbase.func_70089_S();
        }

        public void func_75249_e() {
            this.attackStep = 0;
        }

        public void func_75251_c() {
            this.blaze.func_70844_e(false);
        }

        public void func_75246_d() {
            --this.attackTime;
            EntityLivingBase entitylivingbase = this.blaze.func_70638_az();
            if (entitylivingbase == null) {
                return;
            }
            double d0 = this.blaze.func_70068_e((Entity)entitylivingbase);
            if (d0 < 4.0) {
                if (this.attackTime <= 0) {
                    this.attackTime = 20;
                    this.blaze.func_70652_k((Entity)entitylivingbase);
                }
                this.blaze.func_70605_aq().func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, 1.0);
            } else if (d0 < 256.0) {
                if (this.attackTime <= 0) {
                    ++this.attackStep;
                    if (this.attackStep == 1) {
                        this.attackTime = 60;
                        this.blaze.func_70844_e(true);
                    } else if (this.attackStep <= 4) {
                        this.attackTime = 6;
                    } else {
                        this.attackTime = 100;
                        this.attackStep = 0;
                        this.blaze.func_70844_e(false);
                    }
                    if (this.attackStep > 1) {
                        Spells.ice_shard.cast(this.blaze.field_70170_p, (EntityLiving)this.blaze, EnumHand.MAIN_HAND, 0, entitylivingbase, new SpellModifiers());
                    }
                }
                this.blaze.func_70671_ap().func_75651_a((Entity)entitylivingbase, 10.0f, 10.0f);
            } else {
                this.blaze.func_70661_as().func_75499_g();
                this.blaze.func_70605_aq().func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, 1.0);
            }
            super.func_75246_d();
        }
    }
}

