/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.living;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.Village;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityIceGiant
extends EntityIronGolem
implements ISummonedCreature {
    private int lifetime = -1;
    private UUID casterUUID;

    @Override
    public int getLifetime() {
        return this.lifetime;
    }

    @Override
    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    @Override
    public UUID func_184753_b() {
        return this.casterUUID;
    }

    @Override
    public void setOwnerId(UUID uuid) {
        this.casterUUID = uuid;
    }

    public EntityIceGiant(World world) {
        super(world);
        this.func_70105_a(1.4f, 2.9f);
        this.field_70728_aV = 0;
    }

    protected void func_184651_r() {
        this.func_70661_as().func_189566_q().func_186316_c(false);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.9, 32.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, false, true, this.getTargetSelector()));
    }

    protected void func_70619_bc() {
    }

    public Village func_70852_n() {
        return null;
    }

    public int func_70853_p() {
        return 0;
    }

    public void func_70604_c(EntityLivingBase entity) {
        if (this.shouldRevengeTarget(entity)) {
            super.func_70604_c(entity);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateDelegate();
    }

    @Override
    public void onSpawn() {
        this.spawnParticleEffect();
    }

    @Override
    public void onDespawn() {
        this.func_184185_a(WizardrySounds.ENTITY_ICE_GIANT_DESPAWN, 1.0f, 1.0f);
        this.spawnParticleEffect();
    }

    private void spawnParticleEffect() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 30; ++i) {
                float brightness = 0.5f + this.field_70146_Z.nextFloat() / 2.0f;
                ParticleBuilder.create(ParticleBuilder.Type.SPARKLE, (Entity)this).vel(0.0, -0.02, 0.0).time(12 + this.field_70146_Z.nextInt(8)).clr(brightness, brightness + 0.1f, 1.0f).spawn(this.field_70170_p);
            }
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            ParticleBuilder.create(ParticleBuilder.Type.SNOW, (Entity)this).spawn(this.field_70170_p);
        }
    }

    @Override
    public void onSuccessfulAttack(EntityLivingBase target) {
        target.field_70181_x += 0.2;
        target.field_70159_w += this.func_70040_Z().field_72450_a * 0.2;
        target.field_70179_y += this.func_70040_Z().field_72449_c * 0.2;
        target.func_70690_d(new PotionEffect(WizardryPotions.frost, 300, 0));
        this.func_174815_a((EntityLivingBase)this, (Entity)target);
        this.func_184185_a(WizardrySounds.ENTITY_ICE_GIANT_ATTACK, 1.0f, 1.0f);
    }

    @Override
    public boolean hasParticleEffect() {
        return false;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        return this.interactDelegate(player, hand) || super.func_184645_a(player, hand);
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        this.writeNBTDelegate(nbttagcompound);
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.readNBTDelegate(nbttagcompound);
    }

    protected int func_70693_a(EntityPlayer player) {
        return 0;
    }

    protected boolean func_146066_aG() {
        return false;
    }

    protected Item func_146068_u() {
        return null;
    }

    protected ResourceLocation func_184647_J() {
        return null;
    }

    public boolean func_98052_bS() {
        return false;
    }

    protected boolean func_70692_ba() {
        return this.getCaster() == null && this.func_184753_b() == null;
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> entityType) {
        return !EntityFlying.class.isAssignableFrom(entityType);
    }

    public ITextComponent func_145748_c_() {
        if (this.getCaster() != null) {
            return new TextComponentTranslation("entity.ebwizardry:summonedcreature.nameplate", new Object[]{this.getCaster().func_70005_c_(), new TextComponentTranslation("entity." + this.func_70022_Q() + ".name", new Object[0])});
        }
        return super.func_145748_c_();
    }

    public boolean func_145818_k_() {
        return Wizardry.settings.summonedCreatureNames && this.getCaster() != null;
    }
}

