/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.model;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.block.BlockCrystal;
import electroblob.wizardry.block.BlockPedestal;
import electroblob.wizardry.block.BlockRunestone;
import electroblob.wizardry.client.model.BakedModelGlowingOverlay;
import electroblob.wizardry.item.IMultiTexturedItem;
import electroblob.wizardry.item.ItemBlockMultiTexturedElemental;
import electroblob.wizardry.item.ItemCrystal;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public final class WizardryModels {
    private WizardryModels() {
    }

    @SubscribeEvent
    public static void register(ModelRegistryEvent event) {
        WizardryModels.registerItemModel(Item.func_150898_a((Block)WizardryBlocks.arcane_workbench));
        WizardryModels.registerItemModel(Item.func_150898_a((Block)WizardryBlocks.crystal_ore));
        WizardryModels.registerItemModel(Item.func_150898_a((Block)WizardryBlocks.crystal_flower));
        WizardryModels.registerItemModel(Item.func_150898_a((Block)WizardryBlocks.transportation_stone));
        ModelLoader.setCustomStateMapper((Block)WizardryBlocks.crystal_block, (IStateMapper)new StateMap.Builder().func_178440_a(BlockCrystal.ELEMENT).func_178439_a("_crystal_block").func_178441_a());
        ItemBlockMultiTexturedElemental crystalBlockItem = (ItemBlockMultiTexturedElemental)Item.func_150898_a((Block)WizardryBlocks.crystal_block);
        WizardryModels.registerMultiTexturedModel(crystalBlockItem);
        ModelLoader.setCustomStateMapper((Block)WizardryBlocks.runestone, (IStateMapper)new StateMap.Builder().func_178440_a(BlockRunestone.ELEMENT).func_178439_a("_runestone").func_178441_a());
        ItemBlockMultiTexturedElemental runestoneItem = (ItemBlockMultiTexturedElemental)Item.func_150898_a((Block)WizardryBlocks.runestone);
        WizardryModels.registerMultiTexturedModel(runestoneItem);
        ModelLoader.setCustomStateMapper((Block)WizardryBlocks.runestone_pedestal, (IStateMapper)new StateMap.Builder().func_178440_a(BlockPedestal.ELEMENT).func_178442_a(new IProperty[]{BlockPedestal.NATURAL}).func_178439_a("_runestone_pedestal").func_178441_a());
        ItemBlockMultiTexturedElemental pedestalItem = (ItemBlockMultiTexturedElemental)Item.func_150898_a((Block)WizardryBlocks.runestone_pedestal);
        WizardryModels.registerMultiTexturedModel(pedestalItem);
        WizardryModels.registerMultiTexturedModel((ItemCrystal)WizardryItems.magic_crystal);
        WizardryModels.registerWandModel(WizardryItems.magic_wand);
        WizardryModels.registerWandModel(WizardryItems.apprentice_wand);
        WizardryModels.registerWandModel(WizardryItems.advanced_wand);
        WizardryModels.registerWandModel(WizardryItems.master_wand);
        WizardryModels.registerItemModel(WizardryItems.spell_book);
        WizardryModels.registerItemModel(WizardryItems.spell_book, Short.MAX_VALUE, "normal");
        WizardryModels.registerItemModel(WizardryItems.arcane_tome);
        WizardryModels.registerItemModel(WizardryItems.wizard_handbook);
        WizardryModels.registerWandModel(WizardryItems.novice_fire_wand);
        WizardryModels.registerWandModel(WizardryItems.novice_ice_wand);
        WizardryModels.registerWandModel(WizardryItems.novice_lightning_wand);
        WizardryModels.registerWandModel(WizardryItems.novice_necromancy_wand);
        WizardryModels.registerWandModel(WizardryItems.novice_earth_wand);
        WizardryModels.registerWandModel(WizardryItems.novice_sorcery_wand);
        WizardryModels.registerWandModel(WizardryItems.novice_healing_wand);
        WizardryModels.registerWandModel(WizardryItems.apprentice_fire_wand);
        WizardryModels.registerWandModel(WizardryItems.apprentice_ice_wand);
        WizardryModels.registerWandModel(WizardryItems.apprentice_lightning_wand);
        WizardryModels.registerWandModel(WizardryItems.apprentice_necromancy_wand);
        WizardryModels.registerWandModel(WizardryItems.apprentice_earth_wand);
        WizardryModels.registerWandModel(WizardryItems.apprentice_sorcery_wand);
        WizardryModels.registerWandModel(WizardryItems.apprentice_healing_wand);
        WizardryModels.registerWandModel(WizardryItems.advanced_fire_wand);
        WizardryModels.registerWandModel(WizardryItems.advanced_ice_wand);
        WizardryModels.registerWandModel(WizardryItems.advanced_lightning_wand);
        WizardryModels.registerWandModel(WizardryItems.advanced_necromancy_wand);
        WizardryModels.registerWandModel(WizardryItems.advanced_earth_wand);
        WizardryModels.registerWandModel(WizardryItems.advanced_sorcery_wand);
        WizardryModels.registerWandModel(WizardryItems.advanced_healing_wand);
        WizardryModels.registerWandModel(WizardryItems.master_fire_wand);
        WizardryModels.registerWandModel(WizardryItems.master_ice_wand);
        WizardryModels.registerWandModel(WizardryItems.master_lightning_wand);
        WizardryModels.registerWandModel(WizardryItems.master_necromancy_wand);
        WizardryModels.registerWandModel(WizardryItems.master_earth_wand);
        WizardryModels.registerWandModel(WizardryItems.master_sorcery_wand);
        WizardryModels.registerWandModel(WizardryItems.master_healing_wand);
        WizardryModels.registerItemModel(WizardryItems.spectral_sword);
        WizardryModels.registerItemModel(WizardryItems.spectral_pickaxe);
        WizardryModels.registerItemModel(WizardryItems.spectral_bow);
        WizardryModels.registerItemModel(WizardryItems.small_mana_flask);
        WizardryModels.registerItemModel(WizardryItems.medium_mana_flask);
        WizardryModels.registerItemModel(WizardryItems.large_mana_flask);
        WizardryModels.registerItemModel(WizardryItems.crystal_shard);
        WizardryModels.registerItemModel(WizardryItems.grand_crystal);
        WizardryModels.registerItemModel(WizardryItems.astral_diamond);
        WizardryModels.registerItemModel(WizardryItems.purifying_elixir);
        WizardryModels.registerItemModel(WizardryItems.storage_upgrade);
        WizardryModels.registerItemModel(WizardryItems.siphon_upgrade);
        WizardryModels.registerItemModel(WizardryItems.condenser_upgrade);
        WizardryModels.registerItemModel(WizardryItems.range_upgrade);
        WizardryModels.registerItemModel(WizardryItems.duration_upgrade);
        WizardryModels.registerItemModel(WizardryItems.cooldown_upgrade);
        WizardryModels.registerItemModel(WizardryItems.blast_upgrade);
        WizardryModels.registerItemModel(WizardryItems.attunement_upgrade);
        WizardryModels.registerItemModel(WizardryItems.melee_upgrade);
        WizardryModels.registerItemModel(WizardryItems.flaming_axe);
        WizardryModels.registerItemModel(WizardryItems.frost_axe);
        WizardryModels.registerItemModel(WizardryItems.firebomb);
        WizardryModels.registerItemModel(WizardryItems.poison_bomb);
        WizardryModels.registerItemModel(WizardryItems.smoke_bomb);
        WizardryModels.registerItemModel(WizardryItems.spark_bomb);
        WizardryModels.registerItemModel(WizardryItems.blank_scroll);
        WizardryModels.registerItemModel(WizardryItems.scroll);
        WizardryModels.registerItemModel(WizardryItems.identification_scroll);
        WizardryModels.registerItemModel(WizardryItems.armour_upgrade);
        WizardryModels.registerItemModel(WizardryItems.magic_silk);
        WizardryModels.registerItemModel(WizardryItems.wizard_hat);
        WizardryModels.registerItemModel(WizardryItems.wizard_robe);
        WizardryModels.registerItemModel(WizardryItems.wizard_leggings);
        WizardryModels.registerItemModel(WizardryItems.wizard_boots);
        WizardryModels.registerItemModel(WizardryItems.wizard_hat_fire);
        WizardryModels.registerItemModel(WizardryItems.wizard_robe_fire);
        WizardryModels.registerItemModel(WizardryItems.wizard_leggings_fire);
        WizardryModels.registerItemModel(WizardryItems.wizard_boots_fire);
        WizardryModels.registerItemModel(WizardryItems.wizard_hat_ice);
        WizardryModels.registerItemModel(WizardryItems.wizard_robe_ice);
        WizardryModels.registerItemModel(WizardryItems.wizard_leggings_ice);
        WizardryModels.registerItemModel(WizardryItems.wizard_boots_ice);
        WizardryModels.registerItemModel(WizardryItems.wizard_hat_lightning);
        WizardryModels.registerItemModel(WizardryItems.wizard_robe_lightning);
        WizardryModels.registerItemModel(WizardryItems.wizard_leggings_lightning);
        WizardryModels.registerItemModel(WizardryItems.wizard_boots_lightning);
        WizardryModels.registerItemModel(WizardryItems.wizard_hat_necromancy);
        WizardryModels.registerItemModel(WizardryItems.wizard_robe_necromancy);
        WizardryModels.registerItemModel(WizardryItems.wizard_leggings_necromancy);
        WizardryModels.registerItemModel(WizardryItems.wizard_boots_necromancy);
        WizardryModels.registerItemModel(WizardryItems.wizard_hat_earth);
        WizardryModels.registerItemModel(WizardryItems.wizard_robe_earth);
        WizardryModels.registerItemModel(WizardryItems.wizard_leggings_earth);
        WizardryModels.registerItemModel(WizardryItems.wizard_boots_earth);
        WizardryModels.registerItemModel(WizardryItems.wizard_hat_sorcery);
        WizardryModels.registerItemModel(WizardryItems.wizard_robe_sorcery);
        WizardryModels.registerItemModel(WizardryItems.wizard_leggings_sorcery);
        WizardryModels.registerItemModel(WizardryItems.wizard_boots_sorcery);
        WizardryModels.registerItemModel(WizardryItems.wizard_hat_healing);
        WizardryModels.registerItemModel(WizardryItems.wizard_robe_healing);
        WizardryModels.registerItemModel(WizardryItems.wizard_leggings_healing);
        WizardryModels.registerItemModel(WizardryItems.wizard_boots_healing);
        WizardryModels.registerItemModel(WizardryItems.spectral_helmet);
        WizardryModels.registerItemModel(WizardryItems.spectral_chestplate);
        WizardryModels.registerItemModel(WizardryItems.spectral_leggings);
        WizardryModels.registerItemModel(WizardryItems.spectral_boots);
        WizardryModels.registerItemModel(WizardryItems.lightning_hammer);
        WizardryModels.registerItemModel(WizardryItems.ring_condensing);
        WizardryModels.registerItemModel(WizardryItems.ring_siphoning);
        WizardryModels.registerItemModel(WizardryItems.ring_battlemage);
        WizardryModels.registerItemModel(WizardryItems.ring_combustion);
        WizardryModels.registerItemModel(WizardryItems.ring_fire_melee);
        WizardryModels.registerItemModel(WizardryItems.ring_fire_biome);
        WizardryModels.registerItemModel(WizardryItems.ring_disintegration);
        WizardryModels.registerItemModel(WizardryItems.ring_ice_melee);
        WizardryModels.registerItemModel(WizardryItems.ring_ice_biome);
        WizardryModels.registerItemModel(WizardryItems.ring_arcane_frost);
        WizardryModels.registerItemModel(WizardryItems.ring_shattering);
        WizardryModels.registerItemModel(WizardryItems.ring_lightning_melee);
        WizardryModels.registerItemModel(WizardryItems.ring_storm);
        WizardryModels.registerItemModel(WizardryItems.ring_seeking);
        WizardryModels.registerItemModel(WizardryItems.ring_hammer);
        WizardryModels.registerItemModel(WizardryItems.ring_soulbinding);
        WizardryModels.registerItemModel(WizardryItems.ring_leeching);
        WizardryModels.registerItemModel(WizardryItems.ring_necromancy_melee);
        WizardryModels.registerItemModel(WizardryItems.ring_mind_control);
        WizardryModels.registerItemModel(WizardryItems.ring_poison);
        WizardryModels.registerItemModel(WizardryItems.ring_earth_melee);
        WizardryModels.registerItemModel(WizardryItems.ring_earth_biome);
        WizardryModels.registerItemModel(WizardryItems.ring_full_moon);
        WizardryModels.registerItemModel(WizardryItems.ring_extraction);
        WizardryModels.registerItemModel(WizardryItems.ring_mana_return);
        WizardryModels.registerItemModel(WizardryItems.ring_blockwrangler);
        WizardryModels.registerItemModel(WizardryItems.ring_conjurer);
        WizardryModels.registerItemModel(WizardryItems.ring_defender);
        WizardryModels.registerItemModel(WizardryItems.ring_paladin);
        WizardryModels.registerItemModel(WizardryItems.ring_interdiction);
        WizardryModels.registerItemModel(WizardryItems.amulet_arcane_defence);
        WizardryModels.registerItemModel(WizardryItems.amulet_warding);
        WizardryModels.registerItemModel(WizardryItems.amulet_wisdom);
        WizardryModels.registerItemModel(WizardryItems.amulet_fire_protection);
        WizardryModels.registerItemModel(WizardryItems.amulet_fire_cloaking);
        WizardryModels.registerItemModel(WizardryItems.amulet_ice_immunity);
        WizardryModels.registerItemModel(WizardryItems.amulet_ice_protection);
        WizardryModels.registerItemModel(WizardryItems.amulet_potential);
        WizardryModels.registerItemModel(WizardryItems.amulet_channeling);
        WizardryModels.registerItemModel(WizardryItems.amulet_lich);
        WizardryModels.registerItemModel(WizardryItems.amulet_wither_immunity);
        WizardryModels.registerItemModel(WizardryItems.amulet_glide);
        WizardryModels.registerItemModel(WizardryItems.amulet_banishing);
        WizardryModels.registerItemModel(WizardryItems.amulet_anchoring);
        WizardryModels.registerItemModel(WizardryItems.amulet_recovery);
        WizardryModels.registerItemModel(WizardryItems.amulet_transience);
        WizardryModels.registerItemModel(WizardryItems.amulet_resurrection);
        WizardryModels.registerItemModel(WizardryItems.amulet_auto_shield);
        WizardryModels.registerItemModel(WizardryItems.charm_haggler);
        WizardryModels.registerItemModel(WizardryItems.charm_experience_tome);
        WizardryModels.registerItemModel(WizardryItems.charm_auto_smelt);
        WizardryModels.registerItemModel(WizardryItems.charm_lava_walking);
        WizardryModels.registerItemModel(WizardryItems.charm_storm);
        WizardryModels.registerItemModel(WizardryItems.charm_minion_health);
        WizardryModels.registerItemModel(WizardryItems.charm_minion_variants);
        WizardryModels.registerItemModel(WizardryItems.charm_flight);
        WizardryModels.registerItemModel(WizardryItems.charm_growth);
        WizardryModels.registerItemModel(WizardryItems.charm_abseiling);
        WizardryModels.registerItemModel(WizardryItems.charm_silk_touch);
        WizardryModels.registerItemModel(WizardryItems.charm_stop_time);
        WizardryModels.registerItemModel(WizardryItems.charm_light);
        WizardryModels.registerItemModel(WizardryItems.charm_transportation);
        WizardryModels.registerItemModel(WizardryItems.charm_feeding);
    }

    @SubscribeEvent
    public static void bake(ModelBakeEvent event) {
        for (ModelResourceLocation location : event.getModelRegistry().func_148742_b()) {
            IBakedModel original;
            if (!location.func_110624_b().equals("ebwizardry")) continue;
            if (location.func_110623_a().contains("runestone") || location.func_110623_a().contains("runestone_pedestal")) {
                original = (IBakedModel)event.getModelRegistry().func_82594_a((Object)location);
                event.getModelRegistry().func_82595_a((Object)location, (Object)new BakedModelGlowingOverlay(original, "overlay"));
                continue;
            }
            if (!location.func_110623_a().contains("spectral_block")) continue;
            original = (IBakedModel)event.getModelRegistry().func_82594_a((Object)location);
            event.getModelRegistry().func_82595_a((Object)location, (Object)new BakedModelGlowingOverlay(original, "spectral_block"));
        }
    }

    private static void registerItemModel(Item item) {
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(item.getRegistryName(), "inventory")});
        ModelLoader.setCustomMeshDefinition((Item)item, s -> new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    private static void registerWandModel(Item item) {
        if (Wizardry.tisTheSeason) {
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation("ebwizardry:festive_wand", "inventory")});
            ModelLoader.setCustomMeshDefinition((Item)item, s -> new ModelResourceLocation("ebwizardry:festive_wand", "inventory"));
        } else {
            WizardryModels.registerItemModel(item);
        }
    }

    private static <T extends Item> void registerMultiTexturedModel(T item) {
        if (item.func_77614_k()) {
            NonNullList items = NonNullList.func_191196_a();
            item.func_150895_a(item.func_77640_w(), items);
            for (ItemStack stack : items) {
                ModelLoader.setCustomModelResourceLocation(item, (int)stack.func_77960_j(), (ModelResourceLocation)new ModelResourceLocation(((IMultiTexturedItem)item).getModelName(stack), "inventory"));
            }
        }
    }

    private static void registerItemModel(Item item, int metadata, String variant) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), variant));
    }
}

