/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.config;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum SoundType {
    BACKGROUND("BACKGROUND"),
    SPOT("SPOT"),
    PERIODIC("PERIODIC");

    protected final String name;

    private SoundType(String name) {
        this.name = name;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public static SoundType getType(@Nullable String soundType) {
        if (soundType == null) {
            return BACKGROUND;
        }
        try {
            return SoundType.valueOf(soundType.toUpperCase());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return BACKGROUND;
        }
    }
}

