/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.client.gui.SoundConfigEntry;
import org.orecruncher.dsurround.client.sound.SoundEngine;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.dsurround.registry.sound.SoundRegistry;
import org.orecruncher.lib.ConfigProcessor;
import org.orecruncher.lib.gui.GuiConfigBase;

@SideOnly(value=Side.CLIENT)
public class DynSurroundConfigGui
extends GuiConfigBase {
    private final Configuration config = ModBase.config();
    private final ConfigElement soundElement;
    private final ConfigCategory soundCategory;

    public DynSurroundConfigGui(GuiScreen parentScreen) {
        super(parentScreen, new ArrayList(), "dsurround", false, false, "Dynamic Surroundings");
        this.titleLine2 = this.config.getConfigFile().getAbsolutePath();
        this.soundCategory = new ConfigCategory("Individual Sound Configuration").setLanguageKey("dsurround.cfg.individual");
        this.soundElement = new ConfigElement(this.soundCategory);
        this.generateSoundList(this.soundCategory);
        this.configElements.add(this.soundElement);
        this.addConfigCategory("general");
        this.addConfigCategory("player");
        this.addConfigCategory("rain");
        this.addConfigCategory("fog");
        this.addConfigCategory("aurora");
        this.addConfigCategory("effects");
        this.addConfigCategory("biomes");
        this.addConfigCategory("sound");
        this.addConfigCategory("profiles");
        this.addConfigCategory("speechbubbles");
        this.addConfigCategory("commands");
        this.addConfigCategory("asm");
        this.addConfigCategory("logging");
    }

    private void addConfigCategory(@Nonnull String category) {
        ConfigCategory cat = this.config.getCategory(category);
        this.configElements.add(new ConfigElement(cat));
    }

    protected void doFixups() {
        this.saveSoundList();
        this.config.save();
        ConfigProcessor.process((Configuration)this.config, ModOptions.class);
    }

    protected void saveSoundList() {
        ArrayList<String> soundVolumes = new ArrayList<String>();
        for (Map.Entry entry : this.soundCategory.entrySet()) {
            String parms = ((Property)entry.getValue()).getString();
            if (StringUtils.isEmpty((CharSequence)parms)) continue;
            soundVolumes.add((String)entry.getKey() + " " + parms);
        }
        String[] results = soundVolumes.toArray(new String[soundVolumes.size()]);
        this.config.getCategory("sound").get("Sound Settings").set(results);
    }

    protected void generateSoundList(ConfigCategory cat) {
        cat.setRequiresMcRestart(false);
        cat.setRequiresWorldRestart(false);
        ArrayList<String> sounds = new ArrayList<String>();
        for (Object resource : SoundEngine.instance().getSoundRegistry().func_148742_b()) {
            sounds.add(resource.toString());
        }
        Collections.sort(sounds);
        SoundRegistry registry = RegistryManager.SOUND;
        for (String sound2 : sounds) {
            float v;
            Property prop = new Property(sound2, "", Property.Type.STRING);
            prop.setDefaultValue("");
            prop.setRequiresMcRestart(false);
            prop.setRequiresWorldRestart(false);
            prop.setConfigEntryClass(SoundConfigEntry.class);
            StringBuilder builder = new StringBuilder();
            ResourceLocation res = new ResourceLocation(sound2);
            if (registry.isSoundBlocked(res)) {
                builder.append("block").append(' ');
            }
            if (registry.isSoundCulled(res)) {
                builder.append("cull").append(' ');
            }
            if ((v = registry.getVolumeScale(res)) != 1.0f) {
                builder.append((int)(v * 100.0f));
            }
            prop.setValue(builder.toString());
            cat.put(sound2, prop);
        }
    }
}

