/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.fx.particle.mote;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.fx.particle.mote.IIlluminatedMote;
import org.orecruncher.dsurround.client.fx.particle.mote.MoteAnimatedBase;
import org.orecruncher.lib.Color;

@SideOnly(value=Side.CLIENT)
public class MoteFireFly
extends MoteAnimatedBase
implements IIlluminatedMote {
    private static final int startColorRGB = Color.YELLOW.rgb();
    private static final int fadeColorRGB = Color.LGREEN.rgb();
    private static final float XZ_MOTION_DELTA = 0.2f;
    private static final float Y_MOTION_DELTA = 0.1f;
    private static final float ACCELERATION = 0.004f;

    public MoteFireFly(World world, double x, double y, double z) {
        super(160, 8, world, x, y, z, 0.0, 0.0, 0.0);
        this.motionX = RANDOM.nextGaussian() * (double)0.2f;
        this.motionZ = RANDOM.nextGaussian() * (double)0.2f;
        this.motionY = RANDOM.nextGaussian() * (double)0.1f;
        this.xAcceleration = RANDOM.nextGaussian() * (double)0.004f;
        this.yAcceleration = RANDOM.nextGaussian() / 2.0 * (double)0.004f;
        this.zAcceleration = RANDOM.nextGaussian() * (double)0.004f;
        this.gravity = 0.0;
        this.particleScale *= 0.01875f;
        this.maxAge = 120 + RANDOM.nextInt(12);
        this.setColor(startColorRGB);
        this.setColorFade(fadeColorRGB);
    }

    @Override
    public void update() {
        super.update();
        this.doRender = this.age < this.maxAge / 3 || (this.age + this.maxAge) / 3 % 2 == 0;
    }

    @Override
    public void renderParticle(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotX, float rotZ, float rotYZ, float rotXY, float rotXZ) {
        if (this.doRender) {
            super.renderParticle(buffer, entityIn, partialTicks, rotX, rotZ, rotYZ, rotXY, rotXZ);
        }
    }

    protected double lightedX(float partialTicks) {
        return (float)(this.prevX + (this.posX - this.prevX) * (double)partialTicks);
    }

    protected double lightedY(float partialTicks) {
        return (float)(this.prevY + (this.posY - this.prevY) * (double)partialTicks);
    }

    protected double lightedZ(float partialTicks) {
        return (float)(this.prevZ + (this.posZ - this.prevZ) * (double)partialTicks);
    }

    @Override
    public Vec3d getPosition() {
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        double x = this.lightedX(partialTicks);
        double y = this.lightedY(partialTicks);
        double z = this.lightedZ(partialTicks);
        return new Vec3d(x, y, z);
    }

    @Override
    public Color getColor() {
        return new Color(this.red, this.green, this.blue);
    }

    @Override
    public float getAlpha() {
        return (float)this.alpha * 0.005f;
    }

    @Override
    public float getRadius() {
        return 3.0f;
    }
}

