/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeonsengine.graph.mst;

import java.util.Random;

public final class StdRandom {
    private static Random random;
    private static long seed;

    private StdRandom() {
    }

    public static void setSeed(long s) {
        seed = s;
        random = new Random(seed);
    }

    public static long getSeed() {
        return seed;
    }

    public static double uniform() {
        return random.nextDouble();
    }

    public static int uniform(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Parameter N must be positive");
        }
        return random.nextInt(n);
    }

    @Deprecated
    public static double random() {
        return StdRandom.uniform();
    }

    public static int uniform(int a, int b) {
        if (b <= a) {
            throw new IllegalArgumentException("Invalid range");
        }
        if ((long)b - (long)a >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Invalid range");
        }
        return a + StdRandom.uniform(b - a);
    }

    public static double uniform(double a, double b) {
        if (!(a < b)) {
            throw new IllegalArgumentException("Invalid range");
        }
        return a + StdRandom.uniform() * (b - a);
    }

    public static boolean bernoulli(double p) {
        if (!(p >= 0.0) || !(p <= 1.0)) {
            throw new IllegalArgumentException("Probability must be between 0.0 and 1.0");
        }
        return StdRandom.uniform() < p;
    }

    public static boolean bernoulli() {
        return StdRandom.bernoulli(0.5);
    }

    public static double gaussian() {
        double y;
        double x;
        double r;
        while ((r = (x = StdRandom.uniform(-1.0, 1.0)) * x + (y = StdRandom.uniform(-1.0, 1.0)) * y) >= 1.0 || r == 0.0) {
        }
        return x * Math.sqrt(-2.0 * Math.log(r) / r);
    }

    public static double gaussian(double mu, double sigma) {
        return mu + sigma * StdRandom.gaussian();
    }

    public static int geometric(double p) {
        if (!(p >= 0.0) || !(p <= 1.0)) {
            throw new IllegalArgumentException("Probability must be between 0.0 and 1.0");
        }
        return (int)Math.ceil(Math.log(StdRandom.uniform()) / Math.log(1.0 - p));
    }

    public static int poisson(double lambda) {
        if (!(lambda > 0.0)) {
            throw new IllegalArgumentException("Parameter lambda must be positive");
        }
        if (Double.isInfinite(lambda)) {
            throw new IllegalArgumentException("Parameter lambda must not be infinite");
        }
        int k = 0;
        double p = 1.0;
        double expLambda = Math.exp(-lambda);
        do {
            ++k;
        } while ((p *= StdRandom.uniform()) >= expLambda);
        return k - 1;
    }

    public static double pareto() {
        return StdRandom.pareto(1.0);
    }

    public static double pareto(double alpha) {
        if (!(alpha > 0.0)) {
            throw new IllegalArgumentException("Shape parameter alpha must be positive");
        }
        return Math.pow(1.0 - StdRandom.uniform(), -1.0 / alpha) - 1.0;
    }

    public static double cauchy() {
        return Math.tan(Math.PI * (StdRandom.uniform() - 0.5));
    }

    public static int discrete(double[] probabilities) {
        if (probabilities == null) {
            throw new NullPointerException("argument array is null");
        }
        double EPSILON = 1.0E-14;
        double sum = 0.0;
        for (int i = 0; i < probabilities.length; ++i) {
            if (!(probabilities[i] >= 0.0)) {
                throw new IllegalArgumentException("array entry " + i + " must be nonnegative: " + probabilities[i]);
            }
            sum += probabilities[i];
        }
        if (sum > 1.0 + EPSILON || sum < 1.0 - EPSILON) {
            throw new IllegalArgumentException("sum of array entries does not approximately equal 1.0: " + sum);
        }
        block1: while (true) {
            double r = StdRandom.uniform();
            sum = 0.0;
            int i = 0;
            while (true) {
                if (i >= probabilities.length) continue block1;
                if ((sum += probabilities[i]) > r) {
                    return i;
                }
                ++i;
            }
            break;
        }
    }

    public static int discrete(int[] frequencies) {
        if (frequencies == null) {
            throw new NullPointerException("argument array is null");
        }
        long sum = 0L;
        for (int i = 0; i < frequencies.length; ++i) {
            if (frequencies[i] < 0) {
                throw new IllegalArgumentException("array entry " + i + " must be nonnegative: " + frequencies[i]);
            }
            sum += (long)frequencies[i];
        }
        if (sum == 0L) {
            throw new IllegalArgumentException("at least one array entry must be positive");
        }
        if (sum >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("sum of frequencies overflows an int");
        }
        double r = StdRandom.uniform((int)sum);
        sum = 0L;
        for (int i = 0; i < frequencies.length; ++i) {
            if (!((double)(sum += (long)frequencies[i]) > r)) continue;
            return i;
        }
        assert (false);
        return -1;
    }

    public static double exp(double lambda) {
        if (!(lambda > 0.0)) {
            throw new IllegalArgumentException("Rate lambda must be positive");
        }
        return -Math.log(1.0 - StdRandom.uniform()) / lambda;
    }

    public static void shuffle(Object[] a) {
        if (a == null) {
            throw new NullPointerException("argument array is null");
        }
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            int r = i + StdRandom.uniform(n - i);
            Object temp = a[i];
            a[i] = a[r];
            a[r] = temp;
        }
    }

    public static void shuffle(double[] a) {
        if (a == null) {
            throw new NullPointerException("argument array is null");
        }
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            int r = i + StdRandom.uniform(n - i);
            double temp = a[i];
            a[i] = a[r];
            a[r] = temp;
        }
    }

    public static void shuffle(int[] a) {
        if (a == null) {
            throw new NullPointerException("argument array is null");
        }
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            int r = i + StdRandom.uniform(n - i);
            int temp = a[i];
            a[i] = a[r];
            a[r] = temp;
        }
    }

    public static void shuffle(Object[] a, int lo, int hi) {
        if (a == null) {
            throw new NullPointerException("argument array is null");
        }
        if (lo < 0 || lo > hi || hi >= a.length) {
            throw new IndexOutOfBoundsException("Illegal subarray range");
        }
        for (int i = lo; i <= hi; ++i) {
            int r = i + StdRandom.uniform(hi - i + 1);
            Object temp = a[i];
            a[i] = a[r];
            a[r] = temp;
        }
    }

    public static void shuffle(double[] a, int lo, int hi) {
        if (a == null) {
            throw new NullPointerException("argument array is null");
        }
        if (lo < 0 || lo > hi || hi >= a.length) {
            throw new IndexOutOfBoundsException("Illegal subarray range");
        }
        for (int i = lo; i <= hi; ++i) {
            int r = i + StdRandom.uniform(hi - i + 1);
            double temp = a[i];
            a[i] = a[r];
            a[r] = temp;
        }
    }

    public static void shuffle(int[] a, int lo, int hi) {
        if (a == null) {
            throw new NullPointerException("argument array is null");
        }
        if (lo < 0 || lo > hi || hi >= a.length) {
            throw new IndexOutOfBoundsException("Illegal subarray range");
        }
        for (int i = lo; i <= hi; ++i) {
            int r = i + StdRandom.uniform(hi - i + 1);
            int temp = a[i];
            a[i] = a[r];
            a[r] = temp;
        }
    }

    static {
        seed = System.currentTimeMillis();
        random = new Random(seed);
    }
}

