/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeonsengine.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeonsengine.config.ChestConfig;
import com.someguyssoftware.dungeonsengine.config.DungeonConfig;
import com.someguyssoftware.dungeonsengine.config.IChestConfig;
import com.someguyssoftware.dungeonsengine.config.IDungeonConfig;
import com.someguyssoftware.dungeonsengine.config.ILevelConfig;
import com.someguyssoftware.dungeonsengine.config.LevelConfig;
import com.someguyssoftware.dungeonsengine.json.GenericDeserializer;
import com.someguyssoftware.gottschcore.json.JSMin;
import com.someguyssoftware.gottschcore.version.BuildVersion;
import com.someguyssoftware.gottschcore.version.VersionChecker;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DungeonConfigLoader {
    private static final String DUNGEON_CONFIGS_RESOURCE_DEFAULT_PATH = "/assets/dungeons2/dungeons/config/";
    private static final String DUNGEON_CONFIGS_RESOURCE_BUILTIN_PATH = "/assets/dungeons2/dungeons/config/builtin/";
    private static final String DEFAULT_CONFIG_FILE = "default.json";
    private static final String DUNGEON_CONFIGS_FS_PATH = "dungeons";
    private static final List<IDungeonConfig> EMPTY_CONFIG_LIST = new ArrayList<IDungeonConfig>(0);

    public static List<IDungeonConfig> loadAll() {
        ArrayList<IDungeonConfig> configs = new ArrayList<IDungeonConfig>(5);
        Path path = Paths.get("mods", "dungeons2", DUNGEON_CONFIGS_FS_PATH).toAbsolutePath();
        if (Files.notExists(path, new LinkOption[0])) {
            Dungeons2.log.debug("Unable to locate -> {}", (Object)path.toString());
            return EMPTY_CONFIG_LIST;
        }
        try {
            Files.walk(path, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(f -> {
                List<IDungeonConfig> dungeonConfig = null;
                try {
                    if (f.toString().endsWith(".json")) {
                        dungeonConfig = DungeonConfigLoader.load(f);
                        configs.addAll(dungeonConfig);
                    } else {
                        Dungeons2.log.debug("skipping invalid dungeon config json file -> {}", (Object)f.toString());
                    }
                }
                catch (Exception e) {
                    Dungeons2.log.error("Unable to load dungeon config json file -> " + f.toString(), (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            Dungeons2.log.error("Unable to read dungeon config file.", (Throwable)e);
        }
        return configs;
    }

    public static IDungeonConfig loadDefault() throws Exception {
        IDungeonConfig config = null;
        InputStream is = ((Object)((Object)Dungeons2.instance)).getClass().getResourceAsStream("/assets/dungeons2/dungeons/config/default.json");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JSMin minifier = new JSMin(is, (OutputStream)out);
        minifier.jsmin();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        InputStreamReader reader = new InputStreamReader(in);
        JsonReader jsonReader = new JsonReader((Reader)reader);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(ILevelConfig.class, (Object)new GenericDeserializer(LevelConfig.class));
        builder.registerTypeAdapter(IChestConfig.class, (Object)new GenericDeserializer(ChestConfig.class));
        Gson gson = builder.create();
        try {
            config = (IDungeonConfig)gson.fromJson(jsonReader, DungeonConfig.class);
        }
        catch (JsonIOException | JsonSyntaxException e) {
            throw new Exception("Unable to load default dungeon config.", e);
        }
        finally {
            try {
                jsonReader.close();
                in.close();
                out.close();
            }
            catch (IOException e) {
                Dungeons2.log.warn("Unable to close JSON Reader when reading built-in style sheet.");
            }
        }
        return config;
    }

    public static List<IDungeonConfig> loadFromResource(String resourcePath) throws Exception {
        InputStream is = ((Object)((Object)Dungeons2.instance)).getClass().getResourceAsStream(resourcePath);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JSMin minifier = new JSMin(is, (OutputStream)out);
        minifier.jsmin();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        InputStreamReader reader = new InputStreamReader(in);
        JsonReader jsonReader = new JsonReader((Reader)reader);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(IDungeonConfig.class, (Object)new GenericDeserializer(DungeonConfig.class));
        builder.registerTypeAdapter(ILevelConfig.class, (Object)new GenericDeserializer(LevelConfig.class));
        builder.registerTypeAdapter(IChestConfig.class, (Object)new GenericDeserializer(ChestConfig.class));
        Gson gson = builder.create();
        List configs = null;
        try {
            Type listType = new TypeToken<List<IDungeonConfig>>(){}.getType();
            configs = (List)gson.fromJson(jsonReader, listType);
        }
        catch (JsonIOException | JsonSyntaxException e) {
            throw new Exception("Unable to load default dungeon config.", e);
        }
        finally {
            try {
                jsonReader.close();
                in.close();
                out.close();
            }
            catch (IOException e) {
                Dungeons2.log.warn("Unable to close JSON Reader when reading built-in style sheet.");
            }
        }
        return configs;
    }

    public static List<IDungeonConfig> load(Path path) throws Exception {
        Dungeons2.log.debug("loading dungeon config from path -> {}", (Object)path.toString());
        FileInputStream is = new FileInputStream(path.toString());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JSMin minifier = new JSMin((InputStream)is, (OutputStream)out);
        minifier.jsmin();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        InputStreamReader reader = new InputStreamReader(in);
        JsonReader jsonReader = new JsonReader((Reader)reader);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(IDungeonConfig.class, (Object)new GenericDeserializer(DungeonConfig.class));
        builder.registerTypeAdapter(ILevelConfig.class, (Object)new GenericDeserializer(LevelConfig.class));
        builder.registerTypeAdapter(IChestConfig.class, (Object)new GenericDeserializer(ChestConfig.class));
        Gson gson = builder.create();
        List config = null;
        try {
            Type listType = new TypeToken<List<IDungeonConfig>>(){}.getType();
            config = (List)gson.fromJson(jsonReader, listType);
            for (IDungeonConfig c : config) {
                if (c.getBiomeWhiteList() != null) {
                    c.getBiomeWhiteList().replaceAll(String::toUpperCase);
                }
                if (c.getBiomeBlackList() != null) {
                    c.getBiomeBlackList().replaceAll(String::toUpperCase);
                }
                for (ILevelConfig lc : c.getLevelConfigs()) {
                    if (lc.getChestCategories() == null) continue;
                    lc.getChestCategories().replaceAll(String::toUpperCase);
                }
                Dungeons2.log.debug("loaded dungeon config -> {}", (Object)c);
            }
        }
        catch (JsonIOException | JsonSyntaxException e) {
            throw new Exception("Unable to load dungeon config.", e);
        }
        finally {
            try {
                jsonReader.close();
                ((InputStream)is).close();
                out.close();
            }
            catch (IOException e) {
                Dungeons2.log.warn("Unable to close JSON Reader when reading dungeon config.");
            }
        }
        return config;
    }

    private static void createFolder() {
        Path modsPath = Paths.get("mods", new String[0]);
        Path folder = Paths.get(modsPath.toString(), "dungeons2", DUNGEON_CONFIGS_FS_PATH).toAbsolutePath();
        if (Files.notExists(folder, new LinkOption[0])) {
            Dungeons2.log.debug("dungeons config folder \"{}\" will be created.", (Object)folder.toString());
            try {
                Files.createDirectories(folder, new FileAttribute[0]);
            }
            catch (IOException e) {
                Dungeons2.log.warn("Unable to create dungeons config folder \"{}\"", (Object)folder.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exposeDungeonsConfigs() {
        Stream<Path> walk = null;
        Path folder = null;
        FileSystem fs = DungeonConfigLoader.getResourceAsFileSystem(DUNGEON_CONFIGS_RESOURCE_BUILTIN_PATH);
        if (fs == null) {
            return;
        }
        try {
            Path resourceBasePath = fs.getPath(DUNGEON_CONFIGS_RESOURCE_BUILTIN_PATH, new String[0]);
            boolean isFirst = true;
            walk = Files.walk(resourceBasePath, 1, new FileVisitOption[0]);
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                Path resourceFilePath = (Path)it.next();
                if (isFirst) {
                    folder = Paths.get("mods", "dungeons2", DUNGEON_CONFIGS_FS_PATH).toAbsolutePath();
                } else {
                    Path dungeonConfigPath = Paths.get(folder.toString(), resourceFilePath.getFileName().toString()).toAbsolutePath();
                    Dungeons2.log.debug("dungeonConfigPath -> {}", (Object)dungeonConfigPath.toString());
                    if (!dungeonConfigPath.toString().endsWith(".json")) {
                        Dungeons2.log.debug("Skipping non-valid .json file -> {}", (Object)dungeonConfigPath.toString());
                        continue;
                    }
                    if (Files.exists(dungeonConfigPath, new LinkOption[0])) {
                        Dungeons2.log.debug("comparing config versions...");
                        List<IDungeonConfig> resourceConfigs = DungeonConfigLoader.loadFromResource(resourceFilePath.toAbsolutePath().toString());
                        List<IDungeonConfig> fsConfigs = DungeonConfigLoader.load(dungeonConfigPath);
                        Map fsConfigsMap = fsConfigs.stream().collect(Collectors.toMap(IDungeonConfig::getName, Function.identity()));
                        boolean isCurrent = true;
                        for (IDungeonConfig rc : resourceConfigs) {
                            if (fsConfigsMap.containsKey(rc.getName())) {
                                IDungeonConfig fsc = (IDungeonConfig)fsConfigsMap.get(rc.getName());
                                isCurrent = VersionChecker.checkVersion((BuildVersion)new BuildVersion(rc.getVersion()), (BuildVersion)new BuildVersion(fsc.getVersion()));
                            } else {
                                isCurrent = false;
                            }
                            if (isCurrent) continue;
                            Files.move(dungeonConfigPath, Paths.get(folder.toString(), resourceFilePath.getFileName().toString() + ".bak").toAbsolutePath(), StandardCopyOption.REPLACE_EXISTING);
                            break;
                        }
                    }
                    if (Files.notExists(dungeonConfigPath, new LinkOption[0])) {
                        InputStream is = Dungeons2.class.getResourceAsStream(resourceFilePath.toString());
                        try (FileOutputStream fos = new FileOutputStream(dungeonConfigPath.toFile());){
                            int r;
                            byte[] buf = new byte[2048];
                            while ((r = is.read(buf)) != -1) {
                                fos.write(buf, 0, r);
                            }
                        }
                        catch (IOException e) {
                            Dungeons2.log.error("Error exposing chestsheet resource to file system.");
                        }
                    }
                }
                isFirst = false;
            }
        }
        catch (Exception e) {
            Dungeons2.log.error("error:", (Throwable)e);
        }
        finally {
            if (walk != null) {
                walk.close();
            }
        }
        if (fs != null && fs.isOpen()) {
            try {
                fs.close();
            }
            catch (IOException e) {
                Dungeons2.log.debug("An error occurred attempting to close the FileSystem:", (Throwable)e);
            }
        }
    }

    private static FileSystem getResourceAsFileSystem(String location) {
        FileSystem fs = null;
        HashMap env = new HashMap();
        URI uri = null;
        URL url = Dungeons2.class.getResource(location);
        if (url == null) {
            Dungeons2.log.error("Unable to locate resource {}", (Object)location);
            return null;
        }
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            Dungeons2.log.error("An error occurred during dungeon config processing:", (Throwable)e);
            return null;
        }
        String[] array = uri.toString().split("!");
        try {
            fs = FileSystems.newFileSystem(URI.create(array[0]), env);
        }
        catch (IOException e) {
            Dungeons2.log.error("An error occurred during dungeon config processing:", (Throwable)e);
            return null;
        }
        return fs;
    }

    static {
        DungeonConfigLoader.createFolder();
        DungeonConfigLoader.exposeDungeonsConfigs();
    }
}

