/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.style;

import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeons2.block.DecorationBlock;
import com.someguyssoftware.dungeons2.block.DungeonsBlocks;
import com.someguyssoftware.dungeons2.chest.ChestContainer;
import com.someguyssoftware.dungeons2.chest.ChestPopulator;
import com.someguyssoftware.dungeons2.chest.ChestSheet;
import com.someguyssoftware.dungeons2.config.ModConfig;
import com.someguyssoftware.dungeons2.generator.Location;
import com.someguyssoftware.dungeons2.generator.blockprovider.IDungeonsBlockProvider;
import com.someguyssoftware.dungeons2.model.LevelConfig;
import com.someguyssoftware.dungeons2.model.Room;
import com.someguyssoftware.dungeons2.rotate.RotatorHelper;
import com.someguyssoftware.dungeons2.spawner.SpawnGroup;
import com.someguyssoftware.dungeons2.spawner.SpawnSheet;
import com.someguyssoftware.dungeons2.spawner.SpawnerPopulator;
import com.someguyssoftware.dungeons2.style.DesignElement;
import com.someguyssoftware.dungeons2.style.IRoomDecorator;
import com.someguyssoftware.dungeonsengine.chest.ILootLoader;
import com.someguyssoftware.dungeonsengine.config.ILevelConfig;
import com.someguyssoftware.gottschcore.enums.Direction;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.gottschcore.random.RandomProbabilityCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class RoomDecorator
implements IRoomDecorator {
    final PropertyEnum<BlockTallGrass.EnumType> GRASSTYPE = PropertyEnum.func_177709_a((String)"type", BlockTallGrass.EnumType.class);
    private ChestPopulator chestPopulator;
    private SpawnerPopulator spawnerPopulator;
    private ILootLoader lootLoader;

    public RoomDecorator() {
    }

    @Deprecated
    public RoomDecorator(ChestSheet chestSheet, SpawnSheet spawnSheet) {
        this.spawnerPopulator = new SpawnerPopulator(spawnSheet);
    }

    public RoomDecorator(ILootLoader loader, SpawnSheet spawnSheet) {
        this.spawnerPopulator = new SpawnerPopulator(spawnSheet);
        this.setLootLoader(loader);
    }

    @Override
    public void decorate(World world, Random random, IDungeonsBlockProvider provider, Room room, ILevelConfig config) {
        ICoords spawnerCoords;
        ICoords chestCoords;
        List<Map.Entry<DesignElement, ICoords>> surfaceAirZone = room.getFloorMap().entries().stream().filter(x -> ((DesignElement)((Object)((Object)x.getKey()))).getFamily() == DesignElement.SURFACE_AIR).collect(Collectors.toList());
        if (surfaceAirZone == null || surfaceAirZone.size() == 0) {
            return;
        }
        List<Map.Entry<DesignElement, ICoords>> wallZone = null;
        List<Map.Entry<DesignElement, ICoords>> floorZone = null;
        if (config.isDecorations().booleanValue() || ModConfig.enableChests.booleanValue()) {
            floorZone = surfaceAirZone.stream().filter(f -> f.getKey() == DesignElement.FLOOR_AIR).collect(Collectors.toList());
        }
        if (config.isDecorations().booleanValue()) {
            this.addBlock(world, random, provider, room, surfaceAirZone, new IBlockState[]{Blocks.field_150321_G.func_176223_P()}, config.getWebFrequency(), config.getNumberOfWebs(), config);
            wallZone = surfaceAirZone.stream().filter(f -> f.getKey() == DesignElement.WALL_AIR).collect(Collectors.toList());
            this.addVines(world, random, provider, room, wallZone, config);
            this.addGrass(world, random, provider, room, floorZone, config);
        }
        if (ModConfig.enableChests.booleanValue() && (chestCoords = this.addChest(world, random, provider, room, floorZone, config)) != null) {
            this.getLootLoader().fill(world, random, chestCoords, config.getChestConfig());
            if (Dungeons2.log.isDebugEnabled()) {
                Dungeons2.log.debug("Added chest block @ " + chestCoords.toShortString());
            }
        }
        if (ModConfig.enableSpawners.booleanValue() && (spawnerCoords = this.addSpawner(world, random, provider, room, floorZone, config)) != null) {
            Dungeons2.log.debug("Adding spawner @ " + spawnerCoords.toShortString());
            TileEntityMobSpawner spawner = (TileEntityMobSpawner)world.func_175625_s(spawnerCoords.toPos());
            if (spawner != null) {
                ArrayList<SpawnGroup> groups = new ArrayList<SpawnGroup>(this.spawnerPopulator.getSpawnSheet().getGroups().values());
                RandomProbabilityCollection spawnerProbCol = new RandomProbabilityCollection(groups);
                SpawnGroup spawnGroup = (SpawnGroup)spawnerProbCol.next();
                this.spawnerPopulator.populate(random, spawner, spawnGroup);
            }
        }
    }

    @Override
    @Deprecated
    public void decorate(World world, Random random, IDungeonsBlockProvider provider, Room room, LevelConfig config) {
        ICoords spawnerCoords;
        ICoords chestCoords;
        List<Map.Entry<DesignElement, ICoords>> surfaceAirZone = room.getFloorMap().entries().stream().filter(x -> ((DesignElement)((Object)((Object)x.getKey()))).getFamily() == DesignElement.SURFACE_AIR).collect(Collectors.toList());
        if (surfaceAirZone == null || surfaceAirZone.size() == 0) {
            return;
        }
        List<Map.Entry<DesignElement, ICoords>> wallZone = null;
        List<Map.Entry<DesignElement, ICoords>> floorZone = null;
        if (config.isDecorationsOn()) {
            this.addBlock(world, random, provider, room, surfaceAirZone, new IBlockState[]{Blocks.field_150321_G.func_176223_P()}, config.getWebFrequency(), config.getNumberOfWebs(), config);
            wallZone = surfaceAirZone.stream().filter(f -> f.getKey() == DesignElement.WALL_AIR).collect(Collectors.toList());
            this.addVines(world, random, provider, room, wallZone, config);
            floorZone = surfaceAirZone.stream().filter(f -> f.getKey() == DesignElement.FLOOR_AIR).collect(Collectors.toList());
            this.addGrass(world, random, provider, room, floorZone, config);
            this.addPuddles(world, random, provider, room, floorZone, config);
        }
        if (ModConfig.enableChests.booleanValue() && (chestCoords = this.addChest(world, random, provider, room, floorZone, config)) != null) {
            TileEntityChest inventory;
            if (Dungeons2.log.isDebugEnabled()) {
                Dungeons2.log.debug("Added chest block @ " + chestCoords.toShortString());
            }
            if ((inventory = this.chestPopulator.getChestTileEntity(world, chestCoords)) == null) {
                Dungeons2.log.debug("Manually adding chest tile entity.");
                world.func_175690_a(chestCoords.toPos(), (TileEntity)new TileEntityChest());
                inventory = (TileEntityChest)world.func_175625_s(chestCoords.toPos());
            }
            if (inventory != null) {
                String chestCategory = config.getChestCategories().get(random.nextInt(config.getChestCategories().size()));
                List containers = (List)this.chestPopulator.getMap().get((Object)chestCategory);
                if (containers != null && !containers.isEmpty()) {
                    RandomProbabilityCollection chestProbCol = new RandomProbabilityCollection((Collection)containers);
                    ChestContainer chest = (ChestContainer)chestProbCol.next();
                    this.chestPopulator.populate(random, (IInventory)inventory, chest);
                }
            } else {
                Dungeons2.log.debug("Chest tile entity not found... removing chest block.");
                world.func_175656_a(chestCoords.toPos(), Blocks.field_150350_a.func_176223_P());
            }
        }
        if (ModConfig.enableSpawners.booleanValue() && (spawnerCoords = this.addSpawner(world, random, provider, room, floorZone, config)) != null) {
            Dungeons2.log.debug("Adding spawner @ " + spawnerCoords.toShortString());
            TileEntityMobSpawner spawner = (TileEntityMobSpawner)world.func_175625_s(spawnerCoords.toPos());
            if (spawner != null) {
                ArrayList<SpawnGroup> groups = new ArrayList<SpawnGroup>(this.spawnerPopulator.getSpawnSheet().getGroups().values());
                RandomProbabilityCollection spawnerProbCol = new RandomProbabilityCollection(groups);
                SpawnGroup spawnGroup = (SpawnGroup)spawnerProbCol.next();
                this.spawnerPopulator.populate(random, spawner, spawnGroup);
            }
        }
    }

    protected void addAnywhereDecoration(World world, Random random, IDungeonsBlockProvider provider, Room room, List<Map.Entry<DesignElement, ICoords>> airZone, LevelConfig config) {
        double freq = RandomHelper.randomDouble((Random)random, (double)config.getAnywhereDecorationFrequency().getMin(), (double)config.getAnywhereDecorationFrequency().getMax());
        for (int i = 0; i < this.scaleNumForSizeOfRoom(room, RandomHelper.randomInt((Random)random, (int)config.getNumberOfAnywhereDecorations().getMinInt(), (int)config.getNumberOfAnywhereDecorations().getMaxInt()), config); ++i) {
            double n = random.nextDouble() * 100.0;
            int b = random.nextInt(5);
            Object block = null;
            if (!(n < freq) || airZone.size() <= 0) continue;
            int airZoneIndex = random.nextInt(airZone.size());
            Map.Entry<DesignElement, ICoords> entry = airZone.get(airZoneIndex);
            DesignElement elem = airZone.get(airZoneIndex).getKey();
            ICoords coords = entry.getValue();
            Location location = provider.getLocation(coords, room, room.getLayout());
            IBlockState blockState = null;
            if (!this.hasSupport(world, coords, elem, location)) continue;
            switch (elem) {
                case FLOOR_AIR: {
                    blockState = block.func_176223_P().func_177226_a((IProperty)DecorationBlock.BASE, (Comparable)EnumFacing.UP);
                    break;
                }
                case WALL_AIR: {
                    switch (location) {
                        case NORTH_SIDE: {
                            blockState = block.func_176223_P().func_177226_a((IProperty)DecorationBlock.BASE, (Comparable)EnumFacing.SOUTH);
                            break;
                        }
                        case EAST_SIDE: {
                            blockState = block.func_176223_P().func_177226_a((IProperty)DecorationBlock.BASE, (Comparable)EnumFacing.WEST);
                            break;
                        }
                        case SOUTH_SIDE: {
                            blockState = block.func_176223_P().func_177226_a((IProperty)DecorationBlock.BASE, (Comparable)EnumFacing.NORTH);
                            break;
                        }
                        case WEST_SIDE: {
                            blockState = block.func_176223_P().func_177226_a((IProperty)DecorationBlock.BASE, (Comparable)EnumFacing.EAST);
                        }
                    }
                    break;
                }
                case CEILING_AIR: {
                    blockState = block.func_176223_P().func_177226_a((IProperty)DecorationBlock.BASE, (Comparable)EnumFacing.DOWN);
                }
            }
            if (blockState == null) continue;
            world.func_180501_a(coords.toPos(), blockState, 3);
            airZone.remove(entry);
        }
    }

    protected void addBlood(World world, Random random, IDungeonsBlockProvider provider, Room room, List<Map.Entry<DesignElement, ICoords>> zone, LevelConfig config) {
        double freq = RandomHelper.randomDouble((Random)random, (double)config.getBloodFrequency().getMin(), (double)config.getBloodFrequency().getMax());
        for (int i = 0; i < this.scaleNumForSizeOfRoom(room, RandomHelper.randomInt((Random)random, (int)config.getNumberOfBlood().getMinInt(), (int)config.getNumberOfBlood().getMaxInt()), config); ++i) {
            double n = random.nextDouble() * 100.0;
            Object block = null;
            if (!(n < freq) || zone.size() <= 0) continue;
            int airZoneIndex = random.nextInt(zone.size());
            Map.Entry<DesignElement, ICoords> entry = zone.get(airZoneIndex);
            DesignElement elem = zone.get(airZoneIndex).getKey();
            ICoords coords = entry.getValue();
            Location location = provider.getLocation(coords, room, room.getLayout());
            IBlockState blockState = null;
            if (!this.hasSupport(world, coords, elem, location)) continue;
            block0 : switch (elem) {
                case FLOOR_AIR: {
                    blockState = block.func_176223_P().func_177226_a((IProperty)DecorationBlock.BASE, (Comparable)EnumFacing.UP);
                    break;
                }
                case WALL_AIR: {
                    switch (location) {
                        case NORTH_SIDE: {
                            blockState = block.func_176223_P().func_177226_a((IProperty)DecorationBlock.BASE, (Comparable)EnumFacing.SOUTH);
                            break block0;
                        }
                        case EAST_SIDE: {
                            blockState = block.func_176223_P().func_177226_a((IProperty)DecorationBlock.BASE, (Comparable)EnumFacing.WEST);
                            break block0;
                        }
                        case SOUTH_SIDE: {
                            blockState = block.func_176223_P().func_177226_a((IProperty)DecorationBlock.BASE, (Comparable)EnumFacing.NORTH);
                            break block0;
                        }
                        case WEST_SIDE: {
                            blockState = block.func_176223_P().func_177226_a((IProperty)DecorationBlock.BASE, (Comparable)EnumFacing.EAST);
                        }
                    }
                }
            }
            if (blockState == null) continue;
            world.func_180501_a(coords.toPos(), blockState, 3);
            zone.remove(entry);
        }
    }

    protected void addWebs(World world, Random random, IDungeonsBlockProvider provider, Room room, List<Map.Entry<DesignElement, ICoords>> zone, LevelConfig config) {
        double freq = RandomHelper.randomDouble((Random)random, (double)config.getWebFrequency().getMin(), (double)config.getWebFrequency().getMax());
        for (int i = 0; i < this.scaleNumForSizeOfRoom(room, RandomHelper.randomInt((Random)random, (int)config.getNumberOfWebs().getMinInt(), (int)config.getNumberOfWebs().getMaxInt()), config); ++i) {
            double n = random.nextDouble() * 100.0;
            if (!(n < freq) || zone.size() <= 0) continue;
            int zoneIndex = random.nextInt(zone.size());
            Map.Entry<DesignElement, ICoords> entry = zone.get(zoneIndex);
            DesignElement elem = zone.get(zoneIndex).getKey();
            ICoords webCoords = entry.getValue();
            if (!this.hasSupport(world, webCoords, elem, provider.getLocation(webCoords, room, room.getLayout()))) continue;
            world.func_180501_a(webCoords.toPos(), Blocks.field_150321_G.func_176223_P(), 3);
            zone.remove(entry);
        }
    }

    protected void addVines(World world, Random random, IDungeonsBlockProvider provider, Room room, List<Map.Entry<DesignElement, ICoords>> zone, ILevelConfig config) {
        double freq = RandomHelper.randomDouble((Random)random, (double)config.getVineFrequency().getMin(), (double)config.getVineFrequency().getMax());
        for (int i = 0; i < this.scaleNumForSizeOfRoom(room, RandomHelper.randomInt((Random)random, (int)config.getNumberOfVines().getMinInt(), (int)config.getNumberOfVines().getMaxInt()), config); ++i) {
            double n = random.nextDouble() * 100.0;
            if (!(n < freq) || zone.size() <= 0) continue;
            int wallZoneIndex = random.nextInt(zone.size());
            DesignElement elem = zone.get(wallZoneIndex).getKey();
            ICoords vineCoords = zone.get(wallZoneIndex).getValue();
            if (!this.hasSupport(world, vineCoords, elem, provider.getLocation(vineCoords, room, room.getLayout()))) continue;
            Location location = provider.getLocation(vineCoords, room, room.getLayout());
            Direction d = provider.getDirection(vineCoords, room, DesignElement.WALL_AIR, location);
            IBlockState blockState = RotatorHelper.rotateBlock(Blocks.field_150395_bd.func_176223_P(), d);
            world.func_180501_a(vineCoords.toPos(), blockState, 3);
            zone.remove(wallZoneIndex);
        }
    }

    @Deprecated
    protected void addVines(World world, Random random, IDungeonsBlockProvider provider, Room room, List<Map.Entry<DesignElement, ICoords>> zone, LevelConfig config) {
        double freq = RandomHelper.randomDouble((Random)random, (double)config.getVineFrequency().getMin(), (double)config.getVineFrequency().getMax());
        for (int i = 0; i < this.scaleNumForSizeOfRoom(room, RandomHelper.randomInt((Random)random, (int)config.getNumberOfVines().getMinInt(), (int)config.getNumberOfVines().getMaxInt()), config); ++i) {
            double n = random.nextDouble() * 100.0;
            if (!(n < freq) || zone.size() <= 0) continue;
            int wallZoneIndex = random.nextInt(zone.size());
            DesignElement elem = zone.get(wallZoneIndex).getKey();
            ICoords vineCoords = zone.get(wallZoneIndex).getValue();
            if (!this.hasSupport(world, vineCoords, elem, provider.getLocation(vineCoords, room, room.getLayout()))) continue;
            Location location = provider.getLocation(vineCoords, room, room.getLayout());
            Direction d = provider.getDirection(vineCoords, room, DesignElement.WALL_AIR, location);
            IBlockState blockState = RotatorHelper.rotateBlock(Blocks.field_150395_bd.func_176223_P(), d);
            world.func_180501_a(vineCoords.toPos(), blockState, 3);
            zone.remove(wallZoneIndex);
        }
    }

    protected void addGrass(World world, Random random, IDungeonsBlockProvider provider, Room room, List<Map.Entry<DesignElement, ICoords>> floorZone, ILevelConfig config) {
        double freq = RandomHelper.randomDouble((Random)random, (double)config.getWebFrequency().getMin(), (double)config.getWebFrequency().getMax());
        for (int i = 0; i < this.scaleNumForSizeOfRoom(room, RandomHelper.randomInt((Random)random, (int)config.getNumberOfWebs().getMinInt(), (int)config.getNumberOfWebs().getMaxInt()), config); ++i) {
            double n = random.nextDouble() * 100.0;
            if (!(n < freq) || floorZone.size() <= 0) continue;
            int b = random.nextInt(5);
            IBlockState plantBlockState = null;
            IBlockState groundBlockState = null;
            switch (b) {
                case 0: {
                    plantBlockState = Blocks.field_150329_H.func_176223_P().func_177226_a(this.GRASSTYPE, (Comparable)BlockTallGrass.EnumType.GRASS);
                    break;
                }
                case 1: {
                    plantBlockState = Blocks.field_150329_H.func_176223_P().func_177226_a(this.GRASSTYPE, (Comparable)BlockTallGrass.EnumType.DEAD_BUSH);
                    break;
                }
                case 2: {
                    plantBlockState = Blocks.field_150329_H.func_176223_P().func_177226_a(this.GRASSTYPE, (Comparable)BlockTallGrass.EnumType.FERN);
                    break;
                }
                case 3: {
                    plantBlockState = Blocks.field_150338_P.func_176223_P();
                    break;
                }
                case 4: {
                    plantBlockState = Blocks.field_150337_Q.func_176223_P();
                    break;
                }
                default: {
                    plantBlockState = Blocks.field_150329_H.func_176223_P().func_177226_a(this.GRASSTYPE, (Comparable)BlockTallGrass.EnumType.GRASS);
                }
            }
            groundBlockState = b < 3 ? Blocks.field_150346_d.func_176223_P() : Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL);
            int floorZoneIndex = random.nextInt(floorZone.size());
            DesignElement elem = floorZone.get(floorZoneIndex).getKey();
            ICoords grassCoords = floorZone.get(floorZoneIndex).getValue();
            if (!this.hasSupport(world, grassCoords, elem, provider.getLocation(grassCoords, room, room.getLayout()))) continue;
            world.func_180501_a(grassCoords.toPos().func_177982_a(0, -1, 0), groundBlockState, 3);
            world.func_180501_a(grassCoords.toPos(), plantBlockState, 3);
            floorZone.remove((Object)elem);
        }
    }

    @Deprecated
    protected void addGrass(World world, Random random, IDungeonsBlockProvider provider, Room room, List<Map.Entry<DesignElement, ICoords>> floorZone, LevelConfig config) {
        double freq = RandomHelper.randomDouble((Random)random, (double)config.getWebFrequency().getMin(), (double)config.getWebFrequency().getMax());
        for (int i = 0; i < this.scaleNumForSizeOfRoom(room, RandomHelper.randomInt((Random)random, (int)config.getNumberOfWebs().getMinInt(), (int)config.getNumberOfWebs().getMaxInt()), config); ++i) {
            double n = random.nextDouble() * 100.0;
            if (!(n < freq) || floorZone.size() <= 0) continue;
            int b = random.nextInt(5);
            IBlockState plantBlockState = null;
            IBlockState groundBlockState = null;
            switch (b) {
                case 0: {
                    plantBlockState = Blocks.field_150329_H.func_176223_P().func_177226_a(this.GRASSTYPE, (Comparable)BlockTallGrass.EnumType.GRASS);
                    break;
                }
                case 1: {
                    plantBlockState = Blocks.field_150329_H.func_176223_P().func_177226_a(this.GRASSTYPE, (Comparable)BlockTallGrass.EnumType.DEAD_BUSH);
                    break;
                }
                case 2: {
                    plantBlockState = Blocks.field_150329_H.func_176223_P().func_177226_a(this.GRASSTYPE, (Comparable)BlockTallGrass.EnumType.FERN);
                    break;
                }
                case 3: {
                    plantBlockState = Blocks.field_150338_P.func_176223_P();
                    break;
                }
                case 4: {
                    plantBlockState = Blocks.field_150337_Q.func_176223_P();
                    break;
                }
                default: {
                    plantBlockState = Blocks.field_150329_H.func_176223_P().func_177226_a(this.GRASSTYPE, (Comparable)BlockTallGrass.EnumType.GRASS);
                }
            }
            groundBlockState = b < 3 ? Blocks.field_150346_d.func_176223_P() : Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL);
            int floorZoneIndex = random.nextInt(floorZone.size());
            DesignElement elem = floorZone.get(floorZoneIndex).getKey();
            ICoords grassCoords = floorZone.get(floorZoneIndex).getValue();
            if (!this.hasSupport(world, grassCoords, elem, provider.getLocation(grassCoords, room, room.getLayout()))) continue;
            world.func_180501_a(grassCoords.toPos().func_177982_a(0, -1, 0), groundBlockState, 3);
            world.func_180501_a(grassCoords.toPos(), plantBlockState, 3);
            floorZone.remove((Object)elem);
        }
    }

    protected void addPuddles(World world, Random random, IDungeonsBlockProvider provider, Room room, List<Map.Entry<DesignElement, ICoords>> zone, LevelConfig config) {
        double freq = RandomHelper.randomDouble((Random)random, (double)config.getPuddleFrequency().getMin(), (double)config.getPuddleFrequency().getMax());
        for (int i = 0; i < this.scaleNumForSizeOfRoom(room, RandomHelper.randomInt((Random)random, (int)config.getNumberOfPuddles().getMinInt(), (int)config.getNumberOfPuddles().getMaxInt()), config); ++i) {
            double n = random.nextDouble() * 100.0;
            if (!(n < freq) || zone.size() <= 0) continue;
            int floorZoneIndex = random.nextInt(zone.size());
            DesignElement elem = zone.get(floorZoneIndex).getKey();
            ICoords coords = zone.get(floorZoneIndex).getValue();
            if (!this.hasSupport(world, coords, elem, provider.getLocation(coords, room, room.getLayout()))) continue;
            world.func_180501_a(coords.toPos(), DungeonsBlocks.PUDDLE.func_176223_P().func_177226_a((IProperty)DecorationBlock.BASE, (Comparable)EnumFacing.UP), 3);
            zone.remove((Object)elem);
        }
    }

    protected ICoords addChest(World world, Random random, IDungeonsBlockProvider provider, Room room, List<Map.Entry<DesignElement, ICoords>> floorZone, ILevelConfig config) {
        ICoords chestCoords = null;
        double freq = RandomHelper.randomDouble((Random)random, (double)config.getChestFrequency().getMin(), (double)config.getChestFrequency().getMax());
        if (RandomHelper.checkProbability((Random)random, (double)freq) && floorZone.size() > 0) {
            Location location;
            int floorIndex = random.nextInt(floorZone.size());
            DesignElement elem = floorZone.get(floorIndex).getKey();
            chestCoords = floorZone.get(floorIndex).getValue();
            if (this.hasSupport(world, chestCoords, elem, location = provider.getLocation(chestCoords, room, room.getLayout()))) {
                EnumFacing facing = this.orientChest(location);
                world.func_180501_a(chestCoords.toPos(), Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)facing), 3);
                floorZone.remove(floorIndex);
            } else {
                chestCoords = null;
            }
        }
        return chestCoords;
    }

    @Deprecated
    protected ICoords addChest(World world, Random random, IDungeonsBlockProvider provider, Room room, List<Map.Entry<DesignElement, ICoords>> floorZone, LevelConfig config) {
        ICoords chestCoords = null;
        double freq = RandomHelper.randomDouble((Random)random, (double)config.getChestFrequency().getMin(), (double)config.getChestFrequency().getMax());
        if (random.nextDouble() * 100.0 < freq && floorZone.size() > 0) {
            Location location;
            int floorIndex = random.nextInt(floorZone.size());
            DesignElement elem = floorZone.get(floorIndex).getKey();
            chestCoords = floorZone.get(floorIndex).getValue();
            if (this.hasSupport(world, chestCoords, elem, location = provider.getLocation(chestCoords, room, room.getLayout()))) {
                EnumFacing facing = this.orientChest(location);
                world.func_180501_a(chestCoords.toPos(), Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)facing), 3);
                floorZone.remove(floorIndex);
            } else {
                chestCoords = null;
            }
        }
        return chestCoords;
    }

    protected ICoords addSpawner(World world, Random random, IDungeonsBlockProvider provider, Room room, List<Map.Entry<DesignElement, ICoords>> floorZone, ILevelConfig config) {
        ICoords spawnerCoords = null;
        double freq = RandomHelper.randomDouble((Random)random, (double)config.getSpawnerFrequency().getMin(), (double)config.getSpawnerFrequency().getMax());
        if (random.nextDouble() * 100.0 < freq && floorZone.size() > 0) {
            Location location;
            int floorIndex = random.nextInt(floorZone.size());
            DesignElement elem = floorZone.get(floorIndex).getKey();
            spawnerCoords = floorZone.get(floorIndex).getValue();
            if (this.hasSupport(world, spawnerCoords, elem, location = provider.getLocation(spawnerCoords, room, room.getLayout()))) {
                world.func_175656_a(spawnerCoords.toPos(), Blocks.field_150474_ac.func_176223_P());
                floorZone.remove(floorIndex);
            }
        }
        return spawnerCoords;
    }

    @Deprecated
    protected ICoords addSpawner(World world, Random random, IDungeonsBlockProvider provider, Room room, List<Map.Entry<DesignElement, ICoords>> floorZone, LevelConfig config) {
        ICoords spawnerCoords = null;
        double freq = RandomHelper.randomDouble((Random)random, (double)config.getSpawnerFrequency().getMin(), (double)config.getSpawnerFrequency().getMax());
        if (random.nextDouble() * 100.0 < freq && floorZone.size() > 0) {
            Location location;
            int floorIndex = random.nextInt(floorZone.size());
            DesignElement elem = floorZone.get(floorIndex).getKey();
            spawnerCoords = floorZone.get(floorIndex).getValue();
            if (this.hasSupport(world, spawnerCoords, elem, location = provider.getLocation(spawnerCoords, room, room.getLayout()))) {
                world.func_175656_a(spawnerCoords.toPos(), Blocks.field_150474_ac.func_176223_P());
                floorZone.remove(floorIndex);
            }
        }
        return spawnerCoords;
    }

    public ILootLoader getLootLoader() {
        return this.lootLoader;
    }

    public void setLootLoader(ILootLoader lootLoader) {
        this.lootLoader = lootLoader;
    }
}

