/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.style;

import com.someguyssoftware.dungeons2.chest.ChestSheet;
import com.someguyssoftware.dungeons2.generator.blockprovider.IDungeonsBlockProvider;
import com.someguyssoftware.dungeons2.model.LevelConfig;
import com.someguyssoftware.dungeons2.model.Room;
import com.someguyssoftware.dungeons2.spawner.SpawnSheet;
import com.someguyssoftware.dungeons2.style.DesignElement;
import com.someguyssoftware.dungeons2.style.RoomDecorator;
import com.someguyssoftware.dungeonsengine.chest.ILootLoader;
import com.someguyssoftware.dungeonsengine.config.ILevelConfig;
import com.someguyssoftware.gottschcore.positional.ICoords;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class LibraryRoomDecorator
extends RoomDecorator {
    private static final int CARPET_PERCENT_CHANCE = 85;

    @Deprecated
    public LibraryRoomDecorator(ChestSheet chestSheet, SpawnSheet spawnSheet) {
        super(chestSheet, spawnSheet);
    }

    public LibraryRoomDecorator(ILootLoader loader, SpawnSheet spawnSheet) {
        super(loader, spawnSheet);
    }

    @Override
    public void decorate(World world, Random random, IDungeonsBlockProvider provider, Room room, ILevelConfig config) {
        int zIndex;
        int xIndex;
        List surfaceAirZone = room.getFloorMap().entries().stream().filter(x -> ((DesignElement)((Object)((Object)x.getKey()))).getFamily() == DesignElement.SURFACE_AIR).collect(Collectors.toList());
        if (surfaceAirZone == null || surfaceAirZone.size() == 0) {
            return;
        }
        List wallZone = null;
        List floorZone = null;
        wallZone = (List)room.getFloorMap().get((Object)DesignElement.WALL_AIR);
        floorZone = (List)room.getFloorMap().get((Object)DesignElement.FLOOR_AIR);
        ArrayList<ICoords> removeFloorZones = new ArrayList<ICoords>();
        ArrayList<ICoords> removeWallZones = new ArrayList<ICoords>();
        EnumDyeColor dye = EnumDyeColor.values()[random.nextInt(EnumDyeColor.values().length)];
        for (ICoords coords : floorZone) {
            BlockPos floorPos = coords.toPos().func_177977_b();
            xIndex = coords.getX() - room.getCoords().getX();
            zIndex = coords.getZ() - room.getCoords().getZ();
            if (coords.getX() == room.getMinX() + 1 || coords.getX() == room.getMaxX() - 1 || coords.getZ() == room.getMinZ() + 1 || coords.getZ() == room.getMaxZ() - 1) {
                if (this.hasSupport(world, coords, DesignElement.FLOOR_AIR, provider.getLocation(coords, room, room.getLayout()))) {
                    if ((coords.getX() == room.getMinX() + 1 || coords.getX() == room.getMaxX() - 1) && Math.abs(zIndex) % 4 == 0 || (coords.getZ() == room.getMinZ() + 1 || coords.getZ() == room.getMaxZ() - 1) && Math.abs(xIndex) % 4 == 0) {
                        world.func_175656_a(coords.toPos(), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
                    } else {
                        world.func_180501_a(coords.toPos(), Blocks.field_150342_X.func_176223_P(), 3);
                    }
                    removeFloorZones.add(coords);
                }
            } else {
                IBlockState carpet = Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockCarpet.field_176330_a, (Comparable)dye);
                if (random.nextInt(100) < 85 && world.func_180495_p(floorPos).isSideSolid((IBlockAccess)world, floorPos, EnumFacing.UP)) {
                    world.func_180501_a(coords.toPos(), carpet, 3);
                }
            }
            if (!world.func_180495_p(floorPos).isSideSolid((IBlockAccess)world, floorPos, EnumFacing.UP)) continue;
            world.func_175656_a(floorPos, Blocks.field_150344_f.func_176223_P());
        }
        for (ICoords coords : wallZone) {
            DesignElement elem;
            if (!this.hasSupport(world, coords, elem = DesignElement.WALL_AIR, provider.getLocation(coords, room, room.getLayout()))) continue;
            xIndex = coords.getX() - room.getCoords().getX();
            zIndex = coords.getZ() - room.getCoords().getZ();
            if ((coords.getX() == room.getMinX() + 1 || coords.getX() == room.getMaxX() - 1) && Math.abs(zIndex) % 4 == 0 || (coords.getZ() == room.getMinZ() + 1 || coords.getZ() == room.getMaxZ() - 1) && Math.abs(xIndex) % 4 == 0) {
                world.func_175656_a(coords.toPos(), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
            } else {
                world.func_180501_a(coords.toPos(), Blocks.field_150342_X.func_176223_P(), 3);
            }
            removeWallZones.add(coords);
        }
        for (ICoords c : removeFloorZones) {
            room.getFloorMap().remove((Object)DesignElement.FLOOR_AIR, (Object)c);
        }
        for (ICoords c : removeWallZones) {
            room.getFloorMap().remove((Object)DesignElement.WALL_AIR, (Object)c);
        }
        floorZone.removeAll(removeFloorZones);
        removeFloorZones.clear();
        wallZone.removeAll(removeWallZones);
        removeWallZones.clear();
        super.decorate(world, random, provider, room, config);
    }

    @Override
    @Deprecated
    public void decorate(World world, Random random, IDungeonsBlockProvider provider, Room room, LevelConfig config) {
        int zIndex;
        int xIndex;
        List surfaceAirZone = room.getFloorMap().entries().stream().filter(x -> ((DesignElement)((Object)((Object)x.getKey()))).getFamily() == DesignElement.SURFACE_AIR).collect(Collectors.toList());
        if (surfaceAirZone == null || surfaceAirZone.size() == 0) {
            return;
        }
        List wallZone = null;
        List floorZone = null;
        wallZone = (List)room.getFloorMap().get((Object)DesignElement.WALL_AIR);
        floorZone = (List)room.getFloorMap().get((Object)DesignElement.FLOOR_AIR);
        ArrayList<ICoords> removeFloorZones = new ArrayList<ICoords>();
        ArrayList<ICoords> removeWallZones = new ArrayList<ICoords>();
        EnumDyeColor dye = EnumDyeColor.values()[random.nextInt(EnumDyeColor.values().length)];
        for (ICoords coords : floorZone) {
            BlockPos floorPos = coords.toPos().func_177977_b();
            xIndex = coords.getX() - room.getCoords().getX();
            zIndex = coords.getZ() - room.getCoords().getZ();
            if (coords.getX() == room.getMinX() + 1 || coords.getX() == room.getMaxX() - 1 || coords.getZ() == room.getMinZ() + 1 || coords.getZ() == room.getMaxZ() - 1) {
                if (this.hasSupport(world, coords, DesignElement.FLOOR_AIR, provider.getLocation(coords, room, room.getLayout()))) {
                    if ((coords.getX() == room.getMinX() + 1 || coords.getX() == room.getMaxX() - 1) && Math.abs(zIndex) % 4 == 0 || (coords.getZ() == room.getMinZ() + 1 || coords.getZ() == room.getMaxZ() - 1) && Math.abs(xIndex) % 4 == 0) {
                        world.func_175656_a(coords.toPos(), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
                    } else {
                        world.func_180501_a(coords.toPos(), Blocks.field_150342_X.func_176223_P(), 3);
                    }
                    removeFloorZones.add(coords);
                }
            } else {
                IBlockState carpet = Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockCarpet.field_176330_a, (Comparable)dye);
                if (random.nextInt(100) < 85 && world.func_180495_p(floorPos).isSideSolid((IBlockAccess)world, floorPos, EnumFacing.UP)) {
                    world.func_180501_a(coords.toPos(), carpet, 3);
                }
            }
            if (!world.func_180495_p(floorPos).isSideSolid((IBlockAccess)world, floorPos, EnumFacing.UP)) continue;
            world.func_175656_a(floorPos, Blocks.field_150344_f.func_176223_P());
        }
        for (ICoords coords : wallZone) {
            DesignElement elem;
            if (!this.hasSupport(world, coords, elem = DesignElement.WALL_AIR, provider.getLocation(coords, room, room.getLayout()))) continue;
            xIndex = coords.getX() - room.getCoords().getX();
            zIndex = coords.getZ() - room.getCoords().getZ();
            if ((coords.getX() == room.getMinX() + 1 || coords.getX() == room.getMaxX() - 1) && Math.abs(zIndex) % 4 == 0 || (coords.getZ() == room.getMinZ() + 1 || coords.getZ() == room.getMaxZ() - 1) && Math.abs(xIndex) % 4 == 0) {
                world.func_175656_a(coords.toPos(), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
            } else {
                world.func_180501_a(coords.toPos(), Blocks.field_150342_X.func_176223_P(), 3);
            }
            removeWallZones.add(coords);
        }
        for (ICoords c : removeFloorZones) {
            room.getFloorMap().remove((Object)DesignElement.FLOOR_AIR, (Object)c);
        }
        for (ICoords c : removeWallZones) {
            room.getFloorMap().remove((Object)DesignElement.WALL_AIR, (Object)c);
        }
        floorZone.removeAll(removeFloorZones);
        removeFloorZones.clear();
        wallZone.removeAll(removeWallZones);
        removeWallZones.clear();
        super.decorate(world, random, provider, room, config);
    }
}

