/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.style;

import com.someguyssoftware.dungeons2.style.DesignElement;
import com.someguyssoftware.dungeons2.style.Face;
import com.someguyssoftware.dungeons2.style.Frame;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Layout {
    public static final String DEFAULT_NAME = "default";
    private String ref;
    private boolean useAll;
    private String category;
    private String name;
    private Map<String, Frame> frames = new HashMap<String, Frame>();
    protected transient String __comment;

    public Layout() {
    }

    public Layout(String name) {
        this();
        this.name = name;
    }

    @Deprecated
    public boolean isInteriorComplete() {
        List elemNames = this.frames.keySet().stream().filter(x -> DesignElement.getByValue(x).getFace() == Face.INTERIOR || DesignElement.getByValue(x).getFace() == Face.BOTH).collect(Collectors.toList());
        List enums = EnumSet.allOf(DesignElement.class).stream().filter(x -> x.getFace() == Face.INTERIOR || x.getFace() == Face.BOTH).collect(Collectors.toList());
        for (DesignElement de : enums) {
            if (elemNames.contains(de.name())) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public Layout setName(String name) {
        this.name = name;
        return this;
    }

    public String toString() {
        return "Layout [NAME=" + this.name + ", frames=" + this.frames + "]";
    }

    public Map<String, Frame> getFrames() {
        return this.frames;
    }

    public void setFrames(Map<String, Frame> frames) {
        this.frames = frames;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public boolean isUseAll() {
        return this.useAll;
    }

    public void setUseAll(boolean useAll) {
        this.useAll = useAll;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getComment() {
        return this.__comment;
    }

    public void setComment(String comment) {
        this.__comment = comment;
    }

    public static enum Type {
        ENTRANCE("entrance"),
        START("start"),
        END("end"),
        ROOM("room"),
        HALLWAY("hallway"),
        BOSS("boss"),
        TREASURE("treasure");

        private String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static enum Category {
        DEFAULT("default");

        private String name;

        private Category(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

