/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.spawner;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeons2.spawner.SpawnGroup;
import com.someguyssoftware.dungeons2.spawner.SpawnSheet;
import java.util.Map;
import java.util.Random;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;

public class SpawnerPopulator {
    private SpawnSheet spawnSheet;
    private Multimap<String, SpawnGroup> map = ArrayListMultimap.create();

    public SpawnerPopulator(SpawnSheet sheet) {
        this.spawnSheet = sheet;
        this.loadSpawnSheet(sheet);
    }

    public void loadSpawnSheet(SpawnSheet spawnSheet) {
        this.map.clear();
        for (Map.Entry<String, SpawnGroup> e : spawnSheet.getGroups().entrySet()) {
            SpawnGroup group = e.getValue();
            if (group.getCategory() != null && !group.getCategory().equals("")) {
                this.map.put((Object)group.getCategory().toLowerCase(), (Object)group);
                continue;
            }
            this.map.put((Object)"common", (Object)group);
        }
    }

    public void populate(Random random, TileEntityMobSpawner spawner, SpawnGroup group) {
        String mob = group.getMobs().get(random.nextInt(group.getMobs().size()));
        spawner.func_145881_a().func_190894_a(new ResourceLocation(mob));
        Dungeons2.log.debug("Adding mob to spawner:" + mob);
    }

    public SpawnSheet getSpawnSheet() {
        return this.spawnSheet;
    }

    public void setSpawnSheet(SpawnSheet spawnSheet) {
        this.spawnSheet = spawnSheet;
    }
}

