/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.spawner;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeons2.config.ModConfig;
import com.someguyssoftware.dungeons2.spawner.SpawnSheet;
import com.someguyssoftware.gottschcore.json.JSMin;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class SpawnSheetLoader {
    public static final String BUILT_IN_SPAWN_SHEET_PATH = "/spawnsheet.json";
    public static final String BUILT_IN_SPAWN_SHEET_SUB_FOLDER = "/spawnSheets/";
    private static final SpawnSheet EMPTY_SHEET = new SpawnSheet();

    public static SpawnSheet load() throws Exception {
        SpawnSheet spawnSheet = null;
        InputStream is = ((Object)((Object)Dungeons2.instance)).getClass().getResourceAsStream(BUILT_IN_SPAWN_SHEET_PATH);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JSMin minifier = new JSMin(is, (OutputStream)out);
        minifier.jsmin();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        InputStreamReader reader = new InputStreamReader(in);
        JsonReader jsonReader = new JsonReader((Reader)reader);
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        try {
            spawnSheet = (SpawnSheet)gson.fromJson(jsonReader, SpawnSheet.class);
            Dungeons2.log.debug("Loaded spawnSheet:" + spawnSheet);
        }
        catch (JsonIOException | JsonSyntaxException e) {
            throw new Exception("Unable to load spawn sheet.");
        }
        finally {
            try {
                jsonReader.close();
            }
            catch (IOException e) {
                Dungeons2.log.warn("Unable to close JSON Reader when reading built-in spawn sheet.");
            }
        }
        return spawnSheet;
    }

    public static SpawnSheet loadAll() throws Exception {
        Path defaultSheetPath = Paths.get(ModConfig.dungeonsFolder, "spawnSheet.json").toAbsolutePath();
        Dungeons2.log.debug("Sheets Folder:" + defaultSheetPath.toString());
        SpawnSheet sheet = SpawnSheetLoader.load(defaultSheetPath.toString());
        if (sheet == null || sheet == EMPTY_SHEET) {
            Dungeons2.log.warn("Unable to locate default spawn sheet at location " + defaultSheetPath.toString());
            return EMPTY_SHEET;
        }
        Files.newDirectoryStream(Paths.get(ModConfig.dungeonsFolder, BUILT_IN_SPAWN_SHEET_SUB_FOLDER), path -> path.toString().endsWith(".json")).forEach(path -> {
            try {
                SpawnSheet s = SpawnSheetLoader.load(path.toString());
                if (sheet.getGroups() != null && s.getGroups() != null) {
                    sheet.getGroups().putAll(s.getGroups());
                }
            }
            catch (Exception e) {
                Dungeons2.log.error("Unable to load additional spawn sheet " + path.toString(), (Throwable)e);
            }
        });
        return sheet;
    }

    public static SpawnSheet load(String filePath) throws Exception {
        SpawnSheet spawnSheet = null;
        Path path = Paths.get(filePath, new String[0]).toAbsolutePath();
        if (Files.notExists(path, new LinkOption[0])) {
            Dungeons2.log.warn("Unable to locate spawn sheet using path: " + filePath);
            return EMPTY_SHEET;
        }
        FileInputStream is = new FileInputStream(path.toString());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JSMin minifier = new JSMin((InputStream)is, (OutputStream)out);
        minifier.jsmin();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        InputStreamReader reader = new InputStreamReader(in);
        JsonReader jsonReader = new JsonReader((Reader)reader);
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        try {
            spawnSheet = (SpawnSheet)gson.fromJson(jsonReader, SpawnSheet.class);
            Dungeons2.log.debug("Loaded spawnSheet:" + spawnSheet);
        }
        catch (JsonIOException | JsonSyntaxException e) {
            throw new Exception("Unable to load spawn sheet.");
        }
        finally {
            try {
                ((Reader)reader).close();
            }
            catch (IOException e) {
                Dungeons2.log.warn("Unable to close JSON Reader when reading built-in spawn sheet.");
            }
        }
        return spawnSheet;
    }

    public static boolean hasSpawnSheet(String filePath) {
        Path path = Paths.get(ModConfig.spawnSheetFile, new String[0]).toAbsolutePath();
        return Files.exists(path, new LinkOption[0]);
    }

    public static boolean hasSpawnSheet(Path path) {
        return Files.exists(path.toAbsolutePath(), new LinkOption[0]);
    }

    public static void exposeSpawnSheet(String filePath) {
        Path path = Paths.get(filePath, new String[0]).toAbsolutePath();
        if (Files.notExists(path, new LinkOption[0])) {
            InputStream is = ((Object)((Object)Dungeons2.instance)).getClass().getResourceAsStream(BUILT_IN_SPAWN_SHEET_PATH);
            try (FileOutputStream fos = new FileOutputStream(path.toFile());){
                int r;
                byte[] buf = new byte[2048];
                while ((r = is.read(buf)) != -1) {
                    fos.write(buf, 0, r);
                }
            }
            catch (IOException e) {
                Dungeons2.log.error("Error exposing spawnsheet resource to file system.");
            }
        }
    }
}

