/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.rotate;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeons2.rotate.IRotator;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.common.Mod;

public class RotatorRegistry {
    private Multimap<String, String> security = ArrayListMultimap.create();
    private Map<String, IRotator> registry = new HashMap<String, IRotator>();
    private static RotatorRegistry instance = new RotatorRegistry();

    private RotatorRegistry() {
    }

    public static RotatorRegistry getInstance() {
        return instance;
    }

    public void registerBlockRotator(Class<?> blockClass, IRotator rotator, Object modInstance) {
        if (modInstance.getClass().isAnnotationPresent(Mod.class)) {
            if (!this.registry.containsKey(blockClass.getName())) {
                Dungeons2.log.debug("Registering Rotator for " + blockClass.getName());
                this.registry.put(blockClass.getName(), rotator);
                String securityKey = null;
                Mod mod = modInstance.getClass().getAnnotation(Mod.class);
                securityKey = mod != null ? mod.modid() : modInstance.getClass().getName();
                this.security.put((Object)securityKey, (Object)blockClass.getName());
            } else {
                Dungeons2.log.warn("The class has already been registered.");
            }
        } else {
            Dungeons2.log.warn("Unable to register BlockRotator; mod instance object does not have the proper permissions.");
        }
    }

    private void registerBlockRotator(Class<?> clazz, IRotator rotator) {
        if (!this.registry.containsKey(clazz.getName())) {
            Dungeons2.log.debug("Registering Rotator for " + clazz.getName());
            this.registry.put(clazz.getName(), rotator);
        }
    }

    public void unregister(Class<?> clazz, Object modInstance) {
        if (modInstance.getClass().isAnnotationPresent(Mod.class)) {
            if (this.registry.containsKey(clazz.getName())) {
                String securityKey = null;
                Mod mod = modInstance.getClass().getAnnotation(Mod.class);
                securityKey = mod != null ? mod.modid() : modInstance.getClass().getName();
                if (this.security.get((Object)securityKey).contains(clazz.getName())) {
                    this.registry.remove(clazz.getName());
                    this.security.remove((Object)securityKey, clazz);
                } else {
                    Dungeons2.log.warn("Unable to unregister BlockRotator; mod instance object does not have the proper permissions.");
                }
            } else {
                Dungeons2.log.warn("The class is not registered with a BlockRotator");
            }
        } else {
            Dungeons2.log.warn("Unable to unregister BlockRotator; mod instance object does not have the proper permissions.");
        }
    }

    private void unregister(Class<?> clazz) {
        if (this.registry.containsKey(clazz.getName())) {
            this.registry.remove(clazz.getName());
        }
    }

    public IRotator get(Class<?> clazz) {
        if (this.registry.containsKey(clazz.getName())) {
            return this.registry.get(clazz.getName());
        }
        return null;
    }

    public boolean has(Class<?> clazz) {
        return this.registry.containsKey(clazz.getName());
    }
}

