/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.registry;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeons2.model.DungeonInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DungeonRegistry {
    private static final int MAX_SIZE = 25;
    private static DungeonRegistry instance = new DungeonRegistry();
    private ListMultimap<String, DungeonInfo> registry = LinkedListMultimap.create();

    private DungeonRegistry() {
    }

    public static DungeonRegistry getInstance() {
        return instance;
    }

    public boolean isRegistered(String key) {
        return this.registry.containsKey((Object)key);
    }

    public synchronized void register(String key, DungeonInfo info) {
        Dungeons2.log.debug("Registering dungeon using key: " + key);
        if (this.registry.size() >= 25) {
            String headKey = (String)this.registry.keySet().iterator().next();
            this.unregister(headKey);
        }
        this.registry.put((Object)key, (Object)info);
    }

    public synchronized void unregister(String key) {
        if (this.registry.containsKey((Object)key)) {
            this.registry.removeAll((Object)key);
        }
    }

    public List<DungeonInfo> get(String key) {
        List info = null;
        if (this.registry.containsKey((Object)key)) {
            info = this.registry.get((Object)key);
        }
        return info;
    }

    public List<DungeonInfo> getEntries() {
        HashSet set = Sets.newHashSet((Iterable)this.registry.values());
        return new ArrayList<DungeonInfo>(set);
    }
}

