/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.printer;

import com.someguyssoftware.dungeons2.model.Door;
import com.someguyssoftware.dungeons2.model.Hallway;
import java.util.Arrays;

public class HallwayPrettyPrinter {
    private static final String div;
    private static final String sub;
    private static String format;
    private static String format2;
    private static String heading;
    private static String heading2;

    public String print(Hallway hallway) {
        return this.print(hallway, "Hallway");
    }

    public String print(Hallway hallway, String title) {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(div).append(String.format(heading, title)).append(div).append(String.format(heading, "[Properties]")).append(String.format(format, "ID", hallway.getId())).append(String.format(format, "Name", hallway.getName()));
            if (hallway.getCoords() != null) {
                sb.append(String.format(format, "Location", hallway.getBottomCenter().toShortString()));
            }
            sb.append(String.format(format, new Object[]{"Type", hallway.getType()})).append(String.format(format, "Alignment", hallway.getAlignment()));
            if (hallway.getLayout() != null) {
                sb.append(String.format(format, "Layout", hallway.getLayout().getName()));
            }
            sb.append(String.format(format, "X Dimensions", String.format("%s <--> %s", hallway.getMinX(), hallway.getMaxX()))).append(String.format(format, "Y Dimensions", String.format("%s <--> %s", hallway.getMinY(), hallway.getMaxY()))).append(String.format(format, "Z Dimensions", String.format("%s <--> %s", hallway.getMinZ(), hallway.getMaxZ())));
            if (hallway.getDoors() != null) {
                sb.append(String.format(format, "# of Doors", hallway.getDoors().size()));
                for (Door d : hallway.getDoors()) {
                    sb.append(sub).append(String.format(heading2, "[Door]")).append(String.format(format2, "Location", d.getCoords().toShortString())).append(String.format(format2, "Direction", d.getDirection()));
                    if (d.getRoom() == null) continue;
                    sb.append(String.format(format2, "Leads To Room", d.getRoom().getId()));
                }
            }
            if (hallway.getHallway() != null) {
                sb.append(String.format(format2, "Leads to Hallway", hallway.getHallway().getId()));
            }
            sb.append(div);
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return sb.toString();
    }

    static {
        format = "**    %1$-33s: %2$-30s  **\n";
        format2 = "**++    %1$-31s: %2$-28s  ++**\n";
        heading = "**  %1$-67s  **\n";
        heading2 = "**++  %1$-63s  ++**\n";
        char[] chars = new char[75];
        Arrays.fill(chars, '*');
        div = new String(chars) + "\n";
        Arrays.fill(chars, '+');
        chars[74] = 42;
        chars[73] = 42;
        chars[1] = 42;
        chars[0] = 42;
        sub = new String(chars) + "\n";
    }
}

