/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.model;

import com.someguyssoftware.dungeons2.config.BuildDirection;
import com.someguyssoftware.dungeons2.config.BuildPattern;
import com.someguyssoftware.dungeons2.config.BuildSize;
import com.someguyssoftware.dungeons2.model.Dungeon;
import com.someguyssoftware.gottschcore.positional.ICoords;

public class DungeonInfo {
    private ICoords coords;
    private int levels;
    private int minX;
    private int maxX = 0;
    private int minY;
    private int maxY = 0;
    private int minZ;
    private int maxZ = 0;
    private String themeName;
    private ICoords bossChestCoords;
    private BuildPattern pattern;
    private BuildSize levelSize;
    private BuildSize size;
    private BuildDirection direction;

    public DungeonInfo() {
    }

    public DungeonInfo(Dungeon dungeon) {
        this.setCoords(dungeon.getEntrance().getBottomCenter());
        this.setLevels(dungeon.getLevels().size());
        this.setThemeName(dungeon.getTheme().getName());
        this.setMinX(dungeon.getMinX());
        this.setMaxX(dungeon.getMaxX());
        this.setMinY(dungeon.getMinY());
        this.setMaxY(dungeon.getMaxY());
        this.setMinZ(dungeon.getMinZ());
        this.setMaxZ(dungeon.getMaxZ());
    }

    public DungeonInfo(Dungeon dungeon, BuildPattern pattern, BuildSize dungeonSize, BuildSize levelSize, BuildDirection direction) {
        this(dungeon);
        this.setCoords(dungeon.getEntrance().getBottomCenter());
        this.setPattern(pattern);
        this.setSize(dungeonSize);
        this.setLevelSize(levelSize);
        this.setDirection(direction);
    }

    public ICoords getCoords() {
        return this.coords;
    }

    public void setCoords(ICoords coords) {
        this.coords = coords;
    }

    public int getLevels() {
        return this.levels;
    }

    public void setLevels(int levels) {
        this.levels = levels;
    }

    public int getMinX() {
        return this.minX;
    }

    public void setMinX(int minX) {
        this.minX = minX;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public void setMaxX(int maxX) {
        this.maxX = maxX;
    }

    public int getMinY() {
        return this.minY;
    }

    public void setMinY(int minY) {
        this.minY = minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public void setMaxY(int maxY) {
        this.maxY = maxY;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public void setMinZ(int minZ) {
        this.minZ = minZ;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public void setMaxZ(int maxZ) {
        this.maxZ = maxZ;
    }

    public String getThemeName() {
        return this.themeName;
    }

    public void setThemeName(String themeName) {
        this.themeName = themeName;
    }

    public ICoords getBossChestCoords() {
        return this.bossChestCoords;
    }

    public void setBossChestCoords(ICoords bossChestCoords) {
        this.bossChestCoords = bossChestCoords;
    }

    public BuildPattern getPattern() {
        return this.pattern;
    }

    public void setPattern(BuildPattern pattern) {
        this.pattern = pattern;
    }

    public BuildSize getLevelSize() {
        return this.levelSize;
    }

    public void setLevelSize(BuildSize size) {
        this.levelSize = size;
    }

    public BuildDirection getDirection() {
        return this.direction;
    }

    public void setDirection(BuildDirection direction) {
        this.direction = direction;
    }

    public BuildSize getSize() {
        return this.size;
    }

    public void setSize(BuildSize size) {
        this.size = size;
    }
}

