/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.loot;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.gottschcore.enums.Rarity;
import com.someguyssoftware.gottschcore.loot.LootTable;
import com.someguyssoftware.gottschcore.loot.LootTableMaster;
import com.someguyssoftware.gottschcore.mod.IMod;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public class DungeonLootTableMaster
extends LootTableMaster {
    private static final String CUSTOM_LOOT_TABLES_RESOURCE_PATH = "/loot_tables/";
    private static final String CUSTOM_LOOT_TABLES_PATH = "loot_tables";
    public static final String CUSTOM_LOOT_TABLE_KEY = "CUSTOM";
    private final Table<String, Rarity, List<ResourceLocation>> CHEST_LOOT_TABLES_RESOURCE_LOCATION_TABLE = HashBasedTable.create();
    private final Table<String, Rarity, List<LootTable>> CHEST_LOOT_TABLES_TABLE = HashBasedTable.create();
    private static final List<String> CHEST_LOOT_TABLE_FOLDER_LOCATIONS = ImmutableList.of((Object)"chests/common", (Object)"chests/uncommon", (Object)"chests/scarce", (Object)"chests/rare", (Object)"chests/boss");
    private static final List<String> NON_CHEST_LOOT_TABLE_FOLDER_LOCATIONS = ImmutableList.of((Object)"armor", (Object)"food", (Object)"items", (Object)"potions", (Object)"tools");

    public DungeonLootTableMaster(IMod mod, String resourcePath, String folderName) {
        super(mod, resourcePath, folderName);
        this.buildAndExpose(CUSTOM_LOOT_TABLES_RESOURCE_PATH, "dungeons2", CHEST_LOOT_TABLE_FOLDER_LOCATIONS);
        this.buildAndExpose(CUSTOM_LOOT_TABLES_RESOURCE_PATH, "dungeons2", NON_CHEST_LOOT_TABLE_FOLDER_LOCATIONS);
        for (Rarity r : Rarity.values()) {
            this.CHEST_LOOT_TABLES_RESOURCE_LOCATION_TABLE.put((Object)CUSTOM_LOOT_TABLE_KEY, (Object)r, new ArrayList());
            this.CHEST_LOOT_TABLES_TABLE.put((Object)CUSTOM_LOOT_TABLE_KEY, (Object)r, new ArrayList());
        }
    }

    public void register(String modID) {
        for (String location : CHEST_LOOT_TABLE_FOLDER_LOCATIONS) {
            List locs = this.getLootTablesResourceLocations(modID, location);
            for (ResourceLocation loc : locs) {
                Path path = Paths.get(loc.func_110623_a(), new String[0]);
                Dungeons2.log.debug("path to resource loc -> {}", (Object)path.toString());
                Rarity key = Rarity.valueOf((String)path.getName(path.getNameCount() - 2).toString().toUpperCase());
                ((List)this.CHEST_LOOT_TABLES_RESOURCE_LOCATION_TABLE.get((Object)CUSTOM_LOOT_TABLE_KEY, (Object)key)).add(loc);
                LootTable lootTable = this.getLootTableManager().getLootTableFromLocation(loc);
                ((List)this.CHEST_LOOT_TABLES_TABLE.get((Object)CUSTOM_LOOT_TABLE_KEY, (Object)key)).add(lootTable);
                Dungeons2.log.debug("tabling loot table: {} {} -> {}", (Object)CUSTOM_LOOT_TABLE_KEY, (Object)key, (Object)loc);
            }
        }
    }

    public List<LootTable> getLootTableByRarity(Rarity rarity) {
        ArrayList<LootTable> tables = new ArrayList<LootTable>();
        Map mapOfLootTables = this.CHEST_LOOT_TABLES_TABLE.column((Object)rarity);
        for (Map.Entry n : mapOfLootTables.entrySet()) {
            Dungeons2.log.debug("Adding table entry to loot table list -> {} {}: size {}", (Object)rarity, n.getKey(), (Object)((List)n.getValue()).size());
            tables.addAll((Collection)n.getValue());
        }
        return tables;
    }

    public Table<String, Rarity, List<LootTable>> getChestLootTablesTable() {
        return this.CHEST_LOOT_TABLES_TABLE;
    }
}

