/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.graph.mst;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.InputMismatchException;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.regex.Pattern;

public final class In {
    private static final String CHARSET_NAME = "UTF-8";
    private static final Locale LOCALE = Locale.US;
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\p{javaWhitespace}+");
    private static final Pattern EMPTY_PATTERN = Pattern.compile("");
    private static final Pattern EVERYTHING_PATTERN = Pattern.compile("\\A");
    private Scanner scanner;

    public In() {
        this.scanner = new Scanner((InputStream)new BufferedInputStream(System.in), CHARSET_NAME);
        this.scanner.useLocale(LOCALE);
    }

    public In(Socket socket) {
        if (socket == null) {
            throw new NullPointerException("argument is null");
        }
        try {
            InputStream is = socket.getInputStream();
            this.scanner = new Scanner((InputStream)new BufferedInputStream(is), CHARSET_NAME);
            this.scanner.useLocale(LOCALE);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Could not open " + socket);
        }
    }

    public In(URL url) {
        if (url == null) {
            throw new NullPointerException("argument is null");
        }
        try {
            URLConnection site = url.openConnection();
            InputStream is = site.getInputStream();
            this.scanner = new Scanner((InputStream)new BufferedInputStream(is), CHARSET_NAME);
            this.scanner.useLocale(LOCALE);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Could not open " + url);
        }
    }

    public In(File file) {
        if (file == null) {
            throw new NullPointerException("argument is null");
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            this.scanner = new Scanner((InputStream)new BufferedInputStream(fis), CHARSET_NAME);
            this.scanner.useLocale(LOCALE);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Could not open " + file);
        }
    }

    public In(String name) {
        if (name == null) {
            throw new NullPointerException("argument is null");
        }
        try {
            File file = new File(name);
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                this.scanner = new Scanner((InputStream)new BufferedInputStream(fis), CHARSET_NAME);
                this.scanner.useLocale(LOCALE);
                return;
            }
            URL url = this.getClass().getResource(name);
            if (url == null) {
                url = new URL(name);
            }
            URLConnection site = url.openConnection();
            InputStream is = site.getInputStream();
            this.scanner = new Scanner((InputStream)new BufferedInputStream(is), CHARSET_NAME);
            this.scanner.useLocale(LOCALE);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Could not open " + name);
        }
    }

    public In(Scanner scanner) {
        if (scanner == null) {
            throw new NullPointerException("argument is null");
        }
        this.scanner = scanner;
    }

    public boolean exists() {
        return this.scanner != null;
    }

    public boolean isEmpty() {
        return !this.scanner.hasNext();
    }

    public boolean hasNextLine() {
        return this.scanner.hasNextLine();
    }

    public boolean hasNextChar() {
        this.scanner.useDelimiter(EMPTY_PATTERN);
        boolean result = this.scanner.hasNext();
        this.scanner.useDelimiter(WHITESPACE_PATTERN);
        return result;
    }

    public String readLine() {
        String line;
        try {
            line = this.scanner.nextLine();
        }
        catch (NoSuchElementException e) {
            line = null;
        }
        return line;
    }

    public char readChar() {
        this.scanner.useDelimiter(EMPTY_PATTERN);
        String ch = this.scanner.next();
        assert (ch.length() == 1) : "Internal (Std)In.readChar() error! Please contact the authors.";
        this.scanner.useDelimiter(WHITESPACE_PATTERN);
        return ch.charAt(0);
    }

    public String readAll() {
        if (!this.scanner.hasNextLine()) {
            return "";
        }
        String result = this.scanner.useDelimiter(EVERYTHING_PATTERN).next();
        this.scanner.useDelimiter(WHITESPACE_PATTERN);
        return result;
    }

    public String readString() {
        return this.scanner.next();
    }

    public int readInt() {
        return this.scanner.nextInt();
    }

    public double readDouble() {
        return this.scanner.nextDouble();
    }

    public float readFloat() {
        return this.scanner.nextFloat();
    }

    public long readLong() {
        return this.scanner.nextLong();
    }

    public short readShort() {
        return this.scanner.nextShort();
    }

    public byte readByte() {
        return this.scanner.nextByte();
    }

    public boolean readBoolean() {
        String s = this.readString();
        if (s.equalsIgnoreCase("true")) {
            return true;
        }
        if (s.equalsIgnoreCase("false")) {
            return false;
        }
        if (s.equals("1")) {
            return true;
        }
        if (s.equals("0")) {
            return false;
        }
        throw new InputMismatchException();
    }

    public String[] readAllStrings() {
        String[] tokens = WHITESPACE_PATTERN.split(this.readAll());
        if (tokens.length == 0 || tokens[0].length() > 0) {
            return tokens;
        }
        String[] decapitokens = new String[tokens.length - 1];
        for (int i = 0; i < tokens.length - 1; ++i) {
            decapitokens[i] = tokens[i + 1];
        }
        return decapitokens;
    }

    public String[] readAllLines() {
        ArrayList<String> lines = new ArrayList<String>();
        while (this.hasNextLine()) {
            lines.add(this.readLine());
        }
        return lines.toArray(new String[0]);
    }

    public int[] readAllInts() {
        String[] fields = this.readAllStrings();
        int[] vals = new int[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            vals[i] = Integer.parseInt(fields[i]);
        }
        return vals;
    }

    public long[] readAllLongs() {
        String[] fields = this.readAllStrings();
        long[] vals = new long[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            vals[i] = Long.parseLong(fields[i]);
        }
        return vals;
    }

    public double[] readAllDoubles() {
        String[] fields = this.readAllStrings();
        double[] vals = new double[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            vals[i] = Double.parseDouble(fields[i]);
        }
        return vals;
    }

    public void close() {
        this.scanner.close();
    }

    @Deprecated
    public static int[] readInts(String filename) {
        return new In(filename).readAllInts();
    }

    @Deprecated
    public static double[] readDoubles(String filename) {
        return new In(filename).readAllDoubles();
    }

    @Deprecated
    public static String[] readStrings(String filename) {
        return new In(filename).readAllStrings();
    }

    @Deprecated
    public static int[] readInts() {
        return new In().readAllInts();
    }

    @Deprecated
    public static double[] readDoubles() {
        return new In().readAllDoubles();
    }

    @Deprecated
    public static String[] readStrings() {
        return new In().readAllStrings();
    }
}

