/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.graph.mst;

public class Edge
implements Comparable<Edge> {
    public final int v;
    public final int w;
    private final double weight;

    public Edge(int v, int w, double weight) {
        if (v < 0) {
            throw new IndexOutOfBoundsException("Vertex NAME must be a nonnegative integer");
        }
        if (w < 0) {
            throw new IndexOutOfBoundsException("Vertex NAME must be a nonnegative integer");
        }
        if (Double.isNaN(weight)) {
            throw new IllegalArgumentException("Weight is NaN");
        }
        this.v = v;
        this.w = w;
        this.weight = weight;
    }

    public double weight() {
        return this.weight;
    }

    public int either() {
        return this.v;
    }

    public int other(int vertex) {
        if (vertex == this.v) {
            return this.w;
        }
        if (vertex == this.w) {
            return this.v;
        }
        throw new IllegalArgumentException("Illegal endpoint");
    }

    @Override
    public int compareTo(Edge that) {
        return Double.compare(this.weight, that.weight);
    }

    public String toString() {
        return String.format("%d-%d %.5f", this.v, this.w, this.weight);
    }
}

