/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.graph;

import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;

public class Waypoint {
    private int id;
    private ICoords coords;
    private boolean terminated;

    public Waypoint(int id, ICoords coords) {
        this.setId(id);
        this.setCoords(coords);
        this.setTerminated(true);
    }

    public Waypoint(int id, ICoords coords, boolean isTerminal) {
        this.setId(id);
        this.setCoords(coords);
        this.setTerminated(isTerminal);
    }

    public Waypoint(int id, int x, int y, int z) {
        this.setId(id);
        this.setCoords((ICoords)new Coords(x, y, z));
        this.setTerminated(true);
    }

    public Waypoint(Waypoint p) {
        this(p.getId(), (ICoords)new Coords(p.getCoords()), p.isTerminated());
    }

    public Waypoint(int id, int x, int y, int z, boolean isTerminal) {
        this.setId(id);
        this.setCoords((ICoords)new Coords(x, y, z));
        this.setTerminated(isTerminal);
    }

    public Waypoint(int x, int y, int z) {
        this(-1, x, y, z);
        this.setTerminated(true);
    }

    public void add(int x, int y, int z) {
        ICoords newCoords = this.getCoords().add(x, y, z);
        this.setCoords(newCoords);
    }

    public int getX() {
        return this.coords.getX();
    }

    public int getY() {
        return this.coords.getY();
    }

    public int getZ() {
        return this.coords.getZ();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public ICoords getCoords() {
        return this.coords;
    }

    public void setCoords(ICoords coords) {
        this.coords = coords;
    }

    public String toString() {
        return "Waypoint [id=" + this.id + ", coords=" + this.coords + ", terminated=" + this.terminated + "]";
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void setTerminated(boolean terminal) {
        this.terminated = terminal;
    }
}

